/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.AbstractObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RefListEditingDialog
extends AbstractObjectEditingDialog {
    protected EStructuralFeature feature;
    org.eclipse.swt.widgets.List sourceList;
    Button addButton;
    Button removeButton;
    Button addAllButton;
    Button removeAllButton;
    Button moveUpButton;
    Button moveDownButton;
    org.eclipse.swt.widgets.List targetList;
    List<EObject> result = new ArrayList<EObject>();

    public RefListEditingDialog(DiagramEditor editor, EObject object, EStructuralFeature feature) {
        super(editor, object);
        this.feature = feature;
    }

    @Override
    protected Composite createDialogContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.sourceList = new org.eclipse.swt.widgets.List(composite, 2050);
        this.sourceList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sourceList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefListEditingDialog.this.updateButtons();
            }
        });
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        buttons.setLayout((Layout)new FillLayout(512));
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(Messages.RefListEditingDialog_Add);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefListEditingDialog.this.moveSelection(RefListEditingDialog.this.sourceList, RefListEditingDialog.this.targetList);
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(Messages.RefListEditingDialog_Remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefListEditingDialog.this.moveSelection(RefListEditingDialog.this.targetList, RefListEditingDialog.this.sourceList);
            }
        });
        this.addAllButton = new Button(buttons, 8);
        this.addAllButton.setText(Messages.RefListEditingDialog_Add_All);
        this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefListEditingDialog.this.sourceList.selectAll();
                RefListEditingDialog.this.moveSelection(RefListEditingDialog.this.sourceList, RefListEditingDialog.this.targetList);
            }
        });
        this.removeAllButton = new Button(buttons, 8);
        this.removeAllButton.setText(Messages.RefListEditingDialog_Remove_All);
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefListEditingDialog.this.targetList.selectAll();
                RefListEditingDialog.this.moveSelection(RefListEditingDialog.this.targetList, RefListEditingDialog.this.sourceList);
            }
        });
        this.moveUpButton = new Button(buttons, 8);
        this.moveUpButton.setText(Messages.RefListEditingDialog_Move_Up);
        this.moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefListEditingDialog.this.moveUp();
            }
        });
        this.moveDownButton = new Button(buttons, 8);
        this.moveDownButton.setText(Messages.RefListEditingDialog_Move_Down);
        this.moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefListEditingDialog.this.moveDown();
            }
        });
        this.targetList = new org.eclipse.swt.widgets.List(composite, 2050);
        this.targetList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.targetList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefListEditingDialog.this.updateButtons();
            }
        });
        List targets = (List)this.object.eGet(this.feature);
        for (EObject value : targets) {
            String key = "" + this.targetList.getItemCount();
            this.targetList.add(ExtendedPropertiesProvider.getTextValue(value));
            this.targetList.setData(key, (Object)value);
        }
        Hashtable<String, Object> sources = ExtendedPropertiesProvider.getChoiceOfValues(this.object, this.feature);
        for (Map.Entry<String, Object> entry : sources.entrySet()) {
            if (targets.contains(entry.getValue())) continue;
            String key = "" + this.sourceList.getItemCount();
            this.sourceList.add(entry.getKey());
            Object value = entry.getValue();
            Assert.isTrue((boolean)(value instanceof EObject));
            this.sourceList.setData(key, value);
        }
        this.updateButtons();
        return composite;
    }

    public List<EObject> getResult() {
        return this.result;
    }

    @Override
    protected void okPressed() {
        int size = this.targetList.getItemCount();
        int i = 0;
        while (i < size) {
            String key = "" + i;
            this.result.add((EObject)this.targetList.getData(key));
            ++i;
        }
        super.okPressed();
    }

    private void moveSelection(org.eclipse.swt.widgets.List sourceList, org.eclipse.swt.widgets.List targetList) {
        int[] sourceIndex = sourceList.getSelectionIndices();
        int[] targetIndex = new int[sourceIndex.length];
        int i = 0;
        while (i < sourceIndex.length) {
            targetIndex[i] = targetList.getItemCount();
            String key = "" + sourceIndex[i];
            Object value = sourceList.getData(key);
            String s = sourceList.getItem(sourceIndex[i]);
            targetList.add(s);
            key = "" + targetIndex[i];
            targetList.setData(key, value);
            ++i;
        }
        sourceList.remove(sourceIndex);
        targetList.select(targetIndex);
        this.updateButtons();
    }

    private void moveUp() {
        int index = this.targetList.getSelectionIndex();
        Assert.isTrue((index > 0 ? 1 : 0) != 0);
        this.swap(index, index - 1);
    }

    private void moveDown() {
        int index = this.targetList.getSelectionIndex();
        int end = this.targetList.getItemCount() - 1;
        Assert.isTrue((index > 0 && index < end ? 1 : 0) != 0);
        this.swap(index, index + 1);
    }

    private void swap(int index1, int index2) {
        String item1 = this.targetList.getItem(index1);
        String key1 = "" + index1;
        Object value1 = this.targetList.getData(key1);
        String key2 = "" + index2;
        Object value2 = this.targetList.getData(key2);
        this.targetList.remove(index1);
        this.targetList.add(item1, index2);
        this.targetList.setData(key1, value2);
        this.targetList.setData(key2, value1);
        this.targetList.setSelection(index2);
        this.updateButtons();
    }

    private void updateButtons() {
        this.addButton.setEnabled(this.sourceList.getSelectionCount() > 0);
        this.removeButton.setEnabled(this.targetList.getSelectionCount() > 0);
        this.addAllButton.setEnabled(this.sourceList.getItemCount() > 0);
        this.removeAllButton.setEnabled(this.targetList.getItemCount() > 0);
        if (this.targetList.getSelectionCount() == 1) {
            int end = this.targetList.getItemCount() - 1;
            int index = this.targetList.getSelectionIndex();
            this.moveUpButton.setEnabled(index != 0);
            this.moveDownButton.setEnabled(index != end);
        } else {
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        }
    }

    @Override
    protected String getPreferenceKey() {
        return String.valueOf(this.object.eClass().getName()) + "." + this.feature.getName();
    }
}

