/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.providers;

import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.property.providers.TreeNode;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.swt.graphics.Image;

public class JavaMemberTreeNode
extends TreeNode {
    public JavaMemberTreeNode(Object modelObject, boolean isCondensed) {
        super(modelObject, isCondensed);
    }

    @Override
    public String getLabel() {
        IMethod m;
        IMember member = (IMember)this.modelObject;
        String label = "";
        String name = member.getElementName();
        if (member instanceof IField) {
            IField f = (IField)member;
            try {
                label = String.valueOf(label) + Signature.getSignatureSimpleName((String)f.getTypeSignature()) + " ";
            }
            catch (JavaModelException javaModelException) {}
        }
        if (member instanceof IMethod) {
            m = (IMethod)member;
            try {
                label = String.valueOf(label) + Signature.getSignatureSimpleName((String)m.getReturnType()) + " ";
            }
            catch (JavaModelException javaModelException) {}
        }
        label = String.valueOf(label) + name;
        if (member instanceof IMethod) {
            m = (IMethod)member;
            if (m.getParameterTypes().length > 0) {
                label = String.valueOf(label) + "(";
                String[] p = m.getParameterTypes();
                int i = 0;
                while (i < p.length) {
                    label = String.valueOf(label) + Signature.getSignatureSimpleName((String)p[i]);
                    if (i + 1 < p.length) {
                        label = String.valueOf(label) + ", ";
                    }
                    ++i;
                }
                label = String.valueOf(label) + ")";
            } else {
                label = String.valueOf(label) + "()";
            }
        }
        return label;
    }

    @Override
    public Image getImage() {
        if (this.modelObject instanceof IMethod) {
            return Activator.getDefault().getImage("obj16/javaPublicMethod.png");
        }
        if (this.modelObject instanceof IField) {
            return Activator.getDefault().getImage("obj16/javaPublicField.png");
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public Object[] getChildren() {
        return null;
    }
}

