/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.ui.text;

import org.eclipse.dltk.sh.internal.ui.Activator;
import org.eclipse.dltk.sh.internal.ui.text.DocumentAndCommandScanner;
import org.eclipse.dltk.sh.internal.ui.text.IndentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;

public class ScriptAutoIndentStrategy
implements IAutoEditStrategy {
    private final DocumentAndCommandScanner scanner = new DocumentAndCommandScanner();

    public void setRules(IRule[] rules) {
        this.scanner.setRules(rules);
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        int delim = TextUtilities.endsWith((String[])d.getLegalLineDelimiters(), (String)c.text);
        if (c.length == 0 && c.text != null && delim != -1) {
            this.smartIndentAfterNewLine(d, c);
        } else if (c.text.length() == 1 && !c.text.equals("#")) {
            this.smartIndentAfterKeypress(d, c);
        } else if (c.text.length() > 1) {
            c.text = c.text.trim();
        }
    }

    protected void smartIndentAfterNewLine(IDocument document, DocumentCommand c) {
        if (c.offset == -1 || document.getLength() == 0) {
            return;
        }
        try {
            StringBuilder buf = new StringBuilder(c.text);
            int p = c.offset == document.getLength() ? c.offset - 1 : c.offset;
            int line = document.getLineOfOffset(p);
            int start = document.getLineOffset(line);
            int bracketCount = this.getBracketCount(document, null, start, c.offset, true);
            String indentOfLine = ScriptAutoIndentStrategy.getIndentOfLine(document, line, p);
            String indentation = ScriptAutoIndentStrategy.generateIndentation(indentOfLine, bracketCount <= 0 ? 0 : 1);
            buf.append(indentation);
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void smartIndentAfterKeypress(IDocument document, DocumentCommand c) {
        if (c.offset == -1 || document.getLength() == 0 || c.text.trim().isEmpty()) {
            return;
        }
        try {
            StringBuilder buf = new StringBuilder();
            int p = c.offset;
            int line = document.getLineOfOffset(p);
            int start = document.getLineOffset(line);
            int whiteEnd = ScriptAutoIndentStrategy.findEndOfWhiteSpace(document, start, c.offset);
            int bracketCount = this.getBracketCount(document, c, start, c.offset, false);
            buf.append(ScriptAutoIndentStrategy.generateIndentation(ScriptAutoIndentStrategy.getIndentOfLine(document, line, p), bracketCount >= 0 ? 0 : -1));
            buf.append(document.get(whiteEnd, c.offset - whiteEnd));
            buf.append(c.text);
            c.length = c.offset - start + c.length;
            c.offset = start;
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    private static String getIndentOfLine(IDocument document, int line, int offset) throws BadLocationException {
        if (line > -1) {
            int start = document.getLineOffset(line);
            int whiteend = ScriptAutoIndentStrategy.findEndOfWhiteSpace(document, start, offset);
            return document.get(start, whiteend - start);
        }
        return "";
    }

    private int getBracketCount(IDocument document, DocumentCommand command, int start, int end, boolean ignoreInflexions) {
        IToken token;
        int bracketcount = 0;
        if (command != null) {
            this.scanner.setRange(document, command, start, end - start);
        } else {
            this.scanner.setRange(document, start, end - start);
        }
        while (!(token = this.scanner.nextToken()).isEOF()) {
            if (!token.isOther() || !(token.getData() instanceof IndentType)) continue;
            IndentType type = (IndentType)token.getData();
            if (type == IndentType.INCREMENT) {
                ++bracketcount;
                continue;
            }
            if (type == IndentType.DECREMENT) {
                --bracketcount;
                continue;
            }
            if (type == IndentType.INFLEXION && ignoreInflexions) {
                ++bracketcount;
                continue;
            }
            if (type != IndentType.INFLEXION || ignoreInflexions) continue;
            --bracketcount;
        }
        return bracketcount;
    }

    private static String generateIndentation(String previous, int additional) {
        int spaces;
        int tabs;
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String tabChar = prefs.getString("formatter.tabulation.char");
        int indentSize = prefs.getInt("formatter.indentation.size");
        int tabSize = prefs.getInt("formatter.tabulation.size");
        int preLength = ScriptAutoIndentStrategy.computeVisualLength(previous, tabSize);
        int addLength = indentSize * additional;
        int endLength = Math.max(0, preLength + addLength);
        int minLength = Math.min(endLength, preLength);
        String indent = ScriptAutoIndentStrategy.stripExtraChars(previous, minLength, tabSize);
        int missing = endLength - minLength;
        if ("space".equals(tabChar)) {
            tabs = 0;
            spaces = missing;
        } else if ("tab".equals(tabChar)) {
            tabs = missing / indentSize;
            spaces = 0;
        } else if ("mixed".equals(tabChar)) {
            tabs = tabSize > 0 ? missing / tabSize : 0;
            spaces = tabSize > 0 ? missing % tabSize : missing;
        } else {
            tabs = 0;
            spaces = 0;
        }
        int i = 0;
        while (i < tabs) {
            indent = String.valueOf(indent) + "\t";
            ++i;
        }
        i = 0;
        while (i < spaces) {
            indent = String.valueOf(indent) + " ";
            ++i;
        }
        return indent;
    }

    private static int computeVisualLength(String indent, int tabSize) {
        int length = 0;
        int i = 0;
        while (i < indent.length()) {
            char ch = indent.charAt(i);
            switch (ch) {
                case '\t': {
                    if (tabSize <= 0) break;
                    length += tabSize;
                    break;
                }
                case ' ': {
                    ++length;
                }
            }
            ++i;
        }
        return length;
    }

    private static String stripExtraChars(String indent, int max, int tabSize) {
        int measured = 0;
        int i = 0;
        while (measured < max && i < indent.length()) {
            char ch = indent.charAt(i);
            switch (ch) {
                case '\t': {
                    if (tabSize <= 0) break;
                    int reminder = measured % tabSize;
                    measured += tabSize - reminder;
                    break;
                }
                case ' ': {
                    ++measured;
                }
            }
            ++i;
        }
        return indent.substring(0, measured > max ? i - 1 : i);
    }
}

