/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.base.DLTKChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.Utils;
import org.eclipse.dltk.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IProjectFragmentManipulationQuery;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.internal.ui.model.DLTKElementResourceMapping;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

abstract class ProjectFragmentReorgChange
extends DLTKChange {
    private final String fRootHandle;
    private final IPath fDestinationPath;
    private final INewNameQuery fNewNameQuery;
    private final IProjectFragmentManipulationQuery fUpdateBuildpathQuery;

    ProjectFragmentReorgChange(IProjectFragment root, IProject destination, INewNameQuery newNameQuery, IProjectFragmentManipulationQuery updateBuildpathQuery) {
        Assert.isTrue((!root.isExternal() ? 1 : 0) != 0);
        this.fRootHandle = root.getHandleIdentifier();
        this.fDestinationPath = Utils.getResourcePath((IResource)destination);
        this.fNewNameQuery = newNameQuery;
        this.fUpdateBuildpathQuery = updateBuildpathQuery;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return this.isValid(pm, 0);
    }

    public final Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask(this.getName(), 2);
        try {
            String newName = this.getNewResourceName();
            IProjectFragment root = this.getRoot();
            ResourceMapping mapping = DLTKElementResourceMapping.create(root);
            Change result = this.doPerformReorg(this.getDestinationProjectPath().append(newName), (IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.markAsExecuted(root, mapping);
            Change change = result;
            return change;
        }
        finally {
            pm.done();
        }
    }

    protected abstract Change doPerformReorg(IPath var1, IProgressMonitor var2) throws ModelException;

    public Object getModifiedElement() {
        return this.getRoot();
    }

    protected IProjectFragment getRoot() {
        return (IProjectFragment)DLTKCore.create((String)this.fRootHandle);
    }

    protected IPath getDestinationProjectPath() {
        return this.fDestinationPath;
    }

    protected IProject getDestinationProject() {
        return Utils.getProject(this.getDestinationProjectPath());
    }

    private String getNewResourceName() {
        if (this.fNewNameQuery == null) {
            return this.getRoot().getElementName();
        }
        String name = this.fNewNameQuery.getNewName();
        if (name == null) {
            return this.getRoot().getElementName();
        }
        return name;
    }

    protected int getUpdateModelFlags(boolean isCopy) throws ModelException {
        int otherProjects;
        int originating;
        int destination = 8;
        int replace = 16;
        if (isCopy) {
            originating = 0;
            otherProjects = 0;
        } else {
            originating = 2;
            otherProjects = 4;
        }
        if (!DLTKCore.create((IProject)this.getDestinationProject()).exists()) {
            return 0x10 | originating;
        }
        if (this.fUpdateBuildpathQuery == null) {
            return 0x10 | originating | 8;
        }
        IScriptProject[] referencingProjects = ModelElementUtil.getReferencingProjects(this.getRoot());
        if (referencingProjects.length == 0) {
            return 0x10 | originating | 8;
        }
        boolean updateOtherProjectsToo = this.fUpdateBuildpathQuery.confirmManipulation(this.getRoot(), referencingProjects);
        if (updateOtherProjectsToo) {
            return 0x10 | originating | 8 | otherProjects;
        }
        return 0x10 | originating | 8;
    }

    protected int getResourceUpdateFlags() {
        return 34;
    }

    private void markAsExecuted(IProjectFragment root, ResourceMapping mapping) {
        ReorgExecutionLog log = (ReorgExecutionLog)this.getAdapter(ReorgExecutionLog.class);
        if (log != null) {
            log.markAsProcessed((Object)root);
            log.markAsProcessed((Object)mapping);
        }
    }
}

