/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildpathContainerWizard;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;

public class AddLibraryToBuildpathAction
extends Action
implements ISelectionChangedListener {
    private IScriptProject fSelectedProject;
    private final IWorkbenchSite fSite;

    public AddLibraryToBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddLibCP_label, DLTKPluginImages.DESC_OBJS_LIBRARY);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddLibCP_tooltip);
        this.fSite = site;
    }

    public void run() {
        IBuildpathEntry[] Buildpath;
        final IScriptProject project = this.fSelectedProject;
        Shell shell = this.fSite.getShell();
        if (shell == null) {
            shell = DLTKUIPlugin.getActiveWorkbenchShell();
        }
        try {
            Buildpath = project.getRawBuildpath();
        }
        catch (ModelException e1) {
            this.showExceptionDialog((CoreException)((Object)e1));
            return;
        }
        BuildpathContainerWizard wizard = new BuildpathContainerWizard(null, project, Buildpath){

            @Override
            public boolean performFinish() {
                if (super.performFinish()) {
                    IWorkspaceRunnable op = monitor -> {
                        try {
                            this.finishPage(monitor);
                        }
                        catch (InterruptedException e) {
                            throw new OperationCanceledException(e.getMessage());
                        }
                    };
                    try {
                        ISchedulingRule rule = null;
                        Job job = Job.getJobManager().currentJob();
                        if (job != null) {
                            rule = job.getRule();
                        }
                        WorkbenchRunnableAdapter runnable = null;
                        runnable = rule != null ? new WorkbenchRunnableAdapter(op, rule, true) : new WorkbenchRunnableAdapter(op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        this.getContainer().run(false, true, (IRunnableWithProgress)runnable);
                    }
                    catch (InvocationTargetException e) {
                        DLTKUIPlugin.log(e);
                        return false;
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                    return true;
                }
                return false;
            }

            private void finishPage(IProgressMonitor pm) throws InterruptedException {
                IBuildpathEntry[] selected = this.getNewEntries();
                if (selected != null) {
                    try {
                        try {
                            pm.beginTask(NewWizardMessages.BuildpathModifier_Monitor_AddToBuildpath, 4);
                            ArrayList<BPListElement> addedEntries = new ArrayList<BPListElement>();
                            int i = 0;
                            while (i < selected.length) {
                                BPListElement listElement = BPListElement.createFromExisting(selected[i], project);
                                addedEntries.add(listElement);
                                ++i;
                            }
                            pm.worked(1);
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            List<BPListElement> existingEntries = BuildpathModifier.getExistingEntries(project);
                            BuildpathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            BuildpathModifier.commitBuildPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            ArrayList<BuildPathContainer> result = new ArrayList<BuildPathContainer>(addedEntries.size());
                            int i2 = 0;
                            while (i2 < addedEntries.size()) {
                                result.add(new BuildPathContainer(project, selected[i2]));
                                ++i2;
                            }
                            AddLibraryToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                            pm.worked(1);
                        }
                        catch (CoreException e) {
                            AddLibraryToBuildpathAction.this.showExceptionDialog(e);
                            pm.done();
                        }
                    }
                    finally {
                        pm.done();
                    }
                }
            }
        };
        wizard.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)shell);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    public boolean canHandle(IStructuredSelection selection) {
        IScriptProject scriptProject;
        if (selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        if (first instanceof IScriptProject) {
            this.fSelectedProject = (IScriptProject)first;
            return true;
        }
        if (first instanceof IProject && (scriptProject = DLTKCore.create((IProject)((IProject)first))).isValid()) {
            this.fSelectedProject = scriptProject;
            return true;
        }
        return false;
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.AddLibraryToBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(ISelection selection) {
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(() -> finalTarget.selectReveal(selection));
        }
    }
}

