/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.net.URISyntaxException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.CloneCommand;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class PasteCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String errorMessage = null;
        Clipboard clip = new Clipboard(this.getShell(event).getDisplay());
        try {
            String content = (String)clip.getContents((Transfer)TextTransfer.getInstance());
            if (content == null) {
                errorMessage = UIText.RepositoriesView_NothingToPasteMessage;
                return null;
            }
            File file = new File(content);
            if (!file.exists() || !file.isDirectory()) {
                URIish cloneURI = this.getCloneURI(content);
                if (cloneURI == null) {
                    errorMessage = UIText.RepositoriesView_ClipboardContentNotDirectoryOrURIMessage;
                    return null;
                }
                CloneCommand cmd = new CloneCommand(cloneURI.toString());
                cmd.execute(event);
                return null;
            }
            if (!RepositoryCache.FileKey.isGitRepository((File)file, (FS)FS.DETECTED) && !RepositoryCache.FileKey.isGitRepository((File)(file = new File(file, ".git")), (FS)FS.DETECTED)) {
                errorMessage = NLS.bind((String)UIText.RepositoriesView_ClipboardContentNoGitRepoMessage, (Object)content);
                return null;
            }
            if (!this.util.addConfiguredRepository(file)) {
                errorMessage = NLS.bind((String)UIText.RepositoriesView_PasteRepoAlreadyThere, (Object)content);
            }
            return null;
        }
        finally {
            clip.dispose();
            if (errorMessage != null) {
                Activator.showError(errorMessage, null);
            }
        }
    }

    private URIish getCloneURI(String content) {
        if (content.startsWith("git clone")) {
            content = content.substring("git clone".length());
        }
        try {
            URIish finalURI = new URIish(content.trim());
            if (RepositorySelectionPage.Protocol.FILE.handles(finalURI) || RepositorySelectionPage.Protocol.GIT.handles(finalURI) || RepositorySelectionPage.Protocol.HTTP.handles(finalURI) || RepositorySelectionPage.Protocol.HTTPS.handles(finalURI) || RepositorySelectionPage.Protocol.SSH.handles(finalURI)) {
                return finalURI;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }
}

