/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyItem;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyListElementItem;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyValuePlaceholderItem;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.widgets.TreeItem;

class PropertyDescriptorItem
extends PropertyItem {
    private final Object object;
    private Diff propertyDiff;
    private final Object editableValue;
    private List<?> listValue;
    private final Object propertyValue;
    final Multimap<Object, Diff> diffs;
    private final IItemPropertyDescriptor itemPropertyDescriptor;
    private boolean hasCheckedForChildren;
    private boolean needsReconcile;

    public PropertyDescriptorItem(EMFCompareConfiguration configuration, Object object, Multimap<Object, Diff> diffs, IItemPropertyDescriptor itemPropertyDescriptor, IMergeViewer.MergeViewerSide side) {
        super(configuration, null, itemPropertyDescriptor.getDisplayName(object), side);
        this.itemPropertyDescriptor = itemPropertyDescriptor;
        this.object = object;
        this.diffs = diffs;
        this.propertyValue = itemPropertyDescriptor.getPropertyValue(object);
        if (this.propertyValue instanceof IItemPropertySource) {
            IItemPropertySource itemPropertySource = (IItemPropertySource)this.propertyValue;
            this.editableValue = itemPropertySource.getEditableValue(object);
        } else {
            this.editableValue = this.propertyValue;
        }
        this.listValue = this.editableValue instanceof List ? (List)this.editableValue : null;
        IMergeViewer.MergeViewerSide matchSide = this.getSide(PropertyDescriptorItem.getMatch(configuration, object));
        Object feature = itemPropertyDescriptor.getFeature(object);
        if (this.listValue == null) {
            this.propertyDiff = this.getDiff(this.editableValue, matchSide);
        } else if (feature instanceof EStructuralFeature && !((EStructuralFeature)feature).isMany() && diffs != null && !diffs.keySet().isEmpty()) {
            this.propertyDiff = this.getDiff(diffs.keySet().iterator().next(), matchSide);
        }
        this.initializeListOfValueChildren();
    }

    private void initializeListOfValueChildren() {
        if (this.getListValue() == null) {
            return;
        }
        EList<PropertyItem> propertyItems = this.getPropertyItems();
        for (Object value : this.getListValue()) {
            Diff diff = this.getDiff(value, this.getSide());
            propertyItems.add((Object)new PropertyListElementItem(this.getConfiguration(), this.getLabelProvider(), diff, value, this.getSide()));
        }
        if (this.haveDiffs()) {
            this.createPlaceholders(propertyItems);
        }
    }

    private void createPlaceholders(EList<PropertyItem> propertyItems) {
        if (this.getSide() == IMergeViewer.MergeViewerSide.LEFT || this.getSide() == IMergeViewer.MergeViewerSide.RIGHT) {
            HashSet usedDiffs = Sets.newHashSet();
            Comparison comparison = this.getConfiguration().getComparison();
            for (Map.Entry entry : this.diffs.entries()) {
                int index;
                EStructuralFeature affectedFeature;
                Object value = entry.getKey();
                Diff diff = (Diff)entry.getValue();
                if (!usedDiffs.add(diff) || (affectedFeature = MergeViewerUtil.getAffectedFeature((Diff)diff)) == null || !affectedFeature.isMany()) continue;
                int insertionIndex = DiffUtil.findInsertionIndex((Comparison)comparison, (Diff)diff, (this.getSide() == IMergeViewer.MergeViewerSide.LEFT ? 1 : 0) != 0);
                if (propertyItems.size() > 0) {
                    List subList = propertyItems.subList(0, insertionIndex);
                    int count = Iterables.size((Iterable)Iterables.filter((Iterable)subList, (Predicate)IMergeViewerItem.IS_INSERTION_POINT));
                    index = Math.min(insertionIndex + count, propertyItems.size());
                } else {
                    index = 0;
                }
                PropertyValuePlaceholderItem placeholderItem = new PropertyValuePlaceholderItem(this.getConfiguration(), diff, value, this.getSide());
                propertyItems.add(index, (Object)placeholderItem);
            }
        }
    }

    private boolean haveDiffs() {
        return this.diffs != null && !this.diffs.isEmpty();
    }

    private IItemLabelProvider getLabelProvider() {
        return this.itemPropertyDescriptor.getLabelProvider(this.object);
    }

    private IMergeViewer.MergeViewerSide getSide(Match match) {
        if (match == null) {
            return null;
        }
        if (match.getOrigin() == this.object) {
            return IMergeViewer.MergeViewerSide.ANCESTOR;
        }
        if (match.getLeft() == this.object) {
            return IMergeViewer.MergeViewerSide.LEFT;
        }
        if (match.getRight() == this.object) {
            return IMergeViewer.MergeViewerSide.RIGHT;
        }
        return null;
    }

    private Diff getDiff(Object value, IMergeViewer.MergeViewerSide preferredSide) {
        if (!this.haveDiffs() || this.diffs.get(value) == null || this.diffs.get(value).isEmpty()) {
            return null;
        }
        Diff result = null;
        Collection diffCandidates = this.diffs.get(value);
        if (preferredSide != null) {
            Iterator diffIterator = diffCandidates.iterator();
            while (result == null && diffIterator.hasNext()) {
                Diff candidate = (Diff)diffIterator.next();
                if (!this.isDiffOnSide(candidate, preferredSide)) continue;
                result = candidate;
            }
        }
        if (result == null) {
            result = (Diff)diffCandidates.iterator().next();
        }
        this.diffs.values().removeAll(Collections.singleton(result));
        return result;
    }

    private boolean isDiffOnSide(Diff diff, IMergeViewer.MergeViewerSide side) {
        return IMergeViewer.MergeViewerSide.LEFT == side && diff.getSource() == DifferenceSource.LEFT || IMergeViewer.MergeViewerSide.RIGHT == side && diff.getSource() == DifferenceSource.RIGHT;
    }

    @Override
    protected Object getObject() {
        return this.propertyValue;
    }

    @Override
    protected boolean isMatchingItem(PropertyItem propertyItem) {
        return propertyItem instanceof PropertyDescriptorItem && this.itemPropertyDescriptor.getDisplayName(this.object).equals(propertyItem.getText());
    }

    @Override
    protected boolean isModified() {
        if (this.haveDiffs()) {
            return true;
        }
        boolean isList = this.isList();
        boolean result = false;
        int i = 0;
        while (i < PropertyContentMergeViewer.MERGE_VIEWER_SIDES.length && !result) {
            PropertyDescriptorItem sidePropertyItem;
            IMergeViewer.MergeViewerSide otherSide = PropertyContentMergeViewer.MERGE_VIEWER_SIDES[i];
            if (otherSide != this.getSide() && (sidePropertyItem = this.getSide(otherSide)) != null) {
                if (isList) {
                    result = !this.equivalentLists(this.getListValue(), sidePropertyItem.getListValue());
                } else if (!isList) {
                    result = !Objects.equals(this.getPropertyText(), sidePropertyItem.getPropertyText());
                }
            }
            ++i;
        }
        return result;
    }

    private boolean equivalentLists(List<?> list, List<?> otherList) {
        if (list == null) {
            return otherList != null;
        }
        if (otherList == null) {
            return false;
        }
        if (list.size() != otherList.size()) {
            return false;
        }
        IEqualityHelper equalityHelper = this.getConfiguration().getComparison().getEqualityHelper();
        int i = 0;
        int size = list.size();
        while (i < size) {
            if (!equalityHelper.matchingValues(list.get(i), otherList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected List<?> getListValue() {
        return this.listValue;
    }

    protected Object getEditableValue() {
        return this.editableValue;
    }

    protected boolean isList() {
        boolean allNull = true;
        boolean anyNonList = false;
        IMergeViewer.MergeViewerSide[] mergeViewerSideArray = PropertyContentMergeViewer.MERGE_VIEWER_SIDES;
        int n = PropertyContentMergeViewer.MERGE_VIEWER_SIDES.length;
        int n2 = 0;
        while (n2 < n) {
            IMergeViewer.MergeViewerSide otherSide = mergeViewerSideArray[n2];
            PropertyDescriptorItem sidePropertyItem = this.getSide(otherSide);
            if (sidePropertyItem != null && sidePropertyItem.getEditableValue() != null) {
                allNull = false;
                if (sidePropertyItem.getListValue() == null) {
                    anyNonList = true;
                }
            }
            ++n2;
        }
        return !anyNonList && !allNull;
    }

    @Override
    public PropertyDescriptorItem getSide(IMergeViewer.MergeViewerSide anySide) {
        return (PropertyDescriptorItem)super.getSide(anySide);
    }

    @Override
    protected Object getPropertyImage() {
        return this.getLabelProvider().getImage(this.editableValue);
    }

    @Override
    protected String getPropertyText() {
        if (this.isList()) {
            if (this.getListValue() == null || this.getListValue().isEmpty()) {
                return "";
            }
            return "..." + this.listValue.size();
        }
        return this.getLabelProvider().getText(this.editableValue);
    }

    @Override
    public void update(TreeItem treeItem, boolean expanded) {
        if (this.getListValue() != null && !this.getListValue().isEmpty()) {
            if (expanded) {
                treeItem.setImage(1, null);
                treeItem.setText(1, "");
            } else {
                treeItem.setImage(1, ExtendedImageRegistry.getInstance().getImage(this.getPropertyImage()));
                treeItem.setText(1, this.getPropertyText());
            }
        }
    }

    public boolean hasChildren(Object thisObject) {
        boolean hasChildren = super.hasChildren(thisObject);
        if (!hasChildren && !this.hasCheckedForChildren) {
            PropertyDescriptorItem rightPropertyDescriptorItem;
            PropertyDescriptorItem leftPropertyDescriptorItem;
            PropertyDescriptorItem ancestorPropertyDescriptorItem;
            PropertyItem propertyItem;
            EList<PropertyItem> propertyChildren;
            this.hasCheckedForChildren = true;
            if (this.propertyValue instanceof IItemPropertySource && !(propertyChildren = (propertyItem = PropertyDescriptorItem.createPropertyItem(this.getConfiguration(), this.propertyValue, this.getSide())).getPropertyItems()).isEmpty()) {
                this.needsReconcile = true;
                this.children.addAll(propertyChildren);
                hasChildren = true;
            }
            if (this.ancestor != null && this.ancestor != this) {
                this.ancestor.hasChildren((Object)this.ancestor);
            }
            if (this.left != null && this.left != this) {
                this.left.hasChildren((Object)this.left);
            }
            if (this.right != null && this.right != this) {
                this.right.hasChildren((Object)this.right);
            }
            if ((ancestorPropertyDescriptorItem = (PropertyDescriptorItem)this.ancestor) != null && ancestorPropertyDescriptorItem.needsReconcile) {
                ancestorPropertyDescriptorItem.reconcile();
                ancestorPropertyDescriptorItem.needsReconcile = false;
            }
            if ((leftPropertyDescriptorItem = (PropertyDescriptorItem)this.left) != null && leftPropertyDescriptorItem.needsReconcile) {
                leftPropertyDescriptorItem.reconcile();
                leftPropertyDescriptorItem.needsReconcile = false;
            }
            if ((rightPropertyDescriptorItem = (PropertyDescriptorItem)this.right) != null && rightPropertyDescriptorItem.needsReconcile) {
                rightPropertyDescriptorItem.reconcile();
                rightPropertyDescriptorItem.needsReconcile = false;
            }
        }
        return hasChildren;
    }

    @Override
    public Diff getDiff() {
        return this.propertyDiff;
    }
}

