/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DiagnosticSupport;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IComputation;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyLocalResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.LocalMonitoredProxyCreationListener;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.LocalResolveComputation;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ModelResourceListener;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ModelResourceVisitor;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.MonitorCallback;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolutionUtil;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceRemovedEvent;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.SynchronizedResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.util.ThreadSafeProgressMonitor;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;

public class ResourceDependencyLocalResolver
implements IResourceDependencyLocalResolver {
    private static final Logger LOGGER = Logger.getLogger(ResourceDependencyLocalResolver.class);
    private final EventBus eventBus;
    private final IGraph<URI> dependencyGraph;
    private final ModelResourceListener resourceListener;
    private final IResolutionContext context;

    public ResourceDependencyLocalResolver(IResolutionContext context) {
        this.context = context;
        this.eventBus = context.getEventBus();
        this.dependencyGraph = context.getGraph();
        this.resourceListener = context.getModelResourceListener();
    }

    public Iterable<URI> getDependenciesOf(IFile file) {
        return this.getDependenciesOf(file, Collections.emptySet());
    }

    public Iterable<URI> getDependenciesOf(IFile file, Set<URI> bounds) {
        Iterable dependencies;
        URI expectedURI = ResourceUtil.createURIFor((IFile)file);
        switch (ResolutionUtil.getResolutionScope()) {
            case WORKSPACE: {
                dependencies = this.dependencyGraph.getSubgraphContaining((Object)expectedURI, bounds);
                break;
            }
            case PROJECT: {
                Set allDependencies = this.dependencyGraph.getSubgraphContaining((Object)expectedURI, bounds);
                IProject project = file.getProject();
                dependencies = Iterables.filter((Iterable)allDependencies, this.isInContainer((IResource)project));
                break;
            }
            case CONTAINER: {
                Set allDependencies1 = this.dependencyGraph.getSubgraphContaining((Object)expectedURI, bounds);
                IContainer container = file.getParent();
                dependencies = Iterables.filter((Iterable)allDependencies1, this.isInContainer((IResource)container));
                break;
            }
            case OUTGOING: {
                dependencies = this.dependencyGraph.getTreeFrom((Object)expectedURI, bounds);
                break;
            }
            default: {
                dependencies = Collections.singleton(expectedURI);
            }
        }
        return dependencies;
    }

    protected void updateChangedResources(SynchronizedResourceSet resourceSet, DiagnosticSupport diagnostic, ThreadSafeProgressMonitor tspm) {
        Sets.SetView removedURIs = Sets.difference(this.resourceListener.popRemovedURIs(), this.context.getScheduler().getComputedElements());
        Sets.SetView changedURIs = Sets.difference(this.resourceListener.popChangedURIs(), this.context.getScheduler().getComputedElements());
        this.eventBus.post(new ResourceRemovedEvent(removedURIs));
        LinkedHashSet<URI> recompute = new LinkedHashSet<URI>((Collection<URI>)changedURIs);
        ArrayListMultimap parentToGrandParents = ArrayListMultimap.create();
        for (URI changed : changedURIs) {
            if (!this.dependencyGraph.contains((Object)changed)) continue;
            Set directParents = this.dependencyGraph.getDirectParents((Object)changed);
            recompute.addAll(directParents);
            for (URI uri : directParents) {
                Set grandParents = this.dependencyGraph.getDirectParents((Object)uri);
                parentToGrandParents.putAll((Object)uri, (Iterable)grandParents);
            }
        }
        this.eventBus.post(new ResourceRemovedEvent(recompute));
        this.demandResolveAll(recompute, diagnostic, resourceSet, tspm);
        LinkedHashSet<URI> toResolve = new LinkedHashSet<URI>();
        for (URI parentURI : parentToGrandParents.keySet()) {
            if (!this.dependencyGraph.contains((Object)parentURI)) continue;
            toResolve.addAll(parentToGrandParents.get((Object)parentURI));
        }
        this.demandResolveAll(toResolve, diagnostic, resourceSet, tspm);
    }

    @Override
    public void demandResolve(SynchronizedResourceSet resourceSet, URI uri, DiagnosticSupport diagnostic, ThreadSafeProgressMonitor tspm) {
        if (ResolutionUtil.isInterruptedOrCanceled((IProgressMonitor)tspm)) {
            this.context.getScheduler().demandShutdown();
            return;
        }
        if (this.context.getScheduler().isScheduled(uri)) {
            return;
        }
        this.context.getScheduler().scheduleComputation(new LocalResolveComputation(this.context, diagnostic, resourceSet, uri, new MonitorCallback(diagnostic, tspm), tspm));
    }

    private void demandResolveAll(Iterable<URI> uris, final DiagnosticSupport diagnostic, final SynchronizedResourceSet resourceSet, final ThreadSafeProgressMonitor tspm) {
        this.context.getScheduler().computeAll(Iterables.transform(uris, (Function)new Function<URI, IComputation<URI>>(){

            public IComputation<URI> apply(URI uri) {
                return new LocalResolveComputation(ResourceDependencyLocalResolver.this.context, diagnostic, resourceSet, uri, new MonitorCallback(diagnostic, tspm), tspm);
            }
        }));
    }

    protected Predicate<URI> isInContainer(final IResource container) {
        return new Predicate<URI>(){

            public boolean apply(URI input) {
                IFile pointedFile;
                if (input != null && (pointedFile = ResolutionUtil.getFileAt(input)) != null) {
                    return container.getLocation().isPrefixOf(pointedFile.getLocation());
                }
                return false;
            }
        };
    }

    @Override
    public void updateDependencies(IProgressMonitor monitor, final DiagnosticSupport diagnostic, IFile ... files) throws InterruptedException {
        final ThreadSafeProgressMonitor tspm = new ThreadSafeProgressMonitor(monitor);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("INSTANTIATING SynchronizedResourceSet to update dependencies with " + files.length + " files"));
        }
        final SynchronizedResourceSet resourceSet = new SynchronizedResourceSet(new LocalMonitoredProxyCreationListener(tspm, this.eventBus, this, diagnostic));
        Iterable filesToResolve = Iterables.filter(Arrays.asList(files), (Predicate)new Predicate<IFile>(){

            public boolean apply(IFile file) {
                return !ResourceDependencyLocalResolver.this.dependencyGraph.contains((Object)((URI)ResourceUtil.asURI().apply((Object)file))) && ResourceUtil.hasModelType((IFile)file);
            }
        });
        this.context.getScheduler().runAll(Iterables.transform((Iterable)filesToResolve, (Function)new Function<IFile, Runnable>(){

            public Runnable apply(final IFile file) {
                return new Runnable(){

                    @Override
                    public void run() {
                        IResource startingPoint = ResourceDependencyLocalResolver.this.getResolutionStartingPoint(file);
                        ModelResourceVisitor modelVisitor = new ModelResourceVisitor(ResourceDependencyLocalResolver.this.context.getScheduler(), resourceSet, ResourceDependencyLocalResolver.this, diagnostic, tspm);
                        try {
                            startingPoint.accept((IResourceVisitor)modelVisitor);
                        }
                        catch (CoreException e) {
                            diagnostic.merge(BasicDiagnostic.toDiagnostic((Throwable)e));
                        }
                    }
                };
            }
        }));
        this.updateChangedResources(resourceSet, diagnostic, tspm);
        resourceSet.dispose();
    }

    protected IResource getResolutionStartingPoint(IFile file) {
        IFile startingPoint;
        switch (ResolutionUtil.getResolutionScope()) {
            case WORKSPACE: {
                startingPoint = ResourcesPlugin.getWorkspace().getRoot();
                break;
            }
            case PROJECT: {
                startingPoint = file.getProject();
                break;
            }
            case CONTAINER: {
                startingPoint = file.getParent();
                break;
            }
            default: {
                startingPoint = file;
            }
        }
        return startingPoint;
    }

    public boolean hasChild(URI parent, URI candidate) {
        return this.dependencyGraph.hasChild((Object)parent, (Object)candidate);
    }
}

