/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.datatypes.impl;

import org.eclipse.graphiti.datatypes.IAdvancedDimension;
import org.eclipse.graphiti.datatypes.IDimension;

public class DimensionImpl
implements IAdvancedDimension {
    private int width;
    private int height;

    public DimensionImpl(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public DimensionImpl(IDimension dimension) {
        this(dimension.getWidth(), dimension.getHeight());
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DimensionImpl) {
            DimensionImpl d = (DimensionImpl)o;
            return d.width == this.width && d.height == this.height;
        }
        return false;
    }

    public int hashCode() {
        return this.width * this.height ^ this.width + this.height;
    }

    public String toString() {
        return "Dimension(" + this.width + ", " + this.height + ")";
    }

    @Override
    public IDimension getDimensionCopy() {
        return new DimensionImpl(this);
    }

    @Override
    public IDimension setDimension(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public IDimension setDimension(IDimension dimension) {
        return this.setDimension(dimension.getWidth(), dimension.getHeight());
    }

    @Override
    public void scale(double amount) {
        this.width = (int)Math.floor((double)this.width * amount);
        this.height = (int)Math.floor((double)this.height * amount);
    }

    @Override
    public IDimension expand(int dw, int dh) {
        this.width += dw;
        this.height += dh;
        return this;
    }
}

