/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.webapp.parser.ContextParser;
import org.eclipse.help.internal.webapp.servlet.ContextServlet;

public class ContextService
extends ContextServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean boolIsJSON;
        req.setCharacterEncoding("UTF-8");
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        String response = this.processRequest(req, resp);
        if ("400".equals(response)) {
            resp.sendError(400);
            return;
        }
        if ("404".equals(response)) {
            resp.sendError(404);
            return;
        }
        String returnType = req.getParameter("returnType");
        boolean bl = boolIsJSON = returnType != null && returnType.equalsIgnoreCase("json");
        if (boolIsJSON) {
            resp.setContentType("text/plain");
            response = this.getJSONResponse(response);
        }
        resp.getWriter().write(response);
    }

    protected String getJSONResponse(String response) throws IOException {
        ContextParser searchParser = new ContextParser();
        if (response != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayInputStream is = new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8));){
                    searchParser.parse(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return searchParser.toJSON();
    }
}

