/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.presentation.resource;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jwt.we.conf.model.ConfModel;
import org.eclipse.jwt.we.conf.model.resource.ConfModelResourceManager;
import org.eclipse.jwt.we.conf.model.resource.ConfResourceException;
import org.eclipse.jwt.we.conf.presentation.i18n.ConfEditorMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ReloadConfModelAction
extends Action {
    protected Shell parent;
    protected EditingDomain domain;

    public ReloadConfModelAction() {
        super(ConfEditorMessages.reloadConfModel);
    }

    public EditingDomain getEditingDomain() {
        return this.domain;
    }

    public void setEditingDomain(EditingDomain domain) {
        this.domain = domain;
    }

    public void update() {
        this.setEnabled(this.domain != null);
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        this.setEditingDomain(workbenchPart instanceof IEditingDomainProvider ? ((IEditingDomainProvider)workbenchPart).getEditingDomain() : null);
    }

    public void run() {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        URI resourceURI = EditUIUtil.getURI((IEditorInput)activeEditor.getEditorInput());
        try {
            ConfModel reloadedConfModel = ConfModelResourceManager.INSTANCE.loadConfModel(resourceURI, this.domain.getResourceSet(), null, false);
            if (reloadedConfModel != null && reloadedConfModel.getEnrichedModel() != null) {
                reloadedConfModel = ConfModelResourceManager.INSTANCE.loadConfModelOfModel(reloadedConfModel.getEnrichedModel(), true);
            }
            if (reloadedConfModel == null) {
                String msg = ConfEditorMessages.confModelReloadError;
                ErrorDialog.openError((Shell)this.parent, (String)ConfEditorMessages.unknownErrorWhileReloadingConfModel, (String)msg, (IStatus)new Status(4, "org.eclipse.jwt.we.conf.model.editor", 0, msg, null));
            }
        }
        catch (ConfResourceException crex) {
            ErrorDialog.openError((Shell)this.parent, (String)ConfEditorMessages.confModelReloadError, (String)crex.getMessage(), (IStatus)new Status(4, "org.eclipse.jwt.we.conf.model.editor", 0, crex.getMessage(), (Throwable)crex));
        }
        catch (Exception ex) {
            ErrorDialog.openError((Shell)this.parent, (String)ConfEditorMessages.confModelReloadError, (String)ex.getMessage(), (IStatus)new Status(4, "org.eclipse.jwt.we.conf.model.editor", 0, ex.getMessage(), (Throwable)ex));
        }
    }
}

