/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.action.Action;
import org.eclipse.mat.report.SpecFactory;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.actions.ImportReportAction;
import org.eclipse.mat.ui.actions.RunExternalReportAction;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.actions.ExecuteQueryAction;
import org.eclipse.mat.ui.util.EasyToolBarDropDown;
import org.eclipse.mat.ui.util.PopupMenu;

public class RunReportsDropDownAction
extends EasyToolBarDropDown {
    private MultiPaneEditor editor;
    private Action importReportAction;
    private Action runExternalReportAction;

    public RunReportsDropDownAction(MultiPaneEditor editor) {
        super(Messages.RunReportsDropDownAction_RunExpertSystemTest, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/expert.gif"), editor);
        this.editor = editor;
        this.importReportAction = new ImportReportAction(editor);
        this.runExternalReportAction = new RunExternalReportAction(editor);
    }

    public void contribute(PopupMenu menu) {
        ArrayList<ExecuteQueryAction> reportActions = new ArrayList<ExecuteQueryAction>();
        for (SpecFactory.Report report : SpecFactory.instance().delegates()) {
            ExecuteQueryAction action = new ExecuteQueryAction(this.editor, "default_report " + report.getExtensionIdentifier());
            action.setText(report.getName());
            action.setDescription(report.getDescription());
            action.setToolTipText(report.getDescription());
            reportActions.add(action);
        }
        Collections.sort(reportActions, new Comparator<Action>(){

            @Override
            public int compare(Action o1, Action o2) {
                return o1.getText().compareTo(o2.getText());
            }
        });
        for (Action action : reportActions) {
            String[] name = action.getText().split("/");
            int i = 0;
            while (i < name.length) {
                name[i] = name[i].replaceFirst("^\\d\\|", "");
                ++i;
            }
            PopupMenu m1 = menu;
            int i2 = 0;
            while (i2 < name.length - 1) {
                if (name[i2].equals("__hidden__")) break;
                PopupMenu m2 = m1.getChildMenu(name[i2]);
                if (m2 == null) {
                    m2 = new PopupMenu(name[i2]);
                    m1.add(m2);
                }
                m1 = m2;
                ++i2;
            }
            if (i2 < name.length - 1) continue;
            action.setText(name[name.length - 1]);
            m1.add(action);
        }
        menu.addSeparator();
        menu.add(this.importReportAction);
        menu.add(this.runExternalReportAction);
    }
}

