/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services.internal;

import org.eclipse.papyrus.infra.core.services.BadStateException;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceState;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.services.internal.ServiceTypeEntry;

public class ServiceEntry
extends ServiceTypeEntry {
    private IService serviceInstance;

    public ServiceEntry(ServiceDescriptor serviceDescriptor) {
        super(serviceDescriptor);
        this.setState(ServiceState.registered);
    }

    public ServiceEntry(ServiceDescriptor descriptor, IService serviceInstance) {
        super(descriptor);
        this.serviceInstance = serviceInstance;
        this.setState(ServiceState.registered);
    }

    @Override
    public Object getServiceInstance() throws ServiceException {
        if (this.serviceInstance == null) {
            throw new BadStateException("Service is not created.", this.state, this.serviceDescriptor);
        }
        return this.serviceInstance;
    }

    public String toString() {
        return "ServiceEntry [serviceDescriptor=" + this.serviceDescriptor.toString() + ", serviceInstance=" + this.serviceInstance + "]";
    }

    @Override
    public void createService() throws ServiceException {
        this.checkState(ServiceState.registered);
        if (this.serviceInstance != null) {
            this.setState(ServiceState.created);
            return;
        }
        try {
            this.serviceInstance = (IService)this.instanciateService();
        }
        catch (Exception e) {
            this.setState(ServiceState.error);
            throw new ServiceException(e);
        }
        this.setState(ServiceState.created);
    }

    @Override
    public void initService(ServicesRegistry servicesRegistry) throws ServiceException {
        this.checkState(ServiceState.created);
        try {
            this.serviceInstance.init(servicesRegistry);
        }
        catch (ServiceException e) {
            this.setState(ServiceState.error);
            throw e;
        }
        catch (Exception e) {
            this.setState(ServiceState.error);
            throw new ServiceException(e);
        }
        this.setState(ServiceState.initialized);
    }

    @Override
    public void startService() throws ServiceException {
        this.checkState(ServiceState.initialized);
        this.setState(ServiceState.starting);
        try {
            this.serviceInstance.startService();
        }
        catch (ServiceException e) {
            this.setState(ServiceState.error);
            throw e;
        }
        catch (Exception e) {
            this.setState(ServiceState.error);
            throw new ServiceException(e);
        }
        this.setState(ServiceState.started);
    }

    @Override
    public void disposeService() throws ServiceException {
        if (this.serviceInstance == null) {
            return;
        }
        this.serviceInstance.disposeService();
        this.serviceInstance = null;
        this.setState(ServiceState.disposed);
    }
}

