/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.editor;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EObjectStructuredValueFactory;
import org.eclipse.papyrus.infra.services.edit.ui.databinding.PapyrusObservableValue;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservable;
import org.eclipse.papyrus.infra.ui.emf.dialog.EObjectTreeReferenceValueEditor;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class EObjectTreeDialog
extends SelectionDialog {
    protected EObject editedObject;
    protected EStructuralFeature feature;

    public EObjectTreeDialog(Shell parentShell, EObject editedObject, EStructuralFeature feature, String title) {
        super(parentShell);
        this.setTitle(title);
        this.setHelpAvailable(false);
        this.editedObject = editedObject;
        this.feature = feature;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        EObjectTreeReferenceValueEditor treeReferenceValueEditor = new EObjectTreeReferenceValueEditor(container, 0);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.editedObject);
        PapyrusObservableValue papyrusObservableValue = new PapyrusObservableValue(this.editedObject, this.feature, (EditingDomain)editingDomain, GMFtoEMFCommandWrapper::wrap);
        IObservableValue wrap = (IObservableValue)DelegatingObservable.wrap((IObservable)papyrusObservableValue);
        treeReferenceValueEditor.setModelObservable(wrap);
        treeReferenceValueEditor.setLabelProvider(this.getLabelProviderForEObject(this.editedObject));
        treeReferenceValueEditor.setProvidersTreeViewer();
        if (this.feature instanceof EReference) {
            treeReferenceValueEditor.setValueFactory((ReferenceValueFactory)new EObjectStructuredValueFactory((EReference)this.feature));
        }
        treeReferenceValueEditor.setLayoutData((Object)new GridData(4, 4, true, true));
        return container;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    private ILabelProvider getLabelProviderForEObject(EObject eObject) {
        LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
        try {
            labelProviderService.startService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        return labelProviderService.getLabelProvider((Object)eObject);
    }

    public Object[] getResult() {
        Object[] objects = new Object[]{this.editedObject};
        return objects;
    }
}

