/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.constraints;

import java.lang.ref.WeakReference;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class HasStereotypeConstraint
extends AbstractConstraint {
    protected String stereotypeName;
    private WeakReference<Element> umlElement;

    public boolean match(Object selection) {
        Element element = UMLUtil.resolveUMLElement((Object)selection);
        if (element == null) {
            return false;
        }
        this.umlElement = new WeakReference<Element>(element);
        Stereotype stereotype = UMLUtil.getAppliedStereotype((Element)element, (String)this.stereotypeName, (boolean)false);
        return stereotype != null;
    }

    public void setDescriptor(SimpleConstraint descriptor) {
        this.stereotypeName = this.getValue("stereotypeName");
    }

    public boolean overrides(Constraint constraint) {
        boolean overrides = false;
        if (constraint instanceof HasStereotypeConstraint) {
            Element element;
            HasStereotypeConstraint stereotypeConstraint = (HasStereotypeConstraint)constraint;
            if (!this.stereotypeName.equals(stereotypeConstraint.stereotypeName) && (element = (Element)this.umlElement.get()) != null) {
                Stereotype thisStereotype = element.getApplicableStereotype(this.stereotypeName);
                Stereotype otherStereotype = UMLUtil.findStereotype((Element)element, (String)stereotypeConstraint.stereotypeName);
                if (UMLUtil.getAllSuperStereotypes((Stereotype)thisStereotype).contains(otherStereotype)) {
                    overrides = true;
                }
            }
        }
        return overrides || super.overrides(constraint);
    }

    public String toString() {
        return String.format("HasStereotype %s (%s)", this.stereotypeName, this.getDisplayUnit().getElementMultiplicity() == 1 ? "Single" : "Multiple");
    }

    protected boolean equivalent(Constraint constraint) {
        if (this == constraint) {
            return true;
        }
        if (constraint == null) {
            return false;
        }
        if (!(constraint instanceof HasStereotypeConstraint)) {
            return false;
        }
        HasStereotypeConstraint other = (HasStereotypeConstraint)constraint;
        return !(this.stereotypeName == null ? other.stereotypeName != null : !this.stereotypeName.equals(other.stereotypeName));
    }
}

