/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class RangePartitionMetadata
extends ORMetadata {
    protected String connectionPool;
    protected String startValue;
    protected String endValue;

    public RangePartitionMetadata() {
        super("<range-partition>");
    }

    public RangePartitionMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        super(annotation, accessor);
        this.connectionPool = annotation.getAttributeString("connectionPool");
        this.startValue = annotation.getAttributeString("startValue");
        this.endValue = annotation.getAttributeString("endValue");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof RangePartitionMetadata) {
            RangePartitionMetadata partition = (RangePartitionMetadata)objectToCompare;
            return this.valuesMatch(this.connectionPool, partition.getConnectionPool()) && this.valuesMatch(this.startValue, partition.getStartValue()) && this.valuesMatch(this.endValue, partition.getEndValue());
        }
        return false;
    }

    public int hashCode() {
        int result = this.connectionPool != null ? this.connectionPool.hashCode() : 0;
        result = 31 * result + (this.startValue != null ? this.startValue.hashCode() : 0);
        result = 31 * result + (this.endValue != null ? this.endValue.hashCode() : 0);
        return result;
    }

    public String getConnectionPool() {
        return this.connectionPool;
    }

    public String getEndValue() {
        return this.endValue;
    }

    public String getStartValue() {
        return this.startValue;
    }

    public void setConnectionPool(String connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void setEndValue(String endValue) {
        this.endValue = endValue;
    }

    public void setStartValue(String startValue) {
        this.startValue = startValue;
    }
}

