/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.validation.constraints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.DataAssocication;
import org.eclipse.pmf.pim.DataCollection;
import org.eclipse.pmf.pim.DataForm;
import org.eclipse.pmf.pim.DataFormFolder;
import org.eclipse.pmf.pim.DataInheritance;
import org.eclipse.pmf.pim.DataItem;
import org.eclipse.pmf.pim.ElementalDataForm;

public class NoCircularReference
extends AbstractModelConstraint {
    private int V;
    private int preCount;
    private int[] low;
    private boolean[] visited;
    private Set<Integer>[] graph;
    private Map<Integer, String> dataForms = new HashMap<Integer, String>();
    private List<List<Integer>> sccComp;
    private Stack<Integer> stack;

    public IStatus validate(IValidationContext ctx) {
        Application eObj = (Application)ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        this.initGraph(eObj);
        List<List<Integer>> scComponents = this.getSCComponents(this.graph);
        StringBuffer stringBuffer = new StringBuffer();
        for (List<Integer> list : scComponents) {
            ArrayList l = (ArrayList)list;
            if (l.size() <= 1) continue;
            stringBuffer.append("[");
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                String dataForm = this.dataForms.get(i);
                stringBuffer.append(String.valueOf(dataForm) + " ");
                if (i >= l.size()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("] ");
        }
        if (eType == EMFEventType.NULL ? this.sccComp.size() > 0 : this.sccComp.size() > 0) {
            return ctx.createFailureStatus(new Object[]{"Cycle referenced dataforms: " + stringBuffer.toString()});
        }
        return ctx.createSuccessStatus();
    }

    public List<List<Integer>> getSCComponents(Set<Integer>[] graph) {
        this.V = graph.length;
        this.graph = graph;
        this.low = new int[this.V];
        this.visited = new boolean[this.V];
        this.stack = new Stack();
        this.sccComp = new ArrayList<List<Integer>>();
        int v = 0;
        while (v < this.V) {
            if (!this.visited[v]) {
                this.dfs(v);
            }
            ++v;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.sccComp.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object list = objectArray[n2];
            ArrayList l = (ArrayList)list;
            if (l.size() > 1) {
                Object[] objectArray2 = l.toArray();
                int n3 = objectArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object i = objectArray2[n4];
                    String dataForm = this.dataForms.get(i);
                    stringBuffer.append(String.valueOf(dataForm) + " ");
                    ++n4;
                }
                stringBuffer.append(";");
            }
            ++n2;
        }
        return this.sccComp;
    }

    public void dfs(int v) {
        int w;
        ++this.preCount;
        this.visited[v] = true;
        this.stack.push(v);
        int min = this.low[v];
        for (int w2 : this.graph[v]) {
            if (!this.visited[w2]) {
                this.dfs(w2);
            }
            if (this.low[w2] >= min) continue;
            min = this.low[w2];
        }
        if (min < this.low[v]) {
            this.low[v] = min;
            return;
        }
        ArrayList<Integer> component = new ArrayList<Integer>();
        do {
            w = this.stack.pop();
            component.add(w);
            this.low[w] = this.V;
        } while (w != v);
        this.sccComp.add(component);
    }

    public void initGraph(Application application) {
        int index = 0;
        for (Map.Entry dataFormFolder : application.getDataFormFolders()) {
            for (DataForm dataForm : ((DataFormFolder)dataFormFolder.getValue()).getDataForms()) {
                this.dataForms.put(index, dataForm.getName());
                ++index;
            }
        }
        this.graph = new Set[index];
        int i = 0;
        while (i < index) {
            this.graph[i] = new HashSet<Integer>();
            ++i;
        }
        for (Map.Entry dataFormFolder : application.getDataFormFolders()) {
            for (DataForm dataForm : ((DataFormFolder)dataFormFolder.getValue()).getDataForms()) {
                int dataFormIndex = this.getDataFormIndex(dataForm);
                EList dataItems = ((ElementalDataForm)dataForm).getChildren();
                if (dataItems == null || dataItems.isEmpty()) continue;
                for (DataItem dataItem : dataItems) {
                    switch (dataItem.eClass().getClassifierID()) {
                        case 6: {
                            DataCollection dataCollection = (DataCollection)dataItem;
                            if (dataCollection.getDetail() == null) break;
                            int dataCollectionIndex = this.getDataFormIndex(dataCollection.getDetail());
                            this.graph[dataFormIndex].add(dataCollectionIndex);
                            break;
                        }
                        case 27: {
                            DataAssocication dataAssociation = (DataAssocication)dataItem;
                            if (dataAssociation.getDataForm() == null) break;
                            int dataAssociationIndex = this.getDataFormIndex(dataAssociation.getDataForm());
                            this.graph[dataFormIndex].add(dataAssociationIndex);
                            break;
                        }
                        case 26: {
                            DataInheritance dataInheritance = (DataInheritance)dataItem;
                            if (dataInheritance.getDataForm() == null) break;
                            int dataInheritanceIndex = this.getDataFormIndex(dataInheritance.getDataForm());
                            this.graph[dataFormIndex].add(dataInheritanceIndex);
                        }
                    }
                }
            }
        }
    }

    public Integer getDataFormIndex(DataForm dataForm) {
        int index = 0;
        for (int formIndex : this.dataForms.keySet()) {
            if (!this.dataForms.get(formIndex).equals(dataForm.getName())) continue;
            index = formIndex;
            break;
        }
        return index;
    }
}

