/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.junit.requirement.Requirement;

public class AnnotationUtils {
    public static List<Annotation> getRequirementAnnotations(Class<?> clazz) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        List<Annotation> classAnnotations = AnnotationUtils.getClassLevelAnnotations(clazz);
        for (Annotation annotation : classAnnotations) {
            if (AnnotationUtils.getEnclosingRequirementClass(annotation.annotationType()) == null) continue;
            result.add(annotation);
        }
        return result;
    }

    public static List<Annotation> getClassLevelAnnotations(Class<?> clazz) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        Class<?> currentClass = clazz;
        while (!currentClass.equals(Object.class)) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = currentClass.getDeclaredAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (!AnnotationUtils.listContainsAnnotation(result, annotation.annotationType())) {
                    result.add(annotation);
                }
                ++n2;
            }
            currentClass = currentClass.getSuperclass();
        }
        return result;
    }

    public static <T extends Annotation> Class<Requirement<Annotation>> getEnclosingRequirementClass(Class<T> clazz) {
        Class<Requirement<Annotation>> enclosingClass = clazz.getEnclosingClass();
        if (enclosingClass != null && Requirement.class.isAssignableFrom(enclosingClass)) {
            return enclosingClass;
        }
        return null;
    }

    public static <T extends Annotation> Object invokeStaticMethodWithAnnotation(Class<?> clazzWithMethod, Class<T> annotationClass, Class<?> ... methodReturnTypes) {
        List annotatedMethods = Arrays.stream(clazzWithMethod.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(annotationClass)).collect(Collectors.toList());
        if (annotatedMethods.size() > 1) {
            throw new RedDeerException("More than one method is annotated with " + annotationClass);
        }
        if (annotatedMethods.size() == 1) {
            try {
                Class<?>[] classArray = methodReturnTypes;
                int n = methodReturnTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> methodReturnType = classArray[n2];
                    if (((Method)annotatedMethods.get(0)).getReturnType().isAssignableFrom(methodReturnType)) {
                        return ((Method)annotatedMethods.get(0)).invoke(null, null);
                    }
                    ++n2;
                }
                throw new RedDeerException("Method annotated with annotation " + annotationClass + " does not have specified return type " + methodReturnTypes);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RedDeerException("Something were wrong when executing a method annotated with  annotation " + annotationClass, (Throwable)e);
            }
        }
        return null;
    }

    private static boolean listContainsAnnotation(List<Annotation> annotations, Class<? extends Annotation> annotationClass) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return true;
        }
        return false;
    }
}

