/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.display;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayService;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;

public final class CreationDisplayServiceImpl
implements DisplayService {
    private Map<DDiagramElement, Boolean> cache;

    private CreationDisplayServiceImpl() {
    }

    public static DisplayService init() {
        return new CreationDisplayServiceImpl();
    }

    @Override
    public void refreshAllElementsVisibility(DDiagram diagram) {
    }

    @Override
    public boolean isDisplayed(DDiagram diagram, DDiagramElement element) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.IS_VISIBLE_KEY);
        boolean result = element.isVisible();
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.IS_VISIBLE_KEY);
        return result;
    }

    @Override
    public void activateCache() {
        if (this.cache == null) {
            this.cache = new HashMap<DDiagramElement, Boolean>();
        }
    }

    @Override
    public void deactivateCache() {
        this.cache = null;
    }

    @Override
    public boolean computeVisibility(DiagramMappingsManager session, DDiagram diagram, DDiagramElement element) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.IS_VISIBLE_KEY);
        boolean result = this.doIsVisible(session, diagram, element);
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.IS_VISIBLE_KEY);
        return result;
    }

    @Override
    public boolean computeLabelVisibility(DDiagram diagram, DDiagramElement element) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.IS_VISIBLE_KEY);
        boolean result = this.doIsLabelVisible(diagram, element);
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.IS_VISIBLE_KEY);
        return result;
    }

    private boolean doIsVisible(DiagramMappingsManager session, DDiagram diagram, DDiagramElement element) {
        boolean isVisible = true;
        DDiagramElementQuery ddeQuery = new DDiagramElementQuery(element);
        if (ddeQuery.isIndirectlyHidden() || ddeQuery.isIndirectlyFiltered()) {
            isVisible = false;
        }
        if (isVisible && element instanceof DEdge) {
            isVisible = this.isDEdgeVisible(diagram, (DEdge)element);
        }
        if (isVisible) {
            isVisible = LayerHelper.isInActivatedLayer(session, element, diagram);
        }
        return isVisible;
    }

    private boolean doIsLabelVisible(DDiagram diagram, DDiagramElement element) {
        DDiagramElementQuery ddeQuery = new DDiagramElementQuery(element);
        return ddeQuery.isLabelVisibleByDefault();
    }

    private boolean isDEdgeVisible(DDiagram vp, DEdge edge) {
        boolean isVisible = true;
        if (edge.getSourceNode() instanceof DDiagramElement) {
            boolean bl = isVisible = isVisible && ((DDiagramElement)((Object)edge.getSourceNode())).isVisible();
        }
        if (edge.getTargetNode() instanceof DDiagramElement) {
            isVisible = isVisible && ((DDiagramElement)((Object)edge.getTargetNode())).isVisible();
        }
        return isVisible;
    }
}

