/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density;

import java.text.Format;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density.BaseMouseProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density.Messages;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public class SimpleTooltipProvider
extends BaseMouseProvider {
    private static final Format FORMAT = new SubSecondTimeWithUnitFormat();
    private DensityToolTipHandler fToolTipHandler = new DensityToolTipHandler();

    public SimpleTooltipProvider(AbstractSegmentStoreDensityViewer densityViewer) {
        super(densityViewer);
        this.register();
    }

    @Override
    public void register() {
        this.fToolTipHandler.activateHoverHelp((Control)this.getChart().getPlotArea());
    }

    @Override
    public void deregister() {
        if (!this.getDensityViewer().getControl().isDisposed()) {
            this.fToolTipHandler.deactivateHoverHelp((Control)this.getChart().getPlotArea());
        }
    }

    private final class DensityToolTipHandler
    extends TmfAbstractToolTipHandler {
        private DensityToolTipHandler() {
        }

        public void fill(Control control, MouseEvent event, Point pt) {
            Chart chart = SimpleTooltipProvider.this.getChart();
            if (chart.getSeriesSet().getSeries().length != 0) {
                if (event == null || chart.getAxisSet().getXAxes().length == 0 || chart.getAxisSet().getYAxes().length == 0 || SimpleTooltipProvider.this.getDensityViewer().getControl().getSeriesSet().getSeries().length == 0) {
                    return;
                }
                ISeries series = SimpleTooltipProvider.this.getDensityViewer().getControl().getSeriesSet().getSeries()[0];
                chart.getPlotArea().setToolTipText(null);
                if (series instanceof IBarSeries) {
                    IBarSeries barSeries = (IBarSeries)series;
                    Rectangle[] bounds = barSeries.getBounds();
                    if (barSeries.getXSeries().length < 2) {
                        return;
                    }
                    double delta = barSeries.getXSeries()[1] - barSeries.getXSeries()[0];
                    int i = 0;
                    while (i < bounds.length) {
                        Rectangle rec = bounds[i];
                        if (rec != null) {
                            int start = rec.x;
                            int end = start + rec.width;
                            if (event.x >= start && event.x <= end) {
                                long x1 = (long)barSeries.getXSeries()[i];
                                long x2 = (long)((double)x1 + delta);
                                IAxis yAxis = chart.getAxisSet().getYAxes()[0];
                                long y = Math.round(yAxis.getDataCoordinate(rec.y)) - 1L;
                                if (y <= 0L) break;
                                this.addItem(Messages.SimpleTooltipProvider_duration, String.valueOf(FORMAT.format(x1)) + '-' + FORMAT.format(x2));
                                this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromString((String)Messages.SimpleTooltipProvider_count), TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)y));
                                break;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

