import { DebugProtocol } from 'vscode-debugprotocol';
export declare const evalNotAvailableMsg: string;
export declare const runtimeNotConnectedMsg: string;
export declare const noRestartFrame: string;
export declare class ErrorWithMessage extends Error implements DebugProtocol.Message {
    id: number;
    format: string;
    variables?: {
        [key: string]: string;
    };
    sendTelemetry?: boolean;
    showUser?: boolean;
    url?: string;
    urlLabel?: string;
    constructor(message: DebugProtocol.Message);
}
export declare function attributePathNotExist(attribute: string, path: string): DebugProtocol.Message;
/**
 * Error stating that a relative path should be absolute
 */
export declare function attributePathRelative(attribute: string, path: string): DebugProtocol.Message;
/**
 * Get error with 'More Information' link.
 */
export declare function withInfoLink(id: number, format: string, variables: any, infoId: number): DebugProtocol.Message;
export declare function setValueNotSupported(): DebugProtocol.Message;
export declare function errorFromEvaluate(errMsg: string): DebugProtocol.Message;
export declare function sourceRequestIllegalHandle(): DebugProtocol.Message;
export declare function sourceRequestCouldNotRetrieveContent(): DebugProtocol.Message;
export declare function pathFormat(): DebugProtocol.Message;
export declare function runtimeConnectionTimeout(timeoutMs: number, errMsg: string): DebugProtocol.Message;
export declare function stackFrameNotValid(): DebugProtocol.Message;
export declare function noCallStackAvailable(): DebugProtocol.Message;
export declare function invalidThread(threadId: number): DebugProtocol.Message;
export declare function exceptionInfoRequestError(): DebugProtocol.Message;
export declare function noStoredException(): DebugProtocol.Message;
