/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.npm.internal.ui;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.js.common.build.system.Location;
import org.eclipse.wst.jsdt.js.npm.NpmPlugin;
import org.eclipse.wst.jsdt.js.npm.PackageJson;
import org.eclipse.wst.jsdt.js.npm.internal.NpmScriptTask;
import org.eclipse.wst.jsdt.js.npm.util.NpmUtil;

public class NpmScriptContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    private Viewer viewer;
    private IResource resource;
    protected static final Object[] EMPTY_ARRAY = new Object[0];

    public void dispose() {
        if (this.resource != null) {
            this.resource.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.resource = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.resource != null) {
            this.resource.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        this.resource = (IResource)newInput;
        if (this.resource != null) {
            this.resource.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        this.viewer = viewer;
    }

    public Object[] getChildren(Object parentNode) {
        if (parentNode instanceof IFile) {
            try {
                HashSet<NpmScriptTask> tasks = new HashSet<NpmScriptTask>();
                PackageJson packageJson = NpmUtil.parsePackageJsonFile((IFile)parentNode);
                if (packageJson != null && packageJson.getScripts() != null) {
                    for (String scriptName : packageJson.getScripts().keySet()) {
                        tasks.add(new NpmScriptTask((IResource)((IFile)parentNode), scriptName, null, false, new Location(0, 1)));
                    }
                }
                return tasks.toArray();
            }
            catch (Exception ex) {
                NpmPlugin.logError(ex, ex.getMessage());
            }
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            return ((List)inputElement).toArray();
        }
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        return EMPTY_ARRAY;
    }

    public void resourceChanged(IResourceChangeEvent arg0) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                NpmScriptContentProvider.this.viewer.refresh();
            }
        });
    }
}

