/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.symbol;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.TreeTraverser;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceAcceptor;
import org.eclipse.xtext.findReferences.TargetURICollector;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.DocumentExtensions;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.symbol.HierarchicalDocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.IDocumentSymbolService;
import org.eclipse.xtext.ide.util.CancelIndicatorProgressMonitor;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class DocumentSymbolService
implements IDocumentSymbolService {
    @Inject
    @Extension
    private UriExtensions _uriExtensions;
    @Inject
    @Extension
    private DocumentExtensions _documentExtensions;
    @Inject
    @Extension
    private EObjectAtOffsetHelper _eObjectAtOffsetHelper;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private TargetURICollector targetURICollector;
    @Inject
    private Provider<TargetURIs> targetURIProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private HierarchicalDocumentSymbolService hierarchicalDocumentSymbolService;

    public List<? extends Location> getDefinitions(Document document, XtextResource resource, TextDocumentPositionParams params, IReferenceFinder.IResourceAccess resourceAccess, CancelIndicator cancelIndicator) {
        int offset = document.getOffSet(params.getPosition());
        return this.getDefinitions(resource, offset, resourceAccess, cancelIndicator);
    }

    public List<? extends Location> getDefinitions(XtextResource resource, int offset, IReferenceFinder.IResourceAccess resourceAccess, CancelIndicator cancelIndicator) {
        EObject element = this._eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        if (element == null) {
            return CollectionLiterals.emptyList();
        }
        ArrayList locations = CollectionLiterals.newArrayList();
        TargetURIs targetURIs = this.collectTargetURIs(element);
        for (URI targetURI : targetURIs) {
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            Procedures.Procedure1 _function = obj -> {
                Location location = this._documentExtensions.newLocation((EObject)obj);
                if (location != null) {
                    locations.add(location);
                }
            };
            this.doRead(resourceAccess, targetURI, (Procedures.Procedure1<? super EObject>)_function);
        }
        return locations;
    }

    public List<? extends Location> getReferences(Document document, XtextResource resource, ReferenceParams params, IReferenceFinder.IResourceAccess resourceAccess, IResourceDescriptions indexData, CancelIndicator cancelIndicator) {
        int offset = document.getOffSet(params.getPosition());
        List<? extends Location> _xifexpression = null;
        boolean _isIncludeDeclaration = params.getContext().isIncludeDeclaration();
        _xifexpression = _isIncludeDeclaration ? this.getDefinitions(resource, offset, resourceAccess, cancelIndicator) : CollectionLiterals.emptyList();
        List<? extends Location> definitions = _xifexpression;
        List<? extends Location> references = this.getReferences(resource, offset, resourceAccess, indexData, cancelIndicator);
        Iterable result = Iterables.concat(definitions, references);
        return IterableExtensions.toList((Iterable)result);
    }

    public List<? extends Location> getReferences(XtextResource resource, int offset, IReferenceFinder.IResourceAccess resourceAccess, IResourceDescriptions indexData, CancelIndicator cancelIndicator) {
        EObject element = this._eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        if (element == null) {
            return CollectionLiterals.emptyList();
        }
        ArrayList locations = CollectionLiterals.newArrayList();
        TargetURIs targetURIs = this.collectTargetURIs(element);
        IAcceptor _function = reference -> {
            Procedures.Procedure1 _function_1 = obj -> {
                Location location = this._documentExtensions.newLocation((EObject)obj, (EStructuralFeature)reference.getEReference(), reference.getIndexInList());
                if (location != null) {
                    locations.add(location);
                }
            };
            this.doRead(resourceAccess, reference.getSourceEObjectUri(), (Procedures.Procedure1<? super EObject>)_function_1);
        };
        ReferenceAcceptor _referenceAcceptor = new ReferenceAcceptor(this.resourceServiceProviderRegistry, _function);
        CancelIndicatorProgressMonitor _cancelIndicatorProgressMonitor = new CancelIndicatorProgressMonitor(cancelIndicator);
        this.referenceFinder.findAllReferences(targetURIs, resourceAccess, indexData, (IReferenceFinder.Acceptor)_referenceAcceptor, (IProgressMonitor)_cancelIndicatorProgressMonitor);
        return locations;
    }

    protected TargetURIs collectTargetURIs(EObject targetObject) {
        TargetURIs targetURIs = (TargetURIs)this.targetURIProvider.get();
        this.targetURICollector.add(targetObject, targetURIs);
        return targetURIs;
    }

    @Override
    public List<Either<SymbolInformation, DocumentSymbol>> getSymbols(Document document, XtextResource resource, DocumentSymbolParams params, CancelIndicator cancelIndicator) {
        return this.getSymbols(resource, cancelIndicator);
    }

    public List<Either<SymbolInformation, DocumentSymbol>> getSymbols(XtextResource resource, CancelIndicator cancelIndicator) {
        String uri = this._uriExtensions.toUriString(resource.getURI());
        ArrayList infos = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> (DocumentSymbol)it.getRight();
        List rootSymbols = ListExtensions.map(this.hierarchicalDocumentSymbolService.getSymbols(resource, cancelIndicator), (Functions.Function1)_function);
        Consumer<DocumentSymbol> _function_1 = rootSymbol -> {
            Functions.Function1 _function_3;
            Function _function_2 = it -> it.getChildren();
            FluentIterable symbols = TreeTraverser.using((Function)_function_2).preOrderTraversal(rootSymbol);
            Functions.Function1 containerNameProvider = _function_3 = symbol -> {
                Functions.Function1 _function_4 = it -> it != symbol && !IterableExtensions.isNullOrEmpty((Iterable)it.getChildren()) && it.getChildren().contains(symbol);
                DocumentSymbol _findFirst = (DocumentSymbol)IterableExtensions.findFirst((Iterable)symbols, (Functions.Function1)_function_4);
                String _name = null;
                if (_findFirst != null) {
                    _name = _findFirst.getName();
                }
                return _name;
            };
            Functions.Function1 _function_4 = it -> this.createSymbol(uri, (DocumentSymbol)it, (Functions.Function1<? super DocumentSymbol, ? extends String>)containerNameProvider);
            Iterables.addAll((Collection)infos, (Iterable)IterableExtensions.map((Iterable)symbols, (Functions.Function1)_function_4));
        };
        rootSymbols.forEach(_function_1);
        Functions.Function1 _function_2 = it -> Either.forLeft((Object)it);
        return ListExtensions.map((List)infos, (Functions.Function1)_function_2);
    }

    protected EObject getContainer(EObject obj) {
        return obj.eContainer();
    }

    protected SymbolInformation createSymbol(String uri, DocumentSymbol symbol, Functions.Function1<? super DocumentSymbol, ? extends String> containerNameProvider) {
        SymbolInformation _symbolInformation = new SymbolInformation();
        Procedures.Procedure1 _function = it -> {
            it.setName(symbol.getName());
            it.setKind(symbol.getKind());
            it.setDeprecated(symbol.getDeprecated());
            Location _location = new Location();
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.setUri(uri);
                it_1.setRange(symbol.getSelectionRange());
            };
            Location _doubleArrow = (Location)ObjectExtensions.operator_doubleArrow((Object)_location, (Procedures.Procedure1)_function_1);
            it.setLocation(_doubleArrow);
            it.setContainerName((String)containerNameProvider.apply((Object)symbol));
        };
        return (SymbolInformation)ObjectExtensions.operator_doubleArrow((Object)_symbolInformation, (Procedures.Procedure1)_function);
    }

    protected SymbolInformation createSymbol(EObject object) {
        String name = this.getSymbolName(object);
        if (name == null) {
            return null;
        }
        SymbolKind kind = this.getSymbolKind(object);
        if (kind == null) {
            return null;
        }
        Location location = this.getSymbolLocation(object);
        if (location == null) {
            return null;
        }
        SymbolInformation symbol = new SymbolInformation();
        symbol.setName(name);
        symbol.setKind(kind);
        symbol.setLocation(location);
        return symbol;
    }

    protected String getSymbolName(EObject object) {
        return this.getSymbolName(this._iQualifiedNameProvider.getFullyQualifiedName(object));
    }

    protected SymbolKind getSymbolKind(EObject object) {
        return this.getSymbolKind(object.eClass());
    }

    protected Location getSymbolLocation(EObject object) {
        return this._documentExtensions.newLocation(object);
    }

    public List<? extends SymbolInformation> getSymbols(IResourceDescription resourceDescription, String query, IReferenceFinder.IResourceAccess resourceAccess, CancelIndicator cancelIndicator) {
        LinkedList symbols = CollectionLiterals.newLinkedList();
        Iterable _exportedObjects = resourceDescription.getExportedObjects();
        for (IEObjectDescription description : _exportedObjects) {
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            boolean _filter = this.filter(description, query);
            if (!_filter) continue;
            Procedures.Procedure1 _function = symbol -> symbols.add(symbol);
            this.createSymbol(description, resourceAccess, (Procedures.Procedure1<? super SymbolInformation>)_function);
        }
        return symbols;
    }

    protected boolean filter(IEObjectDescription description, String query) {
        return description.getQualifiedName().toLowerCase().toString().contains(query.toLowerCase());
    }

    protected void createSymbol(IEObjectDescription description, IReferenceFinder.IResourceAccess resourceAccess, Procedures.Procedure1<? super SymbolInformation> acceptor) {
        String name = this.getSymbolName(description);
        if (name == null) {
            return;
        }
        SymbolKind kind = this.getSymbolKind(description);
        if (kind == null) {
            return;
        }
        Procedures.Procedure1 _function = location -> {
            SymbolInformation symbol = new SymbolInformation(name, kind, location);
            acceptor.apply((Object)symbol);
        };
        this.getSymbolLocation(description, resourceAccess, (Procedures.Procedure1<? super Location>)_function);
    }

    protected SymbolInformation createSymbol(IEObjectDescription description) {
        String symbolName = this.getSymbolName(description);
        if (symbolName == null) {
            return null;
        }
        SymbolKind symbolKind = this.getSymbolKind(description);
        if (symbolKind == null) {
            return null;
        }
        SymbolInformation symbol = new SymbolInformation();
        symbol.setName(symbolName);
        symbol.setKind(symbolKind);
        return symbol;
    }

    protected String getSymbolName(IEObjectDescription description) {
        return this.getSymbolName(description.getQualifiedName());
    }

    protected SymbolKind getSymbolKind(IEObjectDescription description) {
        return this.getSymbolKind(description.getEClass());
    }

    protected void getSymbolLocation(IEObjectDescription description, IReferenceFinder.IResourceAccess resourceAccess, Procedures.Procedure1<? super Location> acceptor) {
        Procedures.Procedure1 _function = obj -> {
            Location location = this.getSymbolLocation((EObject)obj);
            if (location != null) {
                acceptor.apply((Object)location);
            }
        };
        this.doRead(resourceAccess, description.getEObjectURI(), (Procedures.Procedure1<? super EObject>)_function);
    }

    protected String getSymbolName(QualifiedName qualifiedName) {
        String _string = null;
        if (qualifiedName != null) {
            _string = qualifiedName.toString();
        }
        return _string;
    }

    protected SymbolKind getSymbolKind(EClass type) {
        return SymbolKind.Property;
    }

    protected void doRead(IReferenceFinder.IResourceAccess resourceAccess, URI objectURI, Procedures.Procedure1<? super EObject> acceptor) {
        IUnitOfWork _function = resourceSet -> {
            EObject object = resourceSet.getEObject(objectURI, true);
            if (object != null) {
                acceptor.apply((Object)object);
            }
            return null;
        };
        resourceAccess.readOnly(objectURI, _function);
    }
}

