/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser;

import java.io.File;
import org.eclipse.core.runtime.Path;

public final class AcceleoFile {
    private File mtlFile;
    private String fullModuleName;

    public AcceleoFile(File mtlFile, String fullModuleName) {
        this.mtlFile = mtlFile;
        this.fullModuleName = fullModuleName;
    }

    public static String javaPackageToFullModuleName(String javaPackageName, String moduleName) {
        if (javaPackageName != null && javaPackageName.length() > 0) {
            return String.valueOf(javaPackageName.replaceAll("\\.", "::")) + "::" + moduleName;
        }
        return moduleName;
    }

    public static String simpleModuleName(File mtlFile) {
        return new Path(mtlFile.getName()).removeFileExtension().lastSegment();
    }

    public static String relativePathToFullModuleName(String relativePath) {
        StringBuilder fullModuleName = new StringBuilder();
        String[] segments = new Path(relativePath).removeFileExtension().segments();
        int i = 0;
        while (i < segments.length) {
            if (i != 0) {
                fullModuleName.append("::");
            }
            fullModuleName.append(segments[i]);
            ++i;
        }
        return fullModuleName.toString();
    }

    public File getMtlFile() {
        return this.mtlFile;
    }

    public String getFullModuleName() {
        return this.fullModuleName;
    }
}

