/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.dnd.AbstractContainerAreaDropAdapter;
import org.eclipse.cdt.make.internal.ui.dnd.AbstractSelectionDragAdapter;
import org.eclipse.cdt.make.internal.ui.dnd.FileTransferDropTargetListener;
import org.eclipse.cdt.make.internal.ui.dnd.LocalTransferDragSourceListener;
import org.eclipse.cdt.make.internal.ui.dnd.LocalTransferDropTargetListener;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransfer;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransferDragSourceListener;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransferDropTargetListener;
import org.eclipse.cdt.make.internal.ui.dnd.TextTransferDragSourceListener;
import org.eclipse.cdt.make.internal.ui.dnd.TextTransferDropTargetListener;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.make.ui.MakeContentProvider;
import org.eclipse.cdt.make.ui.MakeLabelProvider;
import org.eclipse.cdt.make.ui.TargetSourceContainer;
import org.eclipse.cdt.make.ui.views.AddTargetAction;
import org.eclipse.cdt.make.ui.views.BuildTargetAction;
import org.eclipse.cdt.make.ui.views.CopyTargetAction;
import org.eclipse.cdt.make.ui.views.DeleteTargetAction;
import org.eclipse.cdt.make.ui.views.EditTargetAction;
import org.eclipse.cdt.make.ui.views.FilterEmtpyFoldersAction;
import org.eclipse.cdt.make.ui.views.PasteTargetAction;
import org.eclipse.cdt.make.ui.views.RebuildLastTargetAction;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class MakeView
extends ViewPart {
    private static final String TARGET_BUILD_LAST_COMMAND = "org.eclipse.cdt.make.ui.targetBuildLastCommand";
    private Clipboard clipboard;
    private BuildTargetAction buildTargetAction;
    private RebuildLastTargetAction buildLastTargetAction;
    private EditTargetAction editTargetAction;
    private DeleteTargetAction deleteTargetAction;
    private AddTargetAction newTargetAction;
    private CopyTargetAction copyTargetAction;
    private PasteTargetAction pasteTargetAction;
    private TreeViewer fViewer;
    private DrillDownAdapter drillDownAdapter;
    private FilterEmtpyFoldersAction trimEmptyFolderAction;
    private IBindingService bindingService;
    private IBindingManagerListener bindingManagerListener = new IBindingManagerListener(){

        public void bindingManagerChanged(BindingManagerEvent event) {
            if (event.isActiveBindingsChanged()) {
                String keyBinding = MakeView.this.bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.rename");
                if (keyBinding != null) {
                    MakeView.this.editTargetAction.setText(String.valueOf(MakeUIPlugin.getResourceString("EditTargetAction.label")) + "\t" + keyBinding);
                }
                if ((keyBinding = MakeView.this.bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.copy")) != null) {
                    MakeView.this.copyTargetAction.setText(String.valueOf(MakeUIPlugin.getResourceString("CopyTargetAction.label")) + "\t" + keyBinding);
                }
                if ((keyBinding = MakeView.this.bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.paste")) != null) {
                    MakeView.this.pasteTargetAction.setText(String.valueOf(MakeUIPlugin.getResourceString("PasteTargetAction.label")) + "\t" + keyBinding);
                }
                if ((keyBinding = MakeView.this.bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.delete")) != null) {
                    MakeView.this.deleteTargetAction.setText(String.valueOf(MakeUIPlugin.getResourceString("DeleteTargetAction.label")) + "\t" + keyBinding);
                }
                if ((keyBinding = MakeView.this.bindingService.getBestActiveBindingFormattedFor(MakeView.TARGET_BUILD_LAST_COMMAND)) != null) {
                    MakeView.this.buildLastTargetAction.setText(String.valueOf(MakeUIPlugin.getResourceString("BuildLastTargetAction.label")) + "\t" + keyBinding);
                }
            }
        }
    };

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    public void createPartControl(Composite parent) {
        MakeUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)parent, IMakeHelpContextIds.MAKE_VIEW);
        this.fViewer = new TreeViewer(parent, 770);
        this.fViewer.setUseHashlookup(true);
        this.fViewer.setContentProvider((IContentProvider)new MakeContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MakeLabelProvider());
        this.initDragAndDrop();
        this.drillDownAdapter = new DrillDownAdapter(this.fViewer);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MakeView.this.handleDoubleClick(event);
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MakeView.this.handleSelectionChanged(event);
            }
        });
        this.fViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof TargetSourceContainer) {
                    return 1;
                }
                if (element instanceof IResource) {
                    return 2;
                }
                return 3;
            }
        });
        this.fViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.updateActions((IStructuredSelection)this.fViewer.getSelection());
        this.bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (this.bindingService != null) {
            this.bindingService.addBindingManagerListener(this.bindingManagerListener);
        }
    }

    private void initDragAndDrop() {
        int opers = 3;
        Transfer[] dragTransfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), MakeTargetTransfer.getInstance(), TextTransfer.getInstance()};
        AbstractSelectionDragAdapter[] dragListeners = new AbstractSelectionDragAdapter[]{new LocalTransferDragSourceListener((ISelectionProvider)this.fViewer), new MakeTargetTransferDragSourceListener((ISelectionProvider)this.fViewer), new TextTransferDragSourceListener((ISelectionProvider)this.fViewer)};
        DelegatingDragAdapter delegatingDragAdapter = new DelegatingDragAdapter();
        AbstractSelectionDragAdapter[] abstractSelectionDragAdapterArray = dragListeners;
        int n = dragListeners.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractSelectionDragAdapter dragListener = abstractSelectionDragAdapterArray[n2];
            delegatingDragAdapter.addDragSourceListener((TransferDragSourceListener)dragListener);
            ++n2;
        }
        this.fViewer.addDragSupport(opers, dragTransfers, (DragSourceListener)delegatingDragAdapter);
        Transfer[] dropTransfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), MakeTargetTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()};
        AbstractContainerAreaDropAdapter[] dropListeners = new AbstractContainerAreaDropAdapter[]{new LocalTransferDropTargetListener((Viewer)this.fViewer), new MakeTargetTransferDropTargetListener((Viewer)this.fViewer), new FileTransferDropTargetListener((Viewer)this.fViewer), new TextTransferDropTargetListener((Viewer)this.fViewer)};
        DelegatingDropAdapter delegatingDropAdapter = new DelegatingDropAdapter();
        AbstractContainerAreaDropAdapter[] abstractContainerAreaDropAdapterArray = dropListeners;
        int n3 = dropListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            AbstractContainerAreaDropAdapter dropListener = abstractContainerAreaDropAdapterArray[n4];
            delegatingDropAdapter.addDropTargetListener((TransferDropTargetListener)dropListener);
            ++n4;
        }
        this.fViewer.addDropSupport(opers | 0x10, dropTransfers, (DropTargetListener)delegatingDropAdapter);
    }

    private void makeActions() {
        Shell shell = this.fViewer.getControl().getShell();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.buildTargetAction = new BuildTargetAction(shell);
        this.buildLastTargetAction = new RebuildLastTargetAction();
        this.newTargetAction = new AddTargetAction(shell);
        this.copyTargetAction = new CopyTargetAction(shell, this.clipboard, this.pasteTargetAction);
        this.pasteTargetAction = new PasteTargetAction(shell, this.clipboard);
        this.deleteTargetAction = new DeleteTargetAction(shell);
        this.editTargetAction = new EditTargetAction(shell);
        this.trimEmptyFolderAction = new FilterEmtpyFoldersAction(this.fViewer);
    }

    private void contributeToActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(actionBars.getMenuManager());
        this.fillLocalToolBar(actionBars.getToolBarManager());
        TextActionHandler textActionHandler = new TextActionHandler(actionBars);
        textActionHandler.setCopyAction((IAction)this.copyTargetAction);
        textActionHandler.setPasteAction((IAction)this.pasteTargetAction);
        textActionHandler.setDeleteAction((IAction)this.deleteTargetAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.editTargetAction);
    }

    private void fillLocalToolBar(IToolBarManager toolBar) {
        toolBar.add((IAction)this.newTargetAction);
        toolBar.add((IAction)this.editTargetAction);
        toolBar.add((IAction)this.buildTargetAction);
        toolBar.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(toolBar);
        toolBar.add((IAction)this.trimEmptyFolderAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MakeView.this.fillContextMenu(manager);
                MakeView.this.updateActions((IStructuredSelection)MakeView.this.fViewer.getSelection());
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.newTargetAction);
        manager.add((IAction)this.editTargetAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyTargetAction);
        manager.add((IAction)this.pasteTargetAction);
        manager.add((IAction)this.deleteTargetAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.buildTargetAction);
        manager.add((IAction)this.buildLastTargetAction);
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        this.buildTargetAction.run();
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateActions(sel);
    }

    void updateActions(IStructuredSelection sel) {
        this.newTargetAction.selectionChanged(sel);
        this.buildTargetAction.selectionChanged(sel);
        this.buildLastTargetAction.selectionChanged(sel);
        this.deleteTargetAction.selectionChanged(sel);
        this.editTargetAction.selectionChanged(sel);
        this.copyTargetAction.selectionChanged(sel);
        this.pasteTargetAction.selectionChanged(sel);
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        if (this.bindingService != null) {
            this.bindingService.removeBindingManagerListener(this.bindingManagerListener);
            this.bindingService = null;
        }
        super.dispose();
    }
}

