/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CommitCombo
extends Composite {
    private final List<ComboCommitEnt> commits;
    private final Combo combo = new Combo((Composite)this, 4);

    public CommitCombo(Composite parent, int style) {
        super(parent, style);
        this.commits = new ArrayList<ComboCommitEnt>();
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        this.setLayoutData(GridDataFactory.fillDefaults().create());
        GridData totalLabelData = new GridData();
        totalLabelData.horizontalAlignment = 4;
        totalLabelData.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData((Object)totalLabelData);
        this.combo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (CommitCombo.this.getValue() == null) {
                    CommitCombo.this.combo.setText("");
                }
            }
        });
        UIUtils.addBulbDecorator((Control)this.combo, UIText.CommitCombo_showSuggestedCommits);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.combo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new CommitContentProposalProvider(), null, null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(2);
    }

    public void add(RevCommit revCommit) {
        Assert.isNotNull((Object)revCommit);
        this.checkWidget();
        String shortSha1 = Utils.getShortObjectId((ObjectId)revCommit);
        String message = String.valueOf(shortSha1) + ": " + revCommit.getShortMessage();
        this.combo.add(message);
        this.commits.add(new ComboCommitEnt(revCommit.getId(), message));
    }

    public ObjectId getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.commits.size()) {
            SWT.error((int)6);
        }
        return this.commits.get(index).objectId;
    }

    public int getItemCount() {
        return this.commits.size();
    }

    public int getSelectedIndex() {
        int selectionIndex = this.combo.getSelectionIndex();
        if (selectionIndex == -1) {
            selectionIndex = this.combo.indexOf(this.combo.getText());
        }
        return selectionIndex;
    }

    public ObjectId getValue() {
        int selectionIndex = this.getSelectedIndex();
        return -1 != selectionIndex ? this.getItem(selectionIndex) : null;
    }

    public void setSelectedElement(ObjectId objectId) {
        if (objectId == null) {
            return;
        }
        int i = 0;
        while (i < this.commits.size()) {
            if (objectId.equals((AnyObjectId)this.commits.get(i).objectId)) {
                this.combo.select(i);
                break;
            }
            ++i;
        }
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void clearSelection() {
        this.combo.clearSelection();
        this.combo.setText("");
    }

    private static class ComboCommitEnt {
        private final String message;
        private final ObjectId objectId;

        public ComboCommitEnt(ObjectId objecId, String message) {
            this.objectId = objecId;
            this.message = message;
        }
    }

    private class CommitContentProposalProvider
    implements IContentProposalProvider {
        private CommitContentProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            ArrayList<IContentProposal> list = new ArrayList<IContentProposal>();
            Pattern pattern = Pattern.compile(contents, 2);
            int i = 0;
            while (i < CommitCombo.this.commits.size()) {
                String message = ((ComboCommitEnt)CommitCombo.this.commits.get(i)).message;
                if (message.length() >= contents.length() && pattern.matcher(message).find()) {
                    list.add(this.makeContentProposal(message));
                }
                ++i;
            }
            return list.toArray(new IContentProposal[0]);
        }

        private IContentProposal makeContentProposal(final String proposal) {
            return new IContentProposal(){

                public String getContent() {
                    return proposal;
                }

                public String getDescription() {
                    return null;
                }

                public String getLabel() {
                    return null;
                }

                public int getCursorPosition() {
                    return proposal.length();
                }
            };
        }
    }
}

