/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.server.rest;

import com.google.common.base.Optional;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ide.server.Proxies;
import org.eclipse.epp.internal.logging.aeri.ide.server.json.Json;
import org.eclipse.epp.internal.logging.aeri.ide.server.mars.IO;
import org.eclipse.epp.internal.logging.aeri.ide.server.mars.IProblemsHistory;
import org.eclipse.epp.internal.logging.aeri.ide.server.mars.ServerConfiguration;
import org.eclipse.epp.internal.logging.aeri.ide.server.rest.Link;
import org.eclipse.epp.internal.logging.aeri.ide.server.rest.LuceneHttpCacheStorage;
import org.eclipse.epp.internal.logging.aeri.ide.server.rest.ProblemSituation;
import org.eclipse.epp.internal.logging.aeri.ide.server.rest.StatusReponse;
import org.eclipse.epp.logging.aeri.core.ILink;
import org.eclipse.epp.logging.aeri.core.IModelFactory;
import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.ProblemStatus;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.epp.logging.aeri.core.util.Statuses;

public class RestBasedProblemsHistory
implements IProblemsHistory {
    private static final ContentType STATUS_REPONSES_CONTENT_TYPE = ContentType.create((String)"application/x.aer.status-reponses+json");
    private static final String STACK_TRACE_FINGERPRINT__QUERY = "stackTraceFingerprint";
    private final ServerConfiguration config;
    private final URI baseURI;
    private final LuceneHttpCacheStorage storage;
    private final CloseableHttpClient client;
    private final Executor executor;
    private Date embargoDate = new Date();

    public RestBasedProblemsHistory(ServerConfiguration config, File cacheDir) throws IOException {
        this.config = config;
        try {
            this.baseURI = new URI(config.getInterestUrl());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        FSDirectory directory = FSDirectory.open((Path)cacheDir.toPath());
        this.storage = new LuceneHttpCacheStorage((Directory)directory);
        this.client = this.createClient(this.storage);
        this.executor = Executor.newInstance((HttpClient)this.client);
    }

    @Override
    public Optional<IProblemState> seen(IStatus status) {
        URI restURI;
        Date now = new Date();
        if (now.before(this.embargoDate)) {
            Logs.log((Logs.ILogMessage)LogMessages.INFO_TEMPORARILY_DISABLED_REST_QUERIES, (Object[])new Object[]{this.config.getTitle()});
            return Optional.absent();
        }
        String fingerprint = Statuses.traceIdentityHash((IStatus)status);
        try {
            restURI = new URIBuilder(this.baseURI).addParameter(STACK_TRACE_FINGERPRINT__QUERY, fingerprint).build();
        }
        catch (URISyntaxException uRISyntaxException) {
            return Optional.absent();
        }
        try {
            Request request = Request.Get((URI)restURI).addHeader("Accept", STATUS_REPONSES_CONTENT_TYPE.toString()).viaProxy((HttpHost)Proxies.getProxyHost(restURI).orNull()).connectTimeout(this.config.getConnectTimeoutMs()).staleConnectionCheck(true).socketTimeout(this.config.getSocketTimeoutMs());
            StatusReponse statusReponse = (StatusReponse)Proxies.proxyAuthentication(this.executor, restURI).execute(request).handleResponse((ResponseHandler)new RestReponseHandler());
            if (statusReponse != null) {
                return Optional.of((Object)this.toProblemState(statusReponse));
            }
            return Optional.absent();
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REST_QUERY_FAILED, (Throwable)e, (Object[])new Object[]{this.config.getTitle(), restURI});
            return Optional.absent();
        }
    }

    @Override
    public void sync(IO io, ISystemSettings systemSettings) {
    }

    @Override
    public void close() throws IOException {
        this.client.close();
        this.storage.close();
    }

    private IProblemState toProblemState(StatusReponse serverResponse) {
        IProblemState mProblemState = IModelFactory.eINSTANCE.createProblemState();
        mProblemState.setStatus(this.toProblemStatus(serverResponse.getSituation()));
        mProblemState.setMessage(serverResponse.getMessage());
        for (String auxiliaryInformationRequest : serverResponse.getAuxiliaryInformationRequests()) {
            mProblemState.getNeedinfo().add((Object)auxiliaryInformationRequest);
        }
        for (Link link : serverResponse.getLinks()) {
            ILink mLink = IModelFactory.eINSTANCE.createLink();
            mLink.setHref(link.getHref().toString());
            mLink.setRel(link.getRel());
            mLink.setTitle(link.getTitle());
            mProblemState.getLinks().put((Object)link.getRel(), (Object)mLink);
        }
        return mProblemState;
    }

    private ProblemStatus toProblemStatus(ProblemSituation situation) {
        switch (situation) {
            case FAILURE: {
                return ProblemStatus.FAILURE;
            }
            case FIXED: {
                return ProblemStatus.FIXED;
            }
            case IGNORE: {
                return ProblemStatus.IGNORED;
            }
            case OPEN: {
                return ProblemStatus.CONFIRMED;
            }
            case WONTFIX: {
                return ProblemStatus.WONTFIX;
            }
        }
        throw new IllegalArgumentException(situation.toString());
    }

    private CloseableHttpClient createClient(HttpCacheStorage storage) {
        CachingHttpClientBuilder builder = CachingHttpClients.custom().setHttpCacheStorage(storage);
        try {
            Method buildMethod = CachingHttpClientBuilder.class.getMethod("build", new Class[0]);
            return (CloseableHttpClient)buildMethod.invoke((Object)builder, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Date parseRetryAfter(String retryAfter) {
        if (retryAfter != null) {
            try {
                return new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(Long.parseLong(retryAfter)));
            }
            catch (NumberFormatException numberFormatException) {
                Date date = DateUtils.parseDate((String)retryAfter);
                return date != null ? date : this.tomorrow();
            }
        }
        return this.tomorrow();
    }

    private Date tomorrow() {
        return new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L));
    }

    private final class RestReponseHandler
    implements ResponseHandler<StatusReponse> {
        private RestReponseHandler() {
        }

        public StatusReponse handleResponse(HttpResponse response) throws IOException {
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() == 404) {
                return null;
            }
            if (statusLine.getStatusCode() >= 500) {
                Header retryAfterHeader = response.getFirstHeader("Retry-After");
                if (retryAfterHeader != null) {
                    RestBasedProblemsHistory.this.embargoDate = RestBasedProblemsHistory.this.parseRetryAfter(retryAfterHeader.getValue());
                }
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            if (entity == null) {
                throw new ClientProtocolException("Response contains no content");
            }
            ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
            if (!contentType.getMimeType().equals(STATUS_REPONSES_CONTENT_TYPE.getMimeType())) {
                throw new ClientProtocolException("Unexpected content type: " + contentType);
            }
            try {
                List statusResponses = (List)Json.deserialize(entity.getContent(), new TypeToken<List<StatusReponse>>(){}.getType());
                if (statusResponses.isEmpty()) {
                    throw new IOException("Expected at least one status response");
                }
                return (StatusReponse)statusResponses.get(0);
            }
            catch (Exception e) {
                throw new ClientProtocolException("Cannot parse content", (Throwable)e);
            }
        }
    }
}

