/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.conversion;

import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.fontname.FontName;
import org.eclipse.gef.dot.internal.language.fontname.Weight;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.xtext.parser.IParser;

public class DotFontUtil {
    private SystemFontAccess access = new JavafxFontAccess();

    public String cssLocalFontFamily(FontName name) {
        return this.findLocalFamily(name).getFamily();
    }

    private Font findLocalFamily(FontName dotFont) {
        Font font = this.access.getDefault();
        for (String alternative : dotFont.getFontFamilies()) {
            font = this.access.font(alternative);
            if (!this.isDefaultFont(font)) break;
        }
        return font;
    }

    private boolean isDefaultFont(Font font) {
        return font == null || font.equals(this.access.getDefault());
    }

    public String cssWeight(FontName dotFont) {
        Weight weight = dotFont.getWeight();
        return Integer.toString(this.intWeight(weight));
    }

    private int intWeight(Weight weight) {
        if (weight == null) {
            weight = Weight.NORMAL;
        }
        switch (weight) {
            case THIN: {
                return 100;
            }
            case ULTRALIGHT: {
                return 200;
            }
            case LIGHT: {
                return 300;
            }
            case SEMILIGHT: {
                return 300;
            }
            case BOOK: {
                return 400;
            }
            case MEDIUM: {
                return 500;
            }
            case SEMIBOLD: {
                return 600;
            }
            case BOLD: {
                return 700;
            }
            case ULTRABOLD: {
                return 800;
            }
            case HEAVY: 
            case ULTRAHEAVY: {
                return 900;
            }
        }
        return 400;
    }

    public String cssStyle(FontName dotFont) {
        return dotFont.getStyle() != null ? dotFont.getStyle().getName().toLowerCase(Locale.ENGLISH) : "normal";
    }

    public FontName parseHtmlFontFace(String face) {
        if (face == null) {
            return null;
        }
        IParser parser = (IParser)DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotFontName").getInstance(IParser.class);
        EObject rootNode = parser.parse((Reader)new StringReader(face)).getRootASTElement();
        if (rootNode instanceof FontName) {
            return (FontName)rootNode;
        }
        return null;
    }

    public void setSystemFontAccess(SystemFontAccess access) {
        this.access = access;
    }

    public static interface Font {
        public String getFamily();

        public boolean equals(Font var1);
    }

    final class JavafxFontAccess
    implements SystemFontAccess {
        JavafxFontAccess() {
        }

        @Override
        public Font getDefault() {
            return new JavaFxFont(javafx.scene.text.Font.getDefault());
        }

        @Override
        public Font font(String family) {
            return new JavaFxFont(javafx.scene.text.Font.font((String)family));
        }

        final class JavaFxFont
        implements Font {
            private final javafx.scene.text.Font fxFont;

            JavaFxFont(javafx.scene.text.Font fxFont) {
                this.fxFont = fxFont;
            }

            @Override
            public String getFamily() {
                return this.fxFont.getFamily();
            }

            @Override
            public boolean equals(Font font) {
                return font instanceof JavaFxFont && this.fxFont.equals((Object)((JavaFxFont)font).fxFont);
            }
        }
    }

    public static interface SystemFontAccess {
        public Font getDefault();

        public Font font(String var1);
    }
}

