/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.conversion;

import com.google.inject.Injector;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.gef.dot.internal.language.fontname.FontName;
import org.eclipse.gef.dot.internal.language.htmllabel.DotHtmlLabelHelper;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlLabel;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.language.parser.antlr.DotHtmlLabelParser;
import org.eclipse.gef.dot.internal.ui.conversion.DotColorUtil;
import org.eclipse.gef.dot.internal.ui.conversion.DotFontUtil;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.xtext.parser.IParseResult;

class DotHTMLLabelJavaFxNode {
    private final DotColorUtil colorUtil;
    private final DotFontUtil fontUtil;
    private final TagStyleContainer defaultStyle;
    private final TagStyleContainer nodeStyle;
    private final HtmlLabel root;
    private final String colorscheme;

    public DotHTMLLabelJavaFxNode(String label, String face, String size, String color, String colorscheme, DotColorUtil colorUtil, DotFontUtil fontUtil) {
        this.colorUtil = colorUtil;
        this.fontUtil = fontUtil;
        this.colorscheme = colorscheme;
        this.root = this.parseLabel(label);
        this.defaultStyle = new TagStyleContainer(null, "Times-Roman", "14", "black");
        this.nodeStyle = new TagStyleContainer(this.defaultStyle, face, size, color);
    }

    public Pane getFxElement() {
        Pane element = this.drawLabel(this.root);
        return element;
    }

    public Bounds getBounds() {
        Group fxElement = new Group(new Node[]{this.getFxElement()});
        new Scene((Parent)fxElement);
        fxElement.applyCss();
        fxElement.layout();
        return fxElement.getBoundsInParent();
    }

    private HtmlLabel parseLabel(String label) {
        Injector labelInjector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotHtmlLabel");
        DotHtmlLabelParser parser = (DotHtmlLabelParser)labelInjector.getInstance(DotHtmlLabelParser.class);
        IParseResult result = parser.parse((Reader)new StringReader(label != null ? label : new String()));
        return (HtmlLabel)result.getRootASTElement();
    }

    private Pane drawLabel(HtmlLabel label) {
        return this.drawContents((List<HtmlContent>)label.getParts(), this.nodeStyle, null);
    }

    private Pane drawContents(List<HtmlContent> contents, TagStyleContainer parentStyle, Pos bAlign) {
        if (contents.size() <= 0) {
            return new Pane();
        }
        if (this.isTableCase(contents)) {
            return this.drawTableParents(this.firstTagWhitespaceIgnored(contents), parentStyle);
        }
        return this.drawText(contents, parentStyle, bAlign);
    }

    private boolean isTableCase(List<HtmlContent> contents) {
        HtmlTag tag = this.firstTagWhitespaceIgnored(contents);
        if (tag == null) {
            return false;
        }
        if (tag.getName().equalsIgnoreCase("table")) {
            return true;
        }
        return this.isTableCase((List<HtmlContent>)tag.getChildren());
    }

    private HtmlTag firstTagWhitespaceIgnored(List<HtmlContent> contents) {
        if (contents.size() <= 0) {
            return null;
        }
        HtmlContent content0 = contents.get(0);
        if (this.isWhitespaceOnlyTag(content0) && contents.size() > 1) {
            content0 = contents.get(1);
        }
        return content0.getTag();
    }

    private boolean isWhitespaceOnlyTag(HtmlContent content) {
        return content.getTag() == null && content.getText() != null && content.getText().matches("\\A\\s*\\z");
    }

    private Pane drawTableParents(HtmlTag tag, TagStyleContainer parentStyle) {
        if (tag.getName().equalsIgnoreCase("table")) {
            return this.drawTable(tag, parentStyle);
        }
        return this.drawTableParents(this.firstTagWhitespaceIgnored((List<HtmlContent>)tag.getChildren()), this.tagStyleContainer(tag, parentStyle));
    }

    private Pane drawText(List<HtmlContent> contents, TagStyleContainer parentStyle, Pos bAlign) {
        TextFXBuilder builder = new TextFXBuilder(bAlign);
        contents.forEach(content -> this.handleTextContent(builder, (HtmlContent)content, parentStyle));
        return builder.getFxElement();
    }

    private void handleTextTag(TextFXBuilder builder, HtmlTag tag, TagStyleContainer parentStyle) {
        switch (tag.getName().toLowerCase()) {
            case "br": {
                builder.breakLine(this.getPosForBr(tag));
                return;
            }
            case "table": {
                return;
            }
        }
        TagStyleContainer tagStyleContainer = this.tagStyleContainer(tag, parentStyle);
        for (HtmlContent child : tag.getChildren()) {
            this.handleTextContent(builder, child, tagStyleContainer);
        }
    }

    private TagStyleContainer tagStyleContainer(HtmlTag tag, TagStyleContainer parentStyle) {
        switch (tag.getName().toLowerCase()) {
            case "font": {
                return this.fontTagStyleContainer(tag, parentStyle);
            }
        }
        return this.simpleTagStyleContainer(tag, parentStyle);
    }

    private TagStyleContainer simpleTagStyleContainer(HtmlTag tag, TagStyleContainer parentStyle) {
        TagStyle tagStyle = null;
        try {
            tagStyle = TagStyle.valueOf(tag.getName().toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return new TagStyleContainer(parentStyle, tagStyle);
    }

    private TagStyleContainer fontTagStyleContainer(HtmlTag tag, TagStyleContainer parentStyle) {
        String color = this.unquotedValueForAttr(DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"color"));
        String face = this.unquotedValueForAttr(DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"face"));
        String size = this.unquotedValueForAttr(DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"point-size"));
        return new TagStyleContainer(parentStyle, face, size, color);
    }

    private void handleTextContent(TextFXBuilder builder, HtmlContent content, TagStyleContainer parentStyle) {
        if (content.getTag() != null) {
            this.handleTextTag(builder, content.getTag(), parentStyle);
        } else {
            String unescapedText = StringEscapeUtils.unescapeHtml((String)content.getText().replaceAll("[\\t\\n\\x0B\\f\\r]", ""));
            builder.addFormattedString(new FormattedString(parentStyle != null ? parentStyle : new TagStyleContainer(null, null), unescapedText));
        }
    }

    private Pos getPosForBr(HtmlTag brTag) {
        return this.getAlignPosForAttributeNameAndTag("align", brTag);
    }

    private Pos getPosForTdBalign(HtmlTag tdTag) {
        return this.getAlignPosForAttributeNameAndTag("balign", tdTag);
    }

    /*
     * Exception decompiling
     */
    private Pos getAlignPosForAttributeNameAndTag(String attributeName, HtmlTag tag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl30 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl30 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Pane drawTable(HtmlTag tag, TagStyleContainer parentStyle) {
        GridPane fullPane = new GridPane();
        this.applyCssAttributesOnTablePane(fullPane, tag);
        List<HtmlTag> trTags = this.childHtmlTagsOfKind(tag, "TR");
        Map<Integer, BitSet> rowsToFilledCellsMap = this.initializedRowsToFilledCellsMap(trTags.size());
        for (HtmlTag tr : trTags) {
            this.addRowToPane(tag, rowsToFilledCellsMap, tr, trTags.indexOf(tr), fullPane, parentStyle);
        }
        return fullPane;
    }

    private void addRowToPane(HtmlTag tag, Map<Integer, BitSet> rowsToFilledCellsMap, HtmlTag tr, int rowIndex, GridPane fullPane, TagStyleContainer parentStyle) {
        for (HtmlTag td : this.childHtmlTagsOfKind(tr, "TD")) {
            this.addCellToPane(tag, rowsToFilledCellsMap, rowIndex, fullPane, parentStyle, td);
        }
    }

    private void addCellToPane(HtmlTag tag, Map<Integer, BitSet> rowsToFilledCellsMap, int rowIndex, GridPane fullPane, TagStyleContainer parentStyle, HtmlTag td) {
        GridPane labelPane = this.styledTdContent(tag, parentStyle, td);
        int colspan = this.getIntSpanAttrValue(td, "colspan");
        int rowspan = this.getIntSpanAttrValue(td, "rowspan");
        int index = rowsToFilledCellsMap.get(rowIndex).nextClearBit(0);
        int row = rowIndex;
        while (row < rowIndex + rowspan && rowsToFilledCellsMap.containsKey(row)) {
            rowsToFilledCellsMap.get(row).set(index, index + colspan);
            ++row;
        }
        fullPane.add((Node)labelPane, index, rowIndex, colspan, rowspan);
    }

    private GridPane styledTdContent(HtmlTag tag, TagStyleContainer parentStyle, HtmlTag td) {
        Pos bAlign = this.getPosForTdBalign(td);
        Pane unstyled = this.drawContents((List<HtmlContent>)td.getChildren(), parentStyle, bAlign);
        GridPane wrapper = new GridPane();
        wrapper.add((Node)unstyled, 0, 0);
        if (!this.isTableCase((List<HtmlContent>)tag.getChildren())) {
            this.applyTextAlignAttributesOnTdPane(wrapper, td);
        } else {
            this.applyTableAlignAttributesOnTdPane(wrapper);
        }
        this.applyCssAttributesOnTdPane((Pane)wrapper, td, tag);
        return wrapper;
    }

    private List<HtmlTag> childHtmlTagsOfKind(HtmlTag tag, String name) {
        return tag.getChildren().stream().filter(child -> child.getTag() != null).map(HtmlContent::getTag).filter(trCandidate -> trCandidate.getName().equalsIgnoreCase(name)).collect(Collectors.toList());
    }

    private Map<Integer, BitSet> initializedRowsToFilledCellsMap(int size) {
        HashMap<Integer, BitSet> tableCellMap = new HashMap<Integer, BitSet>();
        int key = 0;
        while (key < size) {
            tableCellMap.put(key, new BitSet());
            ++key;
        }
        return tableCellMap;
    }

    private void applyCssAttributesOnTablePane(GridPane fullPane, HtmlTag tag) {
        StringBuilder css = new StringBuilder();
        HtmlAttr fixedSize = DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"fixedsize");
        this.appendBgcolorAttribute(css, DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"bgcolor"), DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"style"), DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"gradientangle"));
        this.appendBorderAttribute(css, DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"border"));
        this.appendColorAttribute(css, DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"color"));
        this.appendHeightAttribute(css, DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"height"), fixedSize);
        this.appendSidesAttribute(css, DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"sides"));
        this.appendStyleTableAttribute(css, DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"style"));
        this.appendWidthAttribute(css, DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)"width"), fixedSize);
        fullPane.setStyle(css.toString());
    }

    private void applyCssAttributesOnTdPane(Pane labelPane, HtmlTag tdTag, HtmlTag tableTag) {
        StringBuilder css = new StringBuilder();
        HtmlAttr fixedSize = DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tdTag, (String)"fixedsize");
        this.appendBgcolorAttribute(css, DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tdTag, (String)"bgcolor"), DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tdTag, (String)"style"), DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tdTag, (String)"gradientangle"));
        this.appendBorderAttribute(css, this.borderAttributeForTd(tdTag, tableTag));
        this.appendColorAttribute(css, DotHtmlLabelHelper.getAttributeForTags((String)"color", (HtmlTag[])new HtmlTag[]{tdTag, tableTag}));
        this.appendHeightAttribute(css, DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tdTag, (String)"height"), fixedSize);
        this.appendSidesAttribute(css, DotHtmlLabelHelper.getAttributeForTags((String)"sides", (HtmlTag[])new HtmlTag[]{tdTag, tableTag}));
        this.appendWidthAttribute(css, DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tdTag, (String)"width"), fixedSize);
        labelPane.setStyle(css.toString());
    }

    private void appendStyleTableAttribute(StringBuilder css, HtmlAttr style) {
        String styleValue;
        if (style != null && (styleValue = this.unquotedValueForAttr(style).toLowerCase()).contains("rounded")) {
            css.append("-fx-border-radius: 5%;");
            css.append("-fx-background-radius: 5%;");
        }
    }

    private void appendSidesAttribute(StringBuilder css, HtmlAttr sides) {
        if (sides != null) {
            String sidesShown = this.unquotedValueForAttr(sides).toLowerCase();
            if (!sidesShown.contains("l")) {
                css.append("-fx-border-left: hidden;");
            }
            if (!sidesShown.contains("t")) {
                css.append("-fx-border-top: hidden;");
            }
            if (!sidesShown.contains("r")) {
                css.append("-fx-border-right: hidden;");
            }
            if (!sidesShown.contains("b")) {
                css.append("-fx-border-bottom: hidden;");
            }
        }
    }

    private void appendHeightAttribute(StringBuilder css, HtmlAttr height, HtmlAttr fixedSize) {
        this.appendDimensionAttribute(css, "height", height, fixedSize);
    }

    private void appendWidthAttribute(StringBuilder css, HtmlAttr width, HtmlAttr fixedSize) {
        this.appendDimensionAttribute(css, "width", width, fixedSize);
    }

    private void appendDimensionAttribute(StringBuilder css, String kind, HtmlAttr dimension, HtmlAttr fixedSize) {
        if (dimension != null) {
            css.append("-fx-min-");
            css.append(kind);
            css.append(":");
            css.append(this.unquotedValueForAttr(dimension));
            css.append(";");
            if (fixedSize != null && this.unquotedValueForAttr(fixedSize).toLowerCase().equals("true")) {
                css.append("-fx-max-");
                css.append(kind);
                css.append(":");
                css.append(this.unquotedValueForAttr(dimension));
                css.append(";");
            }
        }
    }

    private void appendColorAttribute(StringBuilder css, HtmlAttr bordercolor) {
        css.append("-fx-border-color:");
        css.append(bordercolor != null ? this.colorUtil.computeHtmlColor(this.colorscheme, this.unquotedValueForAttr(bordercolor)) : "black");
        css.append(";");
    }

    private void appendBorderAttribute(StringBuilder css, HtmlAttr border) {
        if (border != null) {
            css.append("-fx-border-width:");
            css.append(this.unquotedValueForAttr(border));
            css.append("pt;");
        }
    }

    private HtmlAttr borderAttributeForTd(HtmlTag tdTag, HtmlTag tableTag) {
        HtmlAttr border = DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tdTag, (String)"border");
        if (border == null) {
            border = DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tableTag, (String)"cellborder");
        }
        if (border == null) {
            border = DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tableTag, (String)"border");
        }
        return border;
    }

    private void appendBgcolorAttribute(StringBuilder css, HtmlAttr bgcolor, HtmlAttr style, HtmlAttr gradientAngle) {
        if (bgcolor != null) {
            css.append("-fx-background-color:");
            List colors = Arrays.stream(this.unquotedValueForAttr(bgcolor).split(":")).map(e -> this.colorUtil.computeHtmlColor(this.colorscheme, (String)e)).collect(Collectors.toList());
            if (colors.size() > 1) {
                if (style != null && this.unquotedValueForAttr(style).toLowerCase().contains("radial")) {
                    css.append("radial-gradient(");
                    css.append("center ");
                    css.append("50% 50%");
                    css.append(", ");
                    css.append("radius 50%, ");
                } else {
                    css.append("linear-gradient(");
                    css.append("from 0% 0% to 100% 0%, ");
                }
                css.append((String)colors.get(0));
                css.append(", ");
                css.append((String)colors.get(1));
                css.append(")");
            } else {
                css.append((String)colors.get(0));
            }
            css.append(";");
        }
    }

    private void applyTextAlignAttributesOnTdPane(GridPane wrapper, HtmlTag td) {
        String hAlign = this.unquotedValueForAttr(DotHtmlLabelHelper.getAttributeForTag((HtmlTag)td, (String)"align"));
        String vAlign = this.unquotedValueForAttr(DotHtmlLabelHelper.getAttributeForTag((HtmlTag)td, (String)"valign"));
        if ("text".equalsIgnoreCase(hAlign)) {
            GridPane.setHgrow((Node)((Node)wrapper.getChildren().get(0)), (Priority)Priority.ALWAYS);
        }
        wrapper.setAlignment(this.posForTd(hAlign, vAlign));
    }

    private void applyTableAlignAttributesOnTdPane(GridPane wrapper) {
        GridPane.setHgrow((Node)((Node)wrapper.getChildren().get(0)), (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)((Node)wrapper.getChildren().get(0)), (Priority)Priority.ALWAYS);
        wrapper.setAlignment(Pos.CENTER);
    }

    /*
     * Exception decompiling
     */
    private Pos posForTd(String hAlign, String vAlign) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl81 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl81 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String unquotedValueForAttr(HtmlAttr attr) {
        if (attr == null) {
            return null;
        }
        String value = attr.getValue();
        return value.replace("\"", "");
    }

    private int getIntSpanAttrValue(HtmlTag tag, String name) {
        HtmlAttr attribute = DotHtmlLabelHelper.getAttributeForTag((HtmlTag)tag, (String)name);
        if (attribute == null) {
            return 1;
        }
        return Integer.valueOf(this.unquotedValueForAttr(attribute));
    }

    private class FormattedLine {
        private final List<FormattedString> textitems = new ArrayList<FormattedString>();
        private Pos alignment = null;
        private Pos defaultAlignment;

        public FormattedLine(Pos bAlign) {
            this.defaultAlignment = bAlign != null ? bAlign : Pos.CENTER;
        }

        public void addFormattedString(FormattedString textItem) {
            this.textitems.add(textItem);
        }

        public void setAlignment(Pos pos) {
            if (pos != null) {
                this.alignment = pos;
            }
        }

        public Pane getFxElement() {
            HBox hbox = new HBox();
            hbox.setAlignment(this.alignment != null ? this.alignment : this.defaultAlignment);
            this.textitems.forEach(textitem -> {
                boolean bl = hbox.getChildren().add((Object)textitem.getFxElement());
            });
            return hbox;
        }
    }

    private class FormattedString {
        private final TagStyleContainer style;
        private final String text;

        public FormattedString(TagStyleContainer style, String text) {
            this.style = style;
            this.text = text;
        }

        public Node getFxElement() {
            Text text = new Text(this.text != null ? this.text : "");
            text.setStyle(this.style.getCSS());
            return text;
        }
    }

    private static enum TagStyle {
        I,
        B,
        U,
        O,
        SUB,
        SUP,
        S;


        public String cssStringForTag() {
            switch (this) {
                case I: {
                    return "-fx-font-style: italic;";
                }
                case B: {
                    return "-fx-font-weight: bold;";
                }
                case U: {
                    return "-fx-underline: true;";
                }
                case O: {
                    return "";
                }
                case SUB: {
                    return "-fx-font-size: .83em; -fx-vertical-align: sub";
                }
                case SUP: {
                    return "-fx-font-size: .83em; -fx-vertical-align: super";
                }
                case S: {
                    return "-fx-strikethrough: true;";
                }
            }
            return "";
        }
    }

    private class TagStyleContainer {
        private final TagStyleContainer parent;
        private final TagStyle style;
        private final FontName face;
        private final String size;
        private final String color;

        public TagStyleContainer(TagStyleContainer parent, TagStyle style) {
            this.parent = parent;
            this.style = style;
            this.face = null;
            this.size = null;
            this.color = null;
        }

        public TagStyleContainer(TagStyleContainer parent, String face, String size, String color) {
            this.parent = parent;
            this.style = null;
            this.face = DotHTMLLabelJavaFxNode.this.fontUtil.parseHtmlFontFace(face);
            this.size = size;
            this.color = color;
        }

        private FontName face() {
            if (this.face != null) {
                return this.face;
            }
            if (this.parent != null) {
                return this.parent.face();
            }
            return null;
        }

        private String size() {
            if (this.size != null) {
                return this.size;
            }
            if (this.parent != null) {
                return this.parent.size();
            }
            return null;
        }

        private String color() {
            if (this.color != null) {
                return this.color;
            }
            if (this.parent != null) {
                return this.parent.color();
            }
            return null;
        }

        private String fontCss() {
            String color;
            String size;
            StringBuilder css = new StringBuilder();
            FontName face = this.face();
            if (face != null) {
                css.append("-fx-font-family:\"");
                css.append(DotHTMLLabelJavaFxNode.this.fontUtil.cssLocalFontFamily(face));
                css.append("\";");
                if (!this.tagStyles().contains((Object)TagStyle.B)) {
                    css.append("-fx-font-weight: ");
                    css.append(DotHTMLLabelJavaFxNode.this.fontUtil.cssWeight(face));
                    css.append(";");
                }
                if (!this.tagStyles().contains((Object)TagStyle.I)) {
                    css.append("-fx-font-style: ");
                    css.append(DotHTMLLabelJavaFxNode.this.fontUtil.cssStyle(face));
                    css.append(";");
                }
            }
            if ((size = this.size()) != null) {
                css.append("-fx-font-size:");
                css.append(size);
                css.append(";");
            }
            if ((color = DotHTMLLabelJavaFxNode.this.colorUtil.computeHtmlColor(DotHTMLLabelJavaFxNode.this.colorscheme, this.color())) != null) {
                css.append("-fx-fill:");
                css.append(color);
                css.append(";");
            }
            return css.toString();
        }

        private Set<TagStyle> tagStyles() {
            HashSet<TagStyle> styles;
            Set<Object> set = styles = this.parent == null ? new HashSet() : this.parent.tagStyles();
            if (this.style != null) {
                styles.add(this.style);
            }
            return styles;
        }

        public String getCSS() {
            StringBuilder stringBuilder = new StringBuilder();
            this.tagStyles().forEach(style -> {
                StringBuilder stringBuilder2 = stringBuilder.append(style.cssStringForTag());
            });
            stringBuilder.append(this.fontCss());
            return stringBuilder.toString();
        }
    }

    private class TextFXBuilder {
        private final List<FormattedLine> lines = new ArrayList<FormattedLine>();
        private FormattedLine current;
        private Pos bAlign;

        public TextFXBuilder(Pos bAlign) {
            this.bAlign = bAlign;
            this.newLine();
        }

        public void breakLine(Pos align) {
            this.current.setAlignment(align);
            this.newLine();
        }

        private void newLine() {
            FormattedLine line = new FormattedLine(this.bAlign);
            this.lines.add(line);
            this.current = line;
        }

        public void addFormattedString(FormattedString textItem) {
            this.current.addFormattedString(textItem);
        }

        public Pane getFxElement() {
            VBox vbox = new VBox();
            this.lines.forEach(line -> {
                boolean bl = vbox.getChildren().add((Object)line.getFxElement());
            });
            return vbox;
        }
    }
}

