/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.RestOfArgumentsHandler;

@Command(common=true, usage="usage_checkout")
class Checkout
extends TextBuiltin {
    @Option(name="-b", usage="usage_createBranchAndCheckout")
    private boolean createBranch = false;
    @Option(name="-B", usage="usage_forcedSwitchBranch")
    private boolean forceSwitchBranch = false;
    @Option(name="--force", aliases={"-f"}, usage="usage_forceCheckout")
    private boolean forced = false;
    @Option(name="--orphan", usage="usage_orphan")
    private boolean orphan = false;
    @Argument(required=false, index=0, metaVar="metaVar_name", usage="usage_checkout")
    private String name;
    @Option(name="--", metaVar="metaVar_paths", handler=RestOfArgumentsHandler.class)
    private List<String> paths = new ArrayList<String>();

    Checkout() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void run() throws Exception {
        block28: {
            if (this.createBranch && (head = this.db.resolve("HEAD")) == null) {
                throw Checkout.die(CLIText.get().onBranchToBeBorn);
            }
            var1_1 = null;
            var2_3 = null;
            try {
                block26: {
                    block27: {
                        block24: {
                            block25: {
                                git = new Git(this.db);
                                command = git.checkout().setProgressMonitor((ProgressMonitor)new TextProgressMonitor((Writer)this.errw));
                                if (!this.paths.isEmpty()) {
                                    command.setStartPoint(this.name);
                                    if (this.paths.size() == 1 && this.paths.get(0).equals(".")) {
                                        command.setAllPaths(true);
                                    } else {
                                        command.addPaths(this.paths);
                                    }
                                } else {
                                    command.setCreateBranch(this.createBranch);
                                    command.setName(this.name);
                                    command.setForceRefUpdate(this.forceSwitchBranch);
                                    command.setForced(this.forced);
                                    command.setOrphan(this.orphan);
                                }
                                oldBranch = this.db.getBranch();
                                ref = command.call();
                                if (ref != null) break block24;
                                if (git == null) break block25;
                                git.close();
                            }
                            return;
                        }
                        if (!Repository.shortenRefName((String)ref.getName()).equals(oldBranch)) break block26;
                        this.outw.println(MessageFormat.format(CLIText.get().alreadyOnBranch, new Object[]{this.name}));
                        if (git == null) break block27;
                        git.close();
                    }
                    return;
                }
                try {
                    if (this.createBranch || this.orphan) {
                        this.outw.println(MessageFormat.format(CLIText.get().switchedToNewBranch, new Object[]{this.name}));
                    } else {
                        this.outw.println(MessageFormat.format(CLIText.get().switchedToBranch, new Object[]{Repository.shortenRefName((String)ref.getName())}));
                    }
                    break block28;
                    {
                        catch (RefNotFoundException e) {
                            throw Checkout.die(MessageFormat.format(CLIText.get().pathspecDidNotMatch, new Object[]{this.name}), (Throwable)e);
                        }
                        catch (RefAlreadyExistsException e) {
                            throw Checkout.die(MessageFormat.format(CLIText.get().branchAlreadyExists, new Object[]{this.name}));
                        }
                        catch (CheckoutConflictException e) {
                            builder = new StringBuilder();
                            builder.append(CLIText.get().checkoutConflict);
                            builder.append(System.lineSeparator());
                            ** for (path : e.getConflictingPaths())
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        builder.append(MessageFormat.format(CLIText.get().checkoutConflictPathLine, new Object[]{path}));
                        builder.append(System.lineSeparator());
                        continue;
                    }
lbl69:
                    // 1 sources

                    throw Checkout.die(builder.toString(), (Throwable)e);
                }
                catch (Throwable var1_2) {
                    throw var1_2;
                }
                finally {
                    if (git != null) {
                        git.close();
                    }
                }
            }
            catch (Throwable var2_4) {
                if (var1_1 == null) {
                    var1_1 = var2_4;
                } else if (var1_1 != var2_4) {
                    var1_1.addSuppressed(var2_4);
                }
                throw var1_1;
            }
        }
    }
}

