/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.ui.internal.interpreters;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.LazyFileHandle;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterLibraryBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.AddScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.IAddInterpreterDialogRequestor;
import org.eclipse.dltk.internal.debug.ui.interpreters.IScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.ldt.core.internal.buildpath.LuaExecutionEnvironmentManager;
import org.eclipse.ldt.debug.core.IEmbeddedInterpreterInstallType;
import org.eclipse.ldt.debug.core.internal.interpreter.generic.LuaGenericInterpreterInstallType;
import org.eclipse.ldt.debug.core.internal.model.interpreter.Info;
import org.eclipse.ldt.debug.core.internal.model.interpreter.InterpreterFactory;
import org.eclipse.ldt.debug.core.internal.model.interpreter.impl.InterpreterFactoryImpl;
import org.eclipse.ldt.debug.core.internal.model.interpreter.impl.InterpreterPackageImpl;
import org.eclipse.ldt.debug.core.interpreter.ILuaInterpreterInstallType;
import org.eclipse.ldt.debug.core.interpreter.LuaInterpreterUtil;
import org.eclipse.ldt.debug.ui.internal.Activator;
import org.eclipse.ldt.debug.ui.internal.interpreters.LuaInterpreterEnvironmentVariablesBlock;
import org.eclipse.ldt.debug.ui.internal.interpreters.Messages;
import org.eclipse.ldt.ui.LuaExecutionEnvironmentUIManager;
import org.eclipse.ldt.ui.SWTUtil;
import org.eclipse.ldt.ui.internal.buildpath.LuaExecutionEnvironmentContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class AddLuaInterpreterDialog
extends StatusDialog
implements IScriptInterpreterDialog {
    private IAddInterpreterDialogRequestor requestor;
    private IEnvironment environment;
    private IInterpreterInstall currentInterperter;
    private IInterpreterInstallType[] interpreterInstallTypes;
    private ComboViewer typesCombo;
    private Text nameText;
    private Text pathText;
    private Button browseButton;
    private Text argsText;
    private LuaInterpreterEnvironmentVariablesBlock environementVariableBlock;
    private Button handlesExecutionOption;
    private Group capabilitiesGroup;
    private Button handlesFilesAsArguments;
    private ComboViewer installedEEsComboViewer;

    public AddLuaInterpreterDialog(IAddInterpreterDialogRequestor requestor, Shell shell, IEnvironment environment, IInterpreterInstallType[] interpreterInstallTypes, IInterpreterInstall standin) {
        super(shell);
        this.requestor = requestor;
        this.environment = environment;
        this.currentInterperter = standin;
        this.interpreterInstallTypes = interpreterInstallTypes;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        Point margin = new Point(0, 0);
        margin.x = this.convertHorizontalDLUsToPixels(7);
        margin.y = this.convertVerticalDLUsToPixels(7);
        Point spacing = new Point(0, 0);
        spacing.x = this.convertHorizontalDLUsToPixels(7);
        spacing.y = this.convertVerticalDLUsToPixels(4);
        GridLayoutFactory.swtDefaults().spacing(spacing).margins(margin).numColumns(3).applyTo(container);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)container);
        this.createLabel(container, InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentType);
        this.typesCombo = new ComboViewer(container);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo(this.typesCombo.getControl());
        this.typesCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typesCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IInterpreterInstallType) {
                    return ((IInterpreterInstallType)element).getName();
                }
                return super.getText(element);
            }
        });
        this.createLabel(container, InterpretersMessages.addInterpreterDialog_InterpreterExecutableName);
        this.pathText = new Text(container, 2052);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).hint(300, -1).applyTo((Control)this.pathText);
        this.browseButton = new Button(container, 8);
        this.browseButton.setText(InterpretersMessages.addInterpreterDialog_browse1);
        GridDataFactory.swtDefaults().hint(SWTUtil.getButtonWidthHint((Button)this.browseButton), -1).applyTo((Control)this.browseButton);
        this.createLabel(container, InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentName);
        this.nameText = new Text(container, 2052);
        GridDataFactory.swtDefaults().grab(true, false).span(2, 1).align(4, 0x1000000).applyTo((Control)this.nameText);
        this.createLabel(container, InterpretersMessages.AddInterpreterDialog_iArgs);
        this.argsText = new Text(container, 2052);
        GridDataFactory.swtDefaults().grab(true, false).span(2, 1).align(4, 0x1000000).applyTo((Control)this.argsText);
        this.createLabel(container, Messages.AddLuaInterpreterDialog_linkExecutionEnvironment);
        this.installedEEsComboViewer = new ComboViewer(container, 2056);
        this.installedEEsComboViewer.setContentProvider((IContentProvider)new LuaExecutionEnvironmentContentProvider());
        GridDataFactory.swtDefaults().grab(true, false).span(2, 1).align(4, 1).applyTo(this.installedEEsComboViewer.getControl());
        this.environementVariableBlock = new LuaInterpreterEnvironmentVariablesBlock(new AddInterpreterDialogAdapter(this.requestor, this.getShell(), this.interpreterInstallTypes, this.currentInterperter));
        Composite environmentComposite = (Composite)this.environementVariableBlock.createControl(container);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(environmentComposite);
        GridDataFactory.swtDefaults().grab(true, true).span(3, 1).align(4, 4).applyTo((Control)environmentComposite);
        this.capabilitiesGroup = new Group(container, 0);
        this.capabilitiesGroup.setText(Messages.AddLuaInterpreterDialog_CapabilitesGroupLabel);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(1).applyTo((Composite)this.capabilitiesGroup);
        GridDataFactory.swtDefaults().grab(true, false).span(3, 1).align(4, 4).applyTo((Control)this.capabilitiesGroup);
        this.handlesExecutionOption = new Button((Composite)this.capabilitiesGroup, 32);
        this.handlesExecutionOption.setText(Messages.AddLuaInterpreterDialog_ExecutionOption);
        this.handlesFilesAsArguments = new Button((Composite)this.capabilitiesGroup, 32);
        this.handlesFilesAsArguments.setText(Messages.AddLuaInterpreterDialog_FilesAsArguments);
        AddLuaInterpreterDialog.applyDialogFont((Control)container);
        this.init();
        this.hookListeners();
        return container;
    }

    private Label createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        return label;
    }

    private void hookListeners() {
        this.typesCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddLuaInterpreterDialog.this.updateWidgetDefaultValue();
                AddLuaInterpreterDialog.this.updateWidgetState();
            }
        });
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AddLuaInterpreterDialog.this.browseForInstallation();
            }
        });
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddLuaInterpreterDialog.this.updateStatusLine();
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddLuaInterpreterDialog.this.updateStatusLine();
            }
        });
    }

    private void init() {
        this.typesCombo.setInput((Object)this.interpreterInstallTypes);
        this.typesCombo.getControl().setEnabled(this.currentInterperter == null);
        List installedExecutionEnvironments = LuaExecutionEnvironmentUIManager.getAvailableExecutionEnvironments();
        this.installedEEsComboViewer.setInput((Object)installedExecutionEnvironments);
        if (this.currentInterperter != null) {
            this.typesCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentInterperter.getInterpreterInstallType()));
            if (this.currentInterperter.getInstallLocation().toOSString().length() > 0) {
                this.pathText.setText(this.currentInterperter.getInstallLocation().toOSString());
            }
            this.nameText.setText(this.currentInterperter.getName());
            String args = this.currentInterperter.getInterpreterArgs();
            if (args != null) {
                this.argsText.setText(args);
            }
            this.environementVariableBlock.initializeFrom(this.currentInterperter, this.currentInterperter.getInterpreterInstallType());
            this.handlesExecutionOption.setSelection(LuaInterpreterUtil.interpreterHandlesExecuteOption((IInterpreterInstall)this.currentInterperter));
            this.handlesFilesAsArguments.setSelection(LuaInterpreterUtil.interpreterHandlesFilesAsArgument((IInterpreterInstall)this.currentInterperter));
            String eeName = LuaInterpreterUtil.linkedExecutionEnvironmentName((IInterpreterInstall)this.currentInterperter);
            String eeVersion = LuaInterpreterUtil.linkedExecutionEnvironmentVersion((IInterpreterInstall)this.currentInterperter);
            try {
                LuaExecutionEnvironment ee = LuaExecutionEnvironmentManager.getAvailableExecutionEnvironment((String)eeName, (String)eeVersion);
                if (ee != null) {
                    this.installedEEsComboViewer.setSelection((ISelection)new StructuredSelection((Object)ee));
                }
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
        } else {
            IInterpreterInstallType lua51 = null;
            IInterpreterInstallType luageneric = null;
            IInterpreterInstallType[] iInterpreterInstallTypeArray = this.interpreterInstallTypes;
            int n = this.interpreterInstallTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IInterpreterInstallType type = iInterpreterInstallTypeArray[n2];
                if ("Lua 5.1".equals(type.getName())) {
                    lua51 = type;
                    break;
                }
                if (type instanceof LuaGenericInterpreterInstallType) {
                    luageneric = type;
                }
                ++n2;
            }
            if (lua51 != null) {
                this.typesCombo.setSelection((ISelection)new StructuredSelection(lua51));
            } else {
                this.typesCombo.setSelection((ISelection)new StructuredSelection(luageneric));
            }
            this.updateWidgetDefaultValue();
        }
        this.updateWidgetState();
        this.environementVariableBlock.update();
    }

    private void updateWidgetDefaultValue() {
        List installedExecutionEnvironments;
        IInterpreterInstallType selectedType = this.getSelectedInterpreterType();
        String defaultPath = "";
        String defaultName = "";
        String defaultArgs = "";
        boolean defaultHandlesFilesAsArguments = true;
        boolean defaulthandlesExecutionOption = true;
        LuaExecutionEnvironment defaultee = null;
        if (selectedType instanceof ILuaInterpreterInstallType) {
            ILuaInterpreterInstallType selectedLuaInterpreterType = (ILuaInterpreterInstallType)selectedType;
            if (selectedLuaInterpreterType.isEmbeddedInterpreter()) {
                defaultPath = "(Embedded)";
            }
            if (selectedLuaInterpreterType.getDefaultInterpreterName() != null) {
                defaultName = selectedLuaInterpreterType.getDefaultInterpreterName();
            }
            if (selectedLuaInterpreterType.getDefaultInterpreterArguments() != null) {
                defaultArgs = selectedLuaInterpreterType.getDefaultInterpreterArguments();
            }
            defaulthandlesExecutionOption = selectedLuaInterpreterType.handleExecuteOption();
            defaultHandlesFilesAsArguments = selectedLuaInterpreterType.handleFilesAsArgument();
            try {
                defaultee = LuaExecutionEnvironmentManager.getAvailableExecutionEnvironment((String)selectedLuaInterpreterType.getDefaultEEName(), (String)selectedLuaInterpreterType.getDefaultEEVersion());
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
        } else if (selectedType instanceof IEmbeddedInterpreterInstallType) {
            defaultPath = "(Embedded)";
        }
        if (defaultee == null && (installedExecutionEnvironments = LuaExecutionEnvironmentUIManager.getAvailableExecutionEnvironments()).size() > 0) {
            ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, LuaLanguageToolkit.getDefault().getPreferenceQualifier());
            String defaultEEId = preferenceStore.getString("EE__default_id");
            for (LuaExecutionEnvironment execEnv : installedExecutionEnvironments) {
                if (!execEnv.getEEIdentifier().equals(defaultEEId)) continue;
                defaultee = execEnv;
            }
            if (defaultee == null) {
                defaultee = (LuaExecutionEnvironment)installedExecutionEnvironments.get(0);
            }
        }
        this.pathText.setText(defaultPath);
        this.nameText.setText(defaultName);
        this.argsText.setText(defaultArgs);
        this.handlesExecutionOption.setSelection(defaulthandlesExecutionOption);
        this.handlesFilesAsArguments.setSelection(defaultHandlesFilesAsArguments);
        this.installedEEsComboViewer.setSelection((ISelection)new StructuredSelection((Object)defaultee));
    }

    private void updateWidgetState() {
        IInterpreterInstallType selectedType = this.getSelectedInterpreterType();
        boolean isEmbedded = false;
        if (selectedType instanceof ILuaInterpreterInstallType) {
            ILuaInterpreterInstallType selectedLuaInterpreterType = (ILuaInterpreterInstallType)selectedType;
            this.argsText.setEnabled(selectedLuaInterpreterType.handleInterpreterArguments());
            this.handlesExecutionOption.setEnabled(false);
            this.handlesFilesAsArguments.setEnabled(false);
            isEmbedded = selectedLuaInterpreterType.isEmbeddedInterpreter();
        } else {
            this.argsText.setEnabled(true);
            this.handlesExecutionOption.setEnabled(true);
            this.handlesFilesAsArguments.setEnabled(true);
            isEmbedded = selectedType instanceof IEmbeddedInterpreterInstallType;
        }
        this.browseButton.setEnabled(!isEmbedded);
        this.pathText.setEnabled(!isEmbedded);
    }

    private IInterpreterInstallType getSelectedInterpreterType() {
        return (IInterpreterInstallType)((IStructuredSelection)this.typesCombo.getSelection()).getFirstElement();
    }

    private void browseForInstallation() {
        IEnvironmentUI environmentUI = (IEnvironmentUI)this.environment.getAdapter(IEnvironmentUI.class);
        if (environmentUI != null) {
            String defaultPath = this.currentInterperter != null ? this.currentInterperter.getInstallLocation().toOSString() : null;
            String newPath = environmentUI.selectFile(this.getShell(), 1, defaultPath);
            if (newPath != null) {
                this.pathText.setText(newPath);
            }
        }
    }

    protected void okPressed() {
        if (this.currentInterperter == null) {
            IInterpreterInstallType selectedType = this.getSelectedInterpreterType();
            this.currentInterperter = new InterpreterStandin(selectedType, this.createUniqueId(selectedType));
            this.setFieldValuesToInterpreter();
            this.requestor.interpreterAdded(this.currentInterperter);
        } else {
            this.setFieldValuesToInterpreter();
        }
        super.okPressed();
    }

    private String createUniqueId(IInterpreterInstallType interpreterType) {
        String id = null;
        while (interpreterType.findInterpreterInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    protected void setFieldValuesToInterpreter() {
        Object firstElement;
        this.currentInterperter.setInstallLocation((IFileHandle)new LazyFileHandle(this.environment.getId(), (IPath)new Path(this.pathText.getText().trim())));
        this.currentInterperter.setName(this.nameText.getText().trim());
        String argString = this.argsText.getText().trim();
        if (argString != null && argString.length() > 0) {
            this.currentInterperter.setInterpreterArgs(argString);
        } else {
            this.currentInterperter.setInterpreterArgs(null);
        }
        boolean executionOptionChecked = this.handlesExecutionOption != null && this.handlesExecutionOption.getSelection();
        boolean filesAsArgumentOptionChecked = this.handlesFilesAsArguments != null && this.handlesFilesAsArguments.getSelection();
        ISelection selection = this.installedEEsComboViewer.getSelection();
        String eeName = null;
        String eeVersion = null;
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof LuaExecutionEnvironment) {
            eeName = ((LuaExecutionEnvironment)firstElement).getID();
            eeVersion = ((LuaExecutionEnvironment)firstElement).getVersion();
        }
        InterpreterFactory factory = InterpreterFactoryImpl.eINSTANCE;
        Info info = factory.createInfo();
        info.setExecuteOptionCapable(executionOptionChecked);
        info.setFileAsArgumentsCapable(filesAsArgumentOptionChecked);
        info.setLinkedExecutionEnvironmentName(eeName);
        info.setLinkedExecutionEnvironmentVersion(eeVersion);
        this.currentInterperter.replaceExtension(InterpreterPackageImpl.eINSTANCE.getInfo(), (EObject)info);
        this.environementVariableBlock.performApply(this.currentInterperter);
    }

    public boolean execute() {
        return this.open() == 0;
    }

    public void updateStatusLine() {
        String path = this.pathText.getText().trim();
        if (path.isEmpty()) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.ldt.debug.ui", InterpretersMessages.addInterpreterDialog_enterLocation));
        } else {
            String name = this.nameText.getText().trim();
            if (name.isEmpty()) {
                this.updateStatus((IStatus)new Status(4, "org.eclipse.ldt.debug.ui", InterpretersMessages.addInterpreterDialog_enterName));
            } else if (this.requestor.isDuplicateName(name, this.currentInterperter)) {
                this.updateStatus((IStatus)new Status(4, "org.eclipse.ldt.debug.ui", InterpretersMessages.addInterpreterDialog_duplicateName));
            } else {
                this.updateStatus(Status.OK_STATUS);
            }
        }
    }

    public void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }

    private class AddInterpreterDialogAdapter
    extends AddScriptInterpreterDialog {
        public AddInterpreterDialogAdapter(IAddInterpreterDialogRequestor requestor, Shell shell, IInterpreterInstallType[] interpreterInstallTypes, IInterpreterInstall editedInterpreter) {
            super(requestor, shell, interpreterInstallTypes, editedInterpreter);
        }

        protected AbstractInterpreterLibraryBlock createLibraryBlock(AddScriptInterpreterDialog dialog) {
            return null;
        }

        public IEnvironment getEnvironment() {
            return AddLuaInterpreterDialog.this.environment;
        }

        public void updateLibraries(EnvironmentVariable[] newVars, EnvironmentVariable[] oldVars) {
        }

        protected void updateValidateInterpreterLocation() {
        }

        public Shell getShell() {
            return AddLuaInterpreterDialog.this.getShell();
        }

        public void updateStatusLine() {
            AddLuaInterpreterDialog.this.updateStatusLine();
        }

        public void setSystemLibraryStatus(IStatus status) {
        }

        public void setButtonLayoutData(Button button) {
            AddLuaInterpreterDialog.this.setButtonLayoutData(button);
        }

        public int open() {
            return 0;
        }
    }
}

