/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.model;

import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSession;

public class OpModelEvent {
    private String eventName;
    private String printTabs = "";
    private OpModelImage image;
    private OpModelSession parentSession;

    public OpModelEvent(OpModelSession parentSession, String name) {
        this.parentSession = parentSession;
        this.eventName = name;
    }

    public String getName() {
        return this.eventName;
    }

    public OpModelSession getSession() {
        return this.parentSession;
    }

    public void refreshModel() {
        this.image = this.getNewImage();
    }

    public OpModelImage getImage() {
        return this.image;
    }

    protected OpModelImage getNewImage() {
        return Oprofile.getModelData(this.eventName, this.parentSession.getName());
    }

    public int getCount() {
        if (this.image == null) {
            return 0;
        }
        return this.image.getCount();
    }

    public String toString(String tabs) {
        this.printTabs = tabs;
        String s = this.toString();
        this.printTabs = "";
        return s;
    }

    public String toString() {
        String s = String.valueOf(this.eventName) + "\n";
        if (this.image != null) {
            s = String.valueOf(s) + this.printTabs + "Image: ";
            s = String.valueOf(s) + this.image.toString(String.valueOf(this.printTabs) + "\t");
        }
        return s;
    }
}

