/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.IRWOLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RWOLockManager<OBJECT, CONTEXT>
extends Lifecycle
implements IRWOLockManager<OBJECT, CONTEXT> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_CONCURRENCY, RWOLockManager.class);
    private static final ThreadLocal<Boolean> UNLOCK_ALL = new ThreadLocal();
    private final List<LockState<OBJECT, CONTEXT>> EMPTY_RESULT = Collections.emptyList();
    private final Map<OBJECT, LockState<OBJECT, CONTEXT>> objectToLockStateMap = this.createObjectToLocksMap();
    private final Map<CONTEXT, Set<LockState<OBJECT, CONTEXT>>> contextToLockStates = this.createContextToLocksMap();

    @Override
    public void lock(IRWLockManager.LockType type, CONTEXT context, Collection<? extends OBJECT> objectsToLock, long timeout) throws InterruptedException {
        this.lock2(type, context, objectsToLock, timeout);
    }

    @Override
    public List<LockState<OBJECT, CONTEXT>> lock2(IRWLockManager.LockType type, CONTEXT context, Collection<? extends OBJECT> objectsToLock, long timeout) throws InterruptedException {
        if (objectsToLock.isEmpty()) {
            return this.EMPTY_RESULT;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Lock: {0} --> {1}", context, objectsToLock);
        }
        long startTime = timeout == 0L ? 0L : this.currentTimeMillis();
        RWOLockManager rWOLockManager = this;
        synchronized (rWOLockManager) {
            int count = objectsToLock.size();
            while (true) {
                ArrayList<LockState<OBJECT, CONTEXT>> lockStates;
                if ((lockStates = this.getLockStatesForContext(type, context, objectsToLock)) != null) {
                    int i = 0;
                    while (i < count) {
                        LockState<OBJECT, CONTEXT> lockState = lockStates.get(i);
                        lockState.lock(type, context);
                        this.addContextToLockStateMapping(context, lockState);
                        ++i;
                    }
                    return lockStates;
                }
                this.wait(startTime, timeout);
            }
        }
    }

    @Override
    public void lock(IRWLockManager.LockType type, CONTEXT context, OBJECT objectToLock, long timeout) throws InterruptedException {
        this.lock(type, context, (OBJECT)Collections.singleton(objectToLock), timeout);
    }

    @Override
    public void unlock(IRWLockManager.LockType type, CONTEXT context, Collection<? extends OBJECT> objectsToUnlock) {
        this.unlock2(type, context, objectsToUnlock);
    }

    @Override
    public synchronized List<LockState<OBJECT, CONTEXT>> unlock2(CONTEXT context, Collection<? extends OBJECT> objectsToUnlock) {
        return this.unlock2(IRWLockManager.LockType.values(), context, objectsToUnlock);
    }

    @Override
    public synchronized List<LockState<OBJECT, CONTEXT>> unlock2(IRWLockManager.LockType type, CONTEXT context, Collection<? extends OBJECT> objectsToUnlock) {
        return this.unlock2(new IRWLockManager.LockType[]{type}, context, objectsToUnlock);
    }

    private List<LockState<OBJECT, CONTEXT>> unlock2(IRWLockManager.LockType[] types, CONTEXT context, Collection<? extends OBJECT> objectsToUnlock) {
        if (objectsToUnlock.isEmpty()) {
            return this.EMPTY_RESULT;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Unlock: {0} --> {1}", context, objectsToUnlock);
        }
        HashSet<LockState<OBJECT, CONTEXT>> result = new HashSet<LockState<OBJECT, CONTEXT>>();
        for (OBJECT OBJECT : objectsToUnlock) {
            LockState<OBJECT, CONTEXT> lockState = this.objectToLockStateMap.get(OBJECT);
            if (lockState == null) continue;
            IRWLockManager.LockType[] lockTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IRWLockManager.LockType type = lockTypeArray[n2];
                while (lockState.canUnlock(type, context)) {
                    lockState.unlock(type, context);
                    result.add(lockState);
                    if (UNLOCK_ALL.get() != Boolean.TRUE) break;
                }
                ++n2;
            }
        }
        for (LockState lockState : result) {
            if (!lockState.hasLocks(context)) {
                this.removeLockStateForContext(context, lockState);
            }
            if (!lockState.hasNoLocks()) continue;
            this.objectToLockStateMap.remove(lockState.getLockedObject());
        }
        this.notifyAll();
        return new LinkedList<LockState<OBJECT, CONTEXT>>(result);
    }

    @Override
    public synchronized void unlock(CONTEXT context) {
        this.unlock2(context);
    }

    @Override
    public synchronized List<LockState<OBJECT, CONTEXT>> unlock2(CONTEXT context) {
        Set<LockState<OBJECT, CONTEXT>> lockStates = this.contextToLockStates.get(context);
        if (lockStates == null) {
            return this.EMPTY_RESULT;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Unlock: {0} --> {1}", context, lockStates);
        }
        LinkedList<OBJECT> objectsWithoutLocks = new LinkedList<OBJECT>();
        for (LockState<OBJECT, CONTEXT> lockState : lockStates) {
            IRWLockManager.LockType[] lockTypeArray = IRWLockManager.LockType.values();
            int n = lockTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRWLockManager.LockType type = lockTypeArray[n2];
                while (lockState.hasLock(type, context, false)) {
                    lockState.unlock(type, context);
                }
                ++n2;
            }
            if (!lockState.hasNoLocks()) continue;
            OBJECT o = lockState.getLockedObject();
            objectsWithoutLocks.add(o);
        }
        this.contextToLockStates.remove(context);
        for (Object o : objectsWithoutLocks) {
            this.objectToLockStateMap.remove(o);
        }
        this.notifyAll();
        return this.toList(lockStates);
    }

    private List<LockState<OBJECT, CONTEXT>> toList(Set<LockState<OBJECT, CONTEXT>> lockStates) {
        if (lockStates instanceof List) {
            return (List)((Object)lockStates);
        }
        LinkedList<LockState<OBJECT, CONTEXT>> list = new LinkedList<LockState<OBJECT, CONTEXT>>();
        for (LockState<OBJECT, CONTEXT> lockState : lockStates) {
            list.add(lockState);
        }
        return list;
    }

    @Override
    public synchronized boolean hasLock(IRWLockManager.LockType type, CONTEXT context, OBJECT objectToLock) {
        LockState<OBJECT, CONTEXT> lockState = this.objectToLockStateMap.get(objectToLock);
        return lockState != null && lockState.hasLock(type, context, false);
    }

    @Override
    public synchronized boolean hasLockByOthers(IRWLockManager.LockType type, CONTEXT context, OBJECT objectToLock) {
        LockState<OBJECT, CONTEXT> lockState = this.objectToLockStateMap.get(objectToLock);
        return lockState != null && lockState.hasLock(type, context, true);
    }

    protected synchronized void changeContext(CONTEXT oldContext, CONTEXT newContext) {
        for (LockState<OBJECT, CONTEXT> lockState : this.objectToLockStateMap.values()) {
            lockState.replaceContext(oldContext, newContext);
        }
        Set<LockState<OBJECT, CONTEXT>> lockStates = this.contextToLockStates.remove(oldContext);
        if (lockStates != null) {
            this.contextToLockStates.put(newContext, lockStates);
        }
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected Map<OBJECT, LockState<OBJECT, CONTEXT>> createObjectToLocksMap() {
        return new HashMap();
    }

    protected Map<CONTEXT, Set<LockState<OBJECT, CONTEXT>>> createContextToLocksMap() {
        return new HashMap();
    }

    protected final Map<OBJECT, LockState<OBJECT, CONTEXT>> getObjectToLocksMap() {
        return this.objectToLockStateMap;
    }

    protected final Map<CONTEXT, Set<LockState<OBJECT, CONTEXT>>> getContextToLocksMap() {
        return this.contextToLockStates;
    }

    public LockState<OBJECT, CONTEXT> getLockState(OBJECT key) {
        return this.objectToLockStateMap.get(key);
    }

    public synchronized List<LockState<OBJECT, CONTEXT>> getLockStates() {
        return new ArrayList<LockState<OBJECT, CONTEXT>>(this.objectToLockStateMap.values());
    }

    public synchronized void setLockState(OBJECT key, LockState<OBJECT, CONTEXT> lockState) {
        CONTEXT writeOptionOwner;
        this.objectToLockStateMap.put(key, lockState);
        for (CONTEXT readLockOwner : lockState.getReadLockOwners()) {
            this.addContextToLockStateMapping(readLockOwner, lockState);
        }
        CONTEXT writeLockOwner = lockState.getWriteLockOwner();
        if (writeLockOwner != null) {
            this.addContextToLockStateMapping(writeLockOwner, lockState);
        }
        if ((writeOptionOwner = lockState.getWriteOptionOwner()) != null) {
            this.addContextToLockStateMapping(writeOptionOwner, lockState);
        }
    }

    private LockState<OBJECT, CONTEXT> getOrCreateLockState(OBJECT o) {
        LockState<OBJECT, CONTEXT> lockState = this.objectToLockStateMap.get(o);
        if (lockState == null) {
            lockState = new LockState(o);
            this.objectToLockStateMap.put(o, lockState);
        }
        return lockState;
    }

    private ArrayList<LockState<OBJECT, CONTEXT>> getLockStatesForContext(IRWLockManager.LockType type, CONTEXT context, Collection<? extends OBJECT> objectsToLock) {
        ArrayList<LockState<OBJECT, CONTEXT>> lockStates = new ArrayList<LockState<OBJECT, CONTEXT>>(objectsToLock.size());
        Iterator<OBJECT> it = objectsToLock.iterator();
        int i = 0;
        while (i < objectsToLock.size()) {
            OBJECT o = it.next();
            LockState<OBJECT, CONTEXT> lockState = this.getOrCreateLockState(o);
            if (!lockState.canLock(type, context)) {
                return null;
            }
            lockStates.add(lockState);
            ++i;
        }
        return lockStates;
    }

    private void addContextToLockStateMapping(CONTEXT context, LockState<OBJECT, CONTEXT> lockState) {
        Set<LockState<OBJECT, CONTEXT>> lockStates = this.contextToLockStates.get(context);
        if (lockStates == null) {
            lockStates = new HashSet<LockState<OBJECT, CONTEXT>>();
            this.contextToLockStates.put(context, lockStates);
        }
        lockStates.add(lockState);
    }

    private void removeLockStateForContext(CONTEXT context, LockState<OBJECT, CONTEXT> lockState) {
        Set<LockState<OBJECT, CONTEXT>> lockStates = this.contextToLockStates.get(context);
        lockStates.remove(lockState);
        if (lockStates.isEmpty()) {
            this.contextToLockStates.remove(context);
        }
    }

    private void wait(long startTime, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.wait();
        } else {
            long elapsedTime = this.currentTimeMillis() - startTime;
            long waitTime = timeout - elapsedTime;
            if (waitTime < 1L) {
                throw new TimeoutRuntimeException("Could not lock objects within " + timeout + " milli seconds");
            }
            this.wait(waitTime);
        }
    }

    public static void setUnlockAll(boolean on) {
        if (on) {
            UNLOCK_ALL.set(Boolean.TRUE);
        } else {
            UNLOCK_ALL.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LockState<OBJECT, CONTEXT> {
        private final OBJECT lockedObject;
        private final HashBag<CONTEXT> readLockOwners = new HashBag();
        private CONTEXT writeLockOwner;
        private CONTEXT writeOptionOwner;
        private int writeLockCounter;

        LockState(OBJECT lockedObject) {
            CheckUtil.checkArg(lockedObject, "lockedObject");
            this.lockedObject = lockedObject;
        }

        public OBJECT getLockedObject() {
            return this.lockedObject;
        }

        public boolean hasLock(IRWLockManager.LockType type, CONTEXT view, boolean byOthers) {
            CheckUtil.checkArg(view, "view");
            switch (type) {
                case READ: {
                    if (byOthers) {
                        return this.readLockOwners.size() > 1 || this.readLockOwners.size() == 1 && !this.readLockOwners.contains(view);
                    }
                    return this.readLockOwners.contains(view);
                }
                case WRITE: {
                    if (byOthers) {
                        return this.writeLockOwner != null && this.writeLockOwner != view;
                    }
                    return this.writeLockOwner == view;
                }
                case OPTION: {
                    if (byOthers) {
                        return this.writeOptionOwner != null && this.writeOptionOwner != view;
                    }
                    return this.writeOptionOwner == view;
                }
            }
            return false;
        }

        public boolean hasLock(IRWLockManager.LockType type) {
            switch (type) {
                case READ: {
                    return this.readLockOwners.size() > 0;
                }
                case WRITE: {
                    return this.writeLockOwner != null;
                }
                case OPTION: {
                    return this.writeOptionOwner != null;
                }
            }
            return false;
        }

        public Set<CONTEXT> getReadLockOwners() {
            return Collections.unmodifiableSet(this.readLockOwners);
        }

        public CONTEXT getWriteLockOwner() {
            return this.writeLockOwner;
        }

        public CONTEXT getWriteOptionOwner() {
            return this.writeOptionOwner;
        }

        public int hashCode() {
            return this.lockedObject.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LockState)) {
                return false;
            }
            LockState other = (LockState)obj;
            return this.lockedObject.equals(other.lockedObject);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LockState[target=");
            builder.append(this.lockedObject);
            if (this.readLockOwners.size() > 0) {
                builder.append(", read=");
                boolean first = true;
                for (CONTEXT view : this.readLockOwners) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(view);
                }
                builder.deleteCharAt(builder.length() - 1);
            }
            if (this.writeLockOwner != null) {
                builder.append(", write=");
                builder.append(this.writeLockOwner);
            }
            if (this.writeOptionOwner != null) {
                builder.append(", option=");
                builder.append(this.writeOptionOwner);
            }
            builder.append(']');
            return builder.toString();
        }

        void lock(IRWLockManager.LockType type, CONTEXT context) {
            CheckUtil.checkArg(context, "context");
            switch (type) {
                case READ: {
                    this.doReadLock(context);
                    return;
                }
                case WRITE: {
                    this.doWriteLock(context);
                    return;
                }
                case OPTION: {
                    this.doWriteOption(context);
                    return;
                }
            }
            throw new AssertionError((Object)("Unknown lock type " + (Object)((Object)type)));
        }

        boolean canLock(IRWLockManager.LockType type, CONTEXT context) {
            CheckUtil.checkArg(context, "context");
            switch (type) {
                case READ: {
                    return this.canReadLock(context);
                }
                case WRITE: {
                    return this.canWriteLock(context);
                }
                case OPTION: {
                    return this.canWriteOption(context);
                }
            }
            throw new AssertionError((Object)("Unknown lock type " + (Object)((Object)type)));
        }

        boolean canUnlock(IRWLockManager.LockType type, CONTEXT context) {
            CheckUtil.checkArg(context, "context");
            switch (type) {
                case READ: {
                    return this.canReadUnlock(context);
                }
                case WRITE: {
                    return this.canWriteUnlock(context);
                }
                case OPTION: {
                    return this.canWriteUnoption(context);
                }
            }
            throw new AssertionError((Object)("Unknown lock type " + (Object)((Object)type)));
        }

        void unlock(IRWLockManager.LockType type, CONTEXT context) {
            CheckUtil.checkArg(context, "context");
            switch (type) {
                case READ: {
                    this.doReadUnlock(context);
                    return;
                }
                case WRITE: {
                    this.doWriteUnlock(context);
                    return;
                }
                case OPTION: {
                    this.doWriteUnoption(context);
                    return;
                }
            }
            throw new AssertionError((Object)("Unknown lock type " + (Object)((Object)type)));
        }

        void replaceContext(CONTEXT oldContext, CONTEXT newContext) {
            int readLocksOwnedByOldView = this.readLockOwners.getCounterFor(oldContext);
            if (readLocksOwnedByOldView > 0) {
                int i = 0;
                while (i < readLocksOwnedByOldView) {
                    this.readLockOwners.remove(oldContext);
                    this.readLockOwners.add(newContext);
                    ++i;
                }
            }
            if (ObjectUtil.equals(this.writeLockOwner, oldContext)) {
                this.writeLockOwner = newContext;
            }
            if (ObjectUtil.equals(this.writeOptionOwner, oldContext)) {
                this.writeOptionOwner = newContext;
            }
        }

        boolean hasNoLocks() {
            return this.readLockOwners.isEmpty() && this.writeLockOwner == null && this.writeOptionOwner == null;
        }

        boolean hasLocks(CONTEXT context) {
            return this.readLockOwners.contains(context) || this.writeLockOwner == context || this.writeOptionOwner == context;
        }

        private boolean canReadLock(CONTEXT context) {
            return this.writeLockOwner == null || this.writeLockOwner == context;
        }

        private void doReadLock(CONTEXT context) {
            this.readLockOwners.add(context);
        }

        private boolean canWriteLock(CONTEXT context) {
            if (this.writeLockOwner != null && this.writeLockOwner != context) {
                return false;
            }
            if (this.writeOptionOwner != null && this.writeOptionOwner != context) {
                return false;
            }
            if (this.readLockOwners.size() > 1) {
                return false;
            }
            return this.readLockOwners.size() != 1 || this.readLockOwners.contains(context);
        }

        private void doWriteLock(CONTEXT context) {
            this.writeLockOwner = context;
            ++this.writeLockCounter;
        }

        private boolean canWriteOption(CONTEXT context) {
            if (this.writeOptionOwner != null && this.writeOptionOwner != context) {
                return false;
            }
            return this.writeLockOwner == null || this.writeLockOwner == context;
        }

        private void doWriteOption(CONTEXT context) {
            this.writeOptionOwner = context;
        }

        private boolean canReadUnlock(CONTEXT context) {
            return this.readLockOwners.contains(context);
        }

        private void doReadUnlock(CONTEXT context) {
            this.readLockOwners.remove(context);
        }

        private boolean canWriteUnlock(CONTEXT context) {
            return this.writeLockOwner == context;
        }

        private void doWriteUnlock(CONTEXT context) {
            --this.writeLockCounter;
            if (this.writeLockCounter == 0) {
                this.writeLockOwner = null;
            }
        }

        private boolean canWriteUnoption(CONTEXT context) {
            return this.writeOptionOwner == context;
        }

        private void doWriteUnoption(CONTEXT context) {
            this.writeOptionOwner = null;
        }
    }
}

