/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IAbstractPanelModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashPanelModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ITabFolderModel;
import org.eclipse.papyrus.infra.core.sasheditor.internal.AbstractPanelPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.AbstractPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IPanelParent;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IPartVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.NotFoundException;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PartLists;
import org.eclipse.papyrus.infra.core.sasheditor.internal.SashPanelPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.SashWindowsContainer;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabFolderPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class RootPart
extends AbstractPart
implements IPanelParent {
    private Composite container;
    private AbstractPanelPart child;

    public RootPart(SashWindowsContainer sashWindowsContainer) {
        super(sashWindowsContainer);
    }

    public void createPartControl(Composite parent) {
        this.container = parent;
    }

    public void disposeThisAndChildren() {
        if (this.child != null) {
            this.child.disposeThisAndChildren();
        }
        this.child = null;
    }

    @Override
    public Composite getControl() {
        return this.container;
    }

    private AbstractPanelPart createChildPart(Object rawModel) {
        AbstractPanelPart createdPart;
        IAbstractPanelModel model = this.getPartModel().createChildSashModel(rawModel);
        if (model instanceof ITabFolderModel) {
            createdPart = new TabFolderPart(this, (ITabFolderModel)model, rawModel);
        } else if (model instanceof ISashPanelModel) {
            createdPart = new SashPanelPart(this, (ISashPanelModel)model, rawModel);
        } else {
            throw new IllegalArgumentException("Can't create child part for model of type '" + model.getClass().getName() + "'");
        }
        ((AbstractPanelPart)createdPart).createPartControl(this.getControl());
        return createdPart;
    }

    private ISashWindowsContentProvider getPartModel() {
        return this.getSashWindowContainer().getContentProvider();
    }

    public void synchronize2(PartLists partMap) {
        this.synchronizeChild(partMap);
        if (this.child != null) {
            this.child.synchronize2(partMap);
        }
    }

    private void synchronizeChild(PartLists partMap) {
        AbstractPanelPart newPart;
        Object rawModel = this.getContentProvider().getRootModel();
        if (this.child != null) {
            if (this.child.isPartFor(rawModel)) {
                this.child.unchanged();
                return;
            }
            this.child.orphan();
        }
        if ((newPart = partMap.findPartFor(rawModel)) != null) {
            newPart.reparent(this, this.getControl());
        } else {
            newPart = this.createChildPart(rawModel);
        }
        this.setChild(newPart);
    }

    private void setChild(AbstractPanelPart newTile) {
        this.child = newTile;
    }

    public void fillPartMap(PartLists partMap) {
        if (this.child != null) {
            this.child.fillPartMap(partMap);
        }
    }

    public AbstractPart findPart(Point toFind) {
        if (this.child != null) {
            try {
                return this.child.findPart(toFind);
            }
            catch (NotFoundException e) {
                System.err.println(e.getMessage());
                return null;
            }
        }
        return null;
    }

    public AbstractPart findPart(Object control) {
        if (this.child != null) {
            return this.child.findPart(control);
        }
        return null;
    }

    public void orphan() {
    }

    @Override
    public boolean isOrphaned() {
        return false;
    }

    @Override
    public AbstractPart.GarbageState getGarbageState() {
        return AbstractPart.GarbageState.UNVISITED;
    }

    public boolean visit(IPartVisitor visitor) {
        return visitor.accept(this);
    }

    public boolean visitChildren(IPartVisitor visitor) {
        if (this.child != null) {
            return this.child.visit(visitor);
        }
        return true;
    }

    protected void showStatus() {
        Activator.log.debug("rootPart (1), disposed=" + this.container.isDisposed() + ", visible=" + this.container.isVisible() + ", " + this);
    }
}

