/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.PageStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.PageStyleImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.ForceValueHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.style.CSSPageStyle;
import org.eclipse.papyrus.infra.gmfdiag.css.style.impl.CSSPageStyleDelegate;

public class CSSPageStyleImpl
extends PageStyleImpl
implements CSSPageStyle {
    protected ExtendedCSSEngine engine;
    private CSSPageStyle pageStyle;

    protected CSSPageStyle getPageStyle() {
        if (this.pageStyle == null) {
            this.pageStyle = new CSSPageStyleDelegate((PageStyle)this, this.getEngine());
        }
        return this.pageStyle;
    }

    protected ExtendedCSSEngine getEngine() {
        if (this.engine == null) {
            this.engine = ((CSSDiagram)this.findView().getDiagram()).getEngine();
        }
        return this.engine;
    }

    protected View findView() {
        EObject parent = this.eContainer();
        while (!(parent instanceof View) && parent != null) {
            parent = parent.eContainer();
        }
        if (parent != null) {
            return (View)parent;
        }
        return null;
    }

    @Override
    public int getCSSPageX() {
        int value = super.getPageX();
        if (ForceValueHelper.isSet(this.findView(), (EObject)this, (EStructuralFeature)NotationPackage.eINSTANCE.getPageStyle_PageX(), value)) {
            return value;
        }
        return this.getPageStyle().getCSSPageX();
    }

    @Override
    public int getCSSPageY() {
        int value = super.getPageY();
        if (ForceValueHelper.isSet(this.findView(), (EObject)this, (EStructuralFeature)NotationPackage.eINSTANCE.getPageStyle_PageY(), value)) {
            return value;
        }
        return this.getPageStyle().getCSSPageY();
    }

    @Override
    public int getCSSPageWidth() {
        int value = super.getPageWidth();
        if (ForceValueHelper.isSet(this.findView(), (EObject)this, (EStructuralFeature)NotationPackage.eINSTANCE.getPageStyle_PageWidth(), value)) {
            return value;
        }
        return this.getPageStyle().getCSSPageWidth();
    }

    @Override
    public int getCSSPageHeight() {
        int value = super.getPageHeight();
        if (ForceValueHelper.isSet(this.findView(), (EObject)this, (EStructuralFeature)NotationPackage.eINSTANCE.getPageStyle_PageHeight(), value)) {
            return value;
        }
        return this.getPageStyle().getCSSPageHeight();
    }

    public int getPageX() {
        return this.getCSSPageX();
    }

    public int getPageY() {
        return this.getCSSPageY();
    }

    public int getPageWidth() {
        return this.getCSSPageWidth();
    }

    public int getPageHeight() {
        return this.getCSSPageHeight();
    }

    public void setPageX(int value) {
        super.setPageX(value);
        EAttribute feature = NotationPackage.eINSTANCE.getPageStyle_PageX();
        ForceValueHelper.setValue(this.findView(), (EStructuralFeature)feature, value);
    }

    public void setPageY(int value) {
        super.setPageY(value);
        EAttribute feature = NotationPackage.eINSTANCE.getPageStyle_PageY();
        ForceValueHelper.setValue(this.findView(), (EStructuralFeature)feature, value);
    }

    public void setPageWidth(int value) {
        super.setPageWidth(value);
        EAttribute feature = NotationPackage.eINSTANCE.getPageStyle_PageWidth();
        ForceValueHelper.setValue(this.findView(), (EStructuralFeature)feature, value);
    }

    public void setPageHeight(int value) {
        super.setPageHeight(value);
        EAttribute feature = NotationPackage.eINSTANCE.getPageStyle_PageHeight();
        ForceValueHelper.setValue(this.findView(), (EStructuralFeature)feature, value);
    }

    public void eUnset(int featureId) {
        super.eUnset(featureId);
        EStructuralFeature feature = this.eClass().getEStructuralFeature(featureId);
        ForceValueHelper.unsetValue(this.findView(), feature);
    }
}

