/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.view.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.util.HandleFactory;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.phpunit.ui.view.PHPUnitView;
import org.eclipse.php.phpunit.ui.view.actions.OpenEditorAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenEditorAtLineAction
extends OpenEditorAction {
    private String fMethodName;

    public OpenEditorAtLineAction(String label, PHPUnitView testRunner, String fileName, int lineNumber, String methodName) {
        super(label, testRunner, null, fileName, lineNumber);
        this.fMethodName = methodName;
    }

    @Override
    protected IModelElement findElement(IProject project, String elementName, String fileName) {
        IFileHandle file;
        IType element = null;
        if (elementName != null) {
            element = this.findClass(project, elementName, fileName);
            return element;
        }
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        IFile iFile = root.getFile((IPath)new Path(fileName));
        if (iFile == null || !iFile.exists()) {
            iFile = root.getFileForLocation((IPath)new Path(fileName));
        }
        if (iFile != null && iFile.exists()) {
            element = DLTKCore.create((IFile)iFile);
        }
        if (element == null && (file = EnvironmentPathUtils.getFile((IEnvironment)LocalEnvironment.getInstance(), (IPath)new Path(fileName))) != null) {
            IPath fullPath = file.getFullPath();
            HandleFactory fac = new HandleFactory();
            IDLTKSearchScope scope = DLTKSearchScopeFactory.getInstance().createWorkspaceScope(true, PHPLanguageToolkit.getDefault());
            element = fac.createOpenable(fullPath.toString(), scope);
        }
        return element;
    }

    public boolean isEnabled() {
        if (this.fFileName == null || this.fFileName.isEmpty()) {
            return false;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.fFileName));
        return file != null;
    }

    @Override
    protected void reveal(ITextEditor textEditor) {
        if (this.fLineNumber >= 0) {
            try {
                int methodPosition;
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                int startPosition = document.getLineOffset(this.fLineNumber - 1);
                int length = document.getLineLength(this.fLineNumber - 1);
                String line = document.get(startPosition, length);
                if (this.fMethodName != null && (methodPosition = line.indexOf(this.fMethodName)) == line.lastIndexOf(this.fMethodName) && methodPosition >= 0) {
                    startPosition += methodPosition;
                    length = this.fMethodName.length();
                } else {
                    String trimmedLine = line.trim();
                    startPosition += line.indexOf(trimmedLine);
                    length = trimmedLine.length();
                }
                textEditor.selectAndReveal(startPosition, length);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

