/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui;

import java.util.Hashtable;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.ui.PTPUIPlugin;
import org.osgi.framework.BundleContext;

public class PTPUIDebugOptions
implements DebugOptionsListener {
    public static final String DEBUG_JOB_TRACING = "/debug/views/jobs/tracing";
    private static DebugTrace fDebugTrace;
    private static DebugOptions fDebugOptions;
    private static PTPUIDebugOptions fUIDebugOptions;

    public static void configure(BundleContext context) {
        if (fUIDebugOptions == null) {
            fUIDebugOptions = new PTPUIDebugOptions(context);
        }
    }

    private PTPUIDebugOptions(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", PTPUIPlugin.getUniqueIdentifier());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
    }

    public void optionsChanged(DebugOptions options) {
        fDebugOptions = options;
        fDebugTrace = options.newDebugTrace(PTPUIPlugin.getUniqueIdentifier());
    }

    public static boolean isDebugging() {
        return PTPUIPlugin.getDefault().isDebugging();
    }

    public static boolean isDebugging(String option) {
        if (fDebugOptions == null) {
            return false;
        }
        return fDebugOptions.getBooleanOption(String.valueOf(PTPUIPlugin.getUniqueIdentifier()) + option, false);
    }

    public static void setDebugging(String option, boolean value) {
        if (fDebugOptions != null) {
            if (value) {
                fDebugOptions.setDebugEnabled(true);
            }
            fDebugOptions.setOption(option, Boolean.toString(value));
        }
    }

    public static void trace(String message) {
        PTPUIDebugOptions.trace(null, message, new String[0]);
    }

    public static void trace(String option, String message, String ... arguments) {
        String traceMsg = message;
        if (arguments.length > 0) {
            traceMsg = NLS.bind((String)message, (Object[])arguments);
        }
        if (option != null && PTPUIDebugOptions.isDebugging(option) || PTPUIDebugOptions.isDebugging()) {
            System.out.println(traceMsg);
            if (fDebugTrace != null) {
                fDebugTrace.trace(option, traceMsg, null);
            }
        }
    }
}

