/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.model.INlsProjectProvider;
import org.eclipse.scout.sdk.s2e.nls.model.INlsWorkspace;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;

public final class NlsWorkspace
implements INlsWorkspace {
    private volatile Collection<INlsProjectProvider> m_providers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<INlsProjectProvider> getProviders() {
        Collection<INlsProjectProvider> providers = this.m_providers;
        if (providers != null) {
            return providers;
        }
        NlsWorkspace nlsWorkspace = this;
        synchronized (nlsWorkspace) {
            providers = this.m_providers;
            if (providers != null) {
                return providers;
            }
            providers = new ArrayList<INlsProjectProvider>(2);
            IExtensionPoint xp = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.scout.sdk.s2e.nls", "nlsProvider");
            IExtension[] iExtensionArray = xp.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("provider".equals(element.getName())) {
                        try {
                            INlsProjectProvider p = (INlsProjectProvider)element.createExecutableExtension("class");
                            if (p != null) {
                                providers.add(p);
                            }
                        }
                        catch (CoreException e) {
                            SdkLog.error((String)"Unable to create extension '{}'.", (Object[])new Object[]{element.getNamespaceIdentifier(), e});
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            this.m_providers = providers;
            return providers;
        }
    }

    @Override
    public INlsProject getNlsProject(Object ... args) {
        for (INlsProjectProvider p : this.getProviders()) {
            INlsProject proj = p.getProject(args);
            if (proj == null) continue;
            return proj;
        }
        return null;
    }
}

