/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

class LinkedPositionProposalImpl
implements ICompletionProposalExtension2,
IJavaCompletionProposal {
    private final LinkedProposalPositionGroup.Proposal m_proposal;
    private final LinkedModeModel m_linkedPositionModel;

    LinkedPositionProposalImpl(LinkedProposalPositionGroup.Proposal proposal, LinkedModeModel model) {
        this.m_proposal = proposal;
        this.m_linkedPositionModel = model;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument doc = viewer.getDocument();
        LinkedPosition position = this.m_linkedPositionModel.findPosition(new LinkedPosition(doc, offset, 0));
        if (position == null) {
            return;
        }
        try {
            TextEdit edit = this.m_proposal.computeEdits(offset, position, trigger, stateMask, this.m_linkedPositionModel);
            if (edit != null) {
                edit.apply(position.getDocument(), 0);
            }
        }
        catch (CoreException | BadLocationException | MalformedTreeException e) {
            SdkLog.info((String)"Unable to apply text edit.", (Object[])new Object[]{e});
        }
    }

    public String getDisplayString() {
        return this.m_proposal.getDisplayString();
    }

    public Image getImage() {
        return this.m_proposal.getImage();
    }

    public int getRelevance() {
        return this.m_proposal.getRelevance();
    }

    public void apply(IDocument document) {
    }

    public String getAdditionalProposalInfo() {
        return this.m_proposal.getAdditionalProposalInfo();
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        String insert = this.getDisplayString();
        LinkedPosition pos = this.m_linkedPositionModel.findPosition(new LinkedPosition(document, offset, 0));
        int off = pos != null ? pos.getOffset() : Math.max(0, offset - insert.length());
        int length = offset - off;
        if (offset <= document.getLength()) {
            try {
                String content = document.get(off, length);
                if (insert.startsWith(content)) {
                    return true;
                }
            }
            catch (BadLocationException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        return false;
    }
}

