/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.form;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalListener;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.form.FormNewWizard;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.CompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class FormNewWizardPage
extends CompilationUnitNewWizardPage {
    public static final String PROP_CREATE_FORM_DATA = "createFormData";
    public static final String PROP_CREATE_SERVICE = "createService";
    public static final String PROP_CREATE_PERMISSIONS = "createPermissions";
    public static final String PROP_SHARED_SOURCE_FOLDER = "sharedSourceFolder";
    public static final String PROP_SERVER_SOURCE_FOLDER = "serverSourceFolder";
    public static final String PREF_CREATE_FORM_DATA = "createFormData";
    public static final String PREF_CREATE_SERVICE = "createService";
    public static final String PREF_CREATE_PERMISSIONS = "createPermissions";
    protected Button m_createFormDataButton;
    protected Button m_createServiceButton;
    protected Button m_createPermissionsButton;
    protected ProposalTextField m_sharedSourceFolder;
    protected ProposalTextField m_serverSourceFolder;

    public FormNewWizardPage(PackageContainer packageContainer) {
        super(FormNewWizardPage.class.getName(), packageContainer, "Form", "org.eclipse.scout.rt.client.ui.form.IForm", "org.eclipse.scout.rt.client.ui.form.AbstractForm", ScoutTier.Client);
        this.setTitle("Create a new Form");
        this.setDescription(this.getTitle());
        this.setIcuGroupName("New Form Details");
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.initDefaults();
        this.createFormPropertiesGroup(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_form_page_context");
    }

    protected void initDefaults() {
        IDialogSettings settings = this.getDialogSettings();
        String prefCreateFormData = settings.get("createFormData");
        this.setIsCreateFormDataInternal(StringUtils.isBlank((CharSequence)prefCreateFormData) || Boolean.valueOf(prefCreateFormData) != false);
        String prefCreateService = settings.get("createService");
        this.setIsCreateServiceInternal(StringUtils.isBlank((CharSequence)prefCreateService) || Boolean.valueOf(prefCreateService) != false);
        String prefCreatePermissions = settings.get("createPermissions");
        this.setIsCreatePermissionsInternal(StringUtils.isBlank((CharSequence)prefCreatePermissions) || Boolean.valueOf(prefCreatePermissions) != false);
        this.guessSharedAndServerFolders();
    }

    public FormNewWizard getWizard() {
        return (FormNewWizard)super.getWizard();
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        this.getDialogSettings().put("createFormData", Boolean.toString(this.isCreateFormData()));
        this.getDialogSettings().put("createService", Boolean.toString(this.isCreateService()));
        this.getDialogSettings().put("createPermissions", Boolean.toString(this.isCreatePermissions()));
        return true;
    }

    protected void guessSharedAndServerFolders() {
        IPackageFragmentRoot clientSourceFolder = this.getSourceFolder();
        if (!S2eUtils.exists((IJavaElement)clientSourceFolder)) {
            return;
        }
        try {
            this.setServerSourceFolder(ScoutTier.Client.convert(ScoutTier.Server, clientSourceFolder));
        }
        catch (JavaModelException e) {
            SdkLog.info((String)"Unable to calculate server source folder.", (Object[])new Object[]{e});
        }
        try {
            this.setSharedSourceFolder(ScoutTier.Client.convert(ScoutTier.Shared, clientSourceFolder));
        }
        catch (JavaModelException e) {
            SdkLog.info((String)"Unable to calculate shared source folder.", (Object[])new Object[]{e});
        }
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        super.validatePage(multiStatus);
        multiStatus.add(this.getStatusServerSourceFolder());
        multiStatus.add(this.getStatusSharedSourceFolder());
    }

    protected IStatus getStatusSharedSourceFolder() {
        if (!(this.isCreateFormData() || this.isCreatePermissions() || this.isCreateService())) {
            return Status.OK_STATUS;
        }
        if (!S2eUtils.exists((IJavaElement)this.getSharedSourceFolder())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose a shared source folder.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusServerSourceFolder() {
        if (this.isCreateService() && !S2eUtils.exists((IJavaElement)this.getServerSourceFolder())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose a server source folder.");
        }
        return Status.OK_STATUS;
    }

    @Override
    protected int getLabelWidth() {
        return 130;
    }

    protected void createFormPropertiesGroup(Composite p) {
        Group parent = this.getFieldToolkit().createGroupBox(p, "Additional Components");
        this.m_createFormDataButton = this.getFieldToolkit().createCheckBox((Composite)parent, "Create FormData", this.isCreateFormData());
        this.m_createFormDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormNewWizardPage.this.setIsCreateFormDataInternal(FormNewWizardPage.this.m_createFormDataButton.getSelection());
                FormNewWizardPage.this.handleComponentsChanged();
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_createServiceButton = this.getFieldToolkit().createCheckBox((Composite)parent, "Create Service", this.isCreateService());
        this.m_createServiceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormNewWizardPage.this.setIsCreateServiceInternal(FormNewWizardPage.this.m_createServiceButton.getSelection());
                FormNewWizardPage.this.handleComponentsChanged();
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_createPermissionsButton = this.getFieldToolkit().createCheckBox((Composite)parent, "Create Permissions", this.isCreatePermissions());
        this.m_createPermissionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormNewWizardPage.this.setIsCreatePermissionsInternal(FormNewWizardPage.this.m_createPermissionsButton.getSelection());
                FormNewWizardPage.this.handleComponentsChanged();
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_sharedSourceFolder = this.getFieldToolkit().createSourceFolderField((Composite)parent, "Shared Source Folder", ScoutTier.Shared, this.getLabelWidth());
        this.m_sharedSourceFolder.acceptProposal(this.getSharedSourceFolder());
        this.m_sharedSourceFolder.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                FormNewWizardPage.this.setSharedSourceFolderInternal((IPackageFragmentRoot)proposal);
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_serverSourceFolder = this.getFieldToolkit().createSourceFolderField((Composite)parent, "Server Source Folder", ScoutTier.Server, this.getLabelWidth());
        this.m_serverSourceFolder.acceptProposal(this.getServerSourceFolder());
        this.m_serverSourceFolder.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                FormNewWizardPage.this.setServerSourceFolderInternal((IPackageFragmentRoot)proposal);
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).indent(0, 10).applyTo((Control)parent);
        GridLayoutFactory.swtDefaults().numColumns(3).equalWidth(true).applyTo((Composite)parent);
        GridDataFactory optionsButtonGridDataFactory = GridDataFactory.defaultsFor((Control)parent).indent(10, 8);
        GridDataFactory.defaultsFor((Control)this.m_sharedSourceFolder).align(4, 0x1000000).grab(true, false).span(3, 0).indent(0, 8).applyTo((Control)this.m_sharedSourceFolder);
        GridDataFactory.defaultsFor((Control)this.m_serverSourceFolder).align(4, 0x1000000).grab(true, false).span(3, 0).applyTo((Control)this.m_serverSourceFolder);
        optionsButtonGridDataFactory.applyTo((Control)this.m_createFormDataButton);
        optionsButtonGridDataFactory.applyTo((Control)this.m_createServiceButton);
        optionsButtonGridDataFactory.applyTo((Control)this.m_createPermissionsButton);
        this.handleComponentsChanged();
    }

    @Override
    protected void handleJavaProjectChanged() {
        super.handleJavaProjectChanged();
        this.guessSharedAndServerFolders();
    }

    protected void handleComponentsChanged() {
        this.m_sharedSourceFolder.setEnabled(this.isCreateFormData() || this.isCreatePermissions() || this.isCreateService());
        this.m_serverSourceFolder.setEnabled(this.isCreateService());
    }

    public boolean isCreateFormData() {
        Boolean val = this.getProperty("createFormData", Boolean.class);
        return val != null && val != false;
    }

    public void setIsCreateFormData(boolean createFormData) {
        try {
            this.setStateChanging(true);
            this.setIsCreateFormDataInternal(createFormData);
            if (this.isControlCreated() && this.m_createFormDataButton != null) {
                this.m_createFormDataButton.setSelection(createFormData);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setIsCreateFormDataInternal(boolean createFormData) {
        this.setProperty("createFormData", createFormData);
    }

    public boolean isCreateService() {
        Boolean val = this.getProperty("createService", Boolean.class);
        return val != null && val != false;
    }

    public void setIsCreateService(boolean createService) {
        try {
            this.setStateChanging(true);
            this.setIsCreateServiceInternal(createService);
            if (this.isControlCreated() && this.m_createServiceButton != null) {
                this.m_createServiceButton.setSelection(createService);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setIsCreateServiceInternal(boolean createService) {
        this.setProperty("createService", createService);
    }

    public boolean isCreatePermissions() {
        Boolean val = this.getProperty("createPermissions", Boolean.class);
        return val != null && val != false;
    }

    public void setIsCreatePermissions(boolean createPermissions) {
        try {
            this.setStateChanging(true);
            this.setIsCreatePermissionsInternal(createPermissions);
            if (this.isControlCreated() && this.m_createPermissionsButton != null) {
                this.m_createPermissionsButton.setSelection(createPermissions);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setIsCreatePermissionsInternal(boolean createPermissions) {
        this.setProperty("createPermissions", createPermissions);
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.getProperty(PROP_SHARED_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        try {
            this.setStateChanging(true);
            this.setSharedSourceFolderInternal(sharedSourceFolder);
            if (this.isControlCreated() && this.m_sharedSourceFolder != null) {
                this.m_sharedSourceFolder.acceptProposal(sharedSourceFolder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setSharedSourceFolderInternal(IPackageFragmentRoot sharedSourceFolder) {
        this.setProperty(PROP_SHARED_SOURCE_FOLDER, sharedSourceFolder);
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.getProperty(PROP_SERVER_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        try {
            this.setStateChanging(true);
            this.setServerSourceFolderInternal(serverSourceFolder);
            if (this.isControlCreated() && this.m_serverSourceFolder != null) {
                this.m_serverSourceFolder.acceptProposal(serverSourceFolder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setServerSourceFolderInternal(IPackageFragmentRoot serverSourceFolder) {
        this.setProperty(PROP_SERVER_SOURCE_FOLDER, serverSourceFolder);
    }
}

