/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.security.Key;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class BaseCipher
implements Cipher {
    protected javax.crypto.Cipher cipher;
    private final int ivsize;
    private final int bsize;
    private final String algorithm;
    private final String transformation;
    private String s;

    public BaseCipher(int ivsize, int bsize, String algorithm, String transformation) {
        this.ivsize = ivsize;
        this.bsize = bsize;
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(algorithm, "No algorithm");
        this.transformation = ValidateUtils.checkNotNullAndNotEmpty(transformation, "No transformation");
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getTransformation() {
        return this.transformation;
    }

    @Override
    public int getIVSize() {
        return this.ivsize;
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public void init(Cipher.Mode mode, byte[] key, byte[] iv) throws Exception {
        key = BaseCipher.resize(key, this.getBlockSize());
        iv = BaseCipher.resize(iv, this.getIVSize());
        try {
            this.cipher = SecurityUtils.getCipher(this.getTransformation());
            this.cipher.init(Cipher.Mode.Encrypt.equals((Object)mode) ? 1 : 2, (Key)new SecretKeySpec(key, this.getAlgorithm()), new IvParameterSpec(iv));
        }
        catch (Exception e) {
            this.cipher = null;
            throw new SshException("Unable to initialize cipher " + this, (Throwable)e);
        }
    }

    @Override
    public void update(byte[] input, int inputOffset, int inputLen) throws Exception {
        this.cipher.update(input, inputOffset, inputLen, input, inputOffset);
    }

    protected static byte[] resize(byte[] data, int size) {
        if (data.length > size) {
            byte[] tmp = new byte[size];
            System.arraycopy(data, 0, tmp, 0, size);
            data = tmp;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        BaseCipher baseCipher = this;
        synchronized (baseCipher) {
            if (this.s == null) {
                this.s = this.getClass().getSimpleName() + "[" + this.getAlgorithm() + "," + this.getIVSize() + "," + this.getBlockSize() + "," + this.getTransformation() + "]";
            }
        }
        return this.s;
    }
}

