/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.editparts.CompositeActivityEditPart;
import org.eclipse.bpel.ui.editparts.borders.ContainerBorder;
import org.eclipse.bpel.ui.editparts.borders.DrawerBorder;
import org.eclipse.bpel.ui.editparts.borders.LeafBorder;
import org.eclipse.bpel.ui.editparts.figures.CollapsableContainerFigure;
import org.eclipse.bpel.ui.editparts.util.BPELDecorationLayout;
import org.eclipse.bpel.ui.figures.CenteredConnectionAnchor;
import org.eclipse.bpel.ui.figures.ILayoutAware;
import org.eclipse.bpel.ui.util.BPELDragEditPartsTracker;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.marker.BPELEditPartMarkerDecorator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Image;

public abstract class CollapsableEditPart
extends CompositeActivityEditPart
implements ILayoutAware {
    protected boolean collapsed;
    protected Image image;
    protected Image topImage;
    protected Image bottomImage;
    protected Label collapsedLabel;
    protected IFigure contentFigure;
    protected BPELEditPartMarkerDecorator editPartMarkerDecorator;
    protected Adapter childrenAdapter;

    public CollapsableEditPart() {
        this(false);
    }

    public CollapsableEditPart(boolean collapsed) {
        this.collapsed = collapsed;
    }

    protected void initializeLabels() {
        this.collapsedLabel = new Label(this.getLabel());
        this.image = this.getImg();
    }

    private boolean isGenericContainerBorder() {
        Border border = this.getContentPane().getBorder();
        return border != null && border instanceof ContainerBorder;
    }

    @Override
    protected DrawerBorder getDrawerBorder() {
        Border border = this.getContentPane().getBorder();
        if (border instanceof DrawerBorder) {
            return (DrawerBorder)border;
        }
        return null;
    }

    @Override
    public Label getLabelFigure() {
        if (this.isGenericContainerBorder()) {
            ContainerBorder border = (ContainerBorder)this.getContentPane().getBorder();
            return border.getLabel();
        }
        return this.collapsedLabel;
    }

    @Override
    protected IFigure createFigure() {
        IFigure figure;
        this.initializeLabels();
        this.editPartMarkerDecorator = new BPELEditPartMarkerDecorator((EObject)this.getModel(), new CollapsableDecorationLayout(this.image.getBounds().width));
        this.editPartMarkerDecorator.addMarkerMotionListener(this.getMarkerMotionListener());
        this.contentFigure = figure = this.getNewContentPane(this.editPartMarkerDecorator.getDecorationLayer());
        figure.setForegroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("COLOR_BLACK"));
        if (this.isCollapsed()) {
            this.addCollapsedContents(figure);
        } else {
            this.configureExpandedFigure(figure);
        }
        return this.editPartMarkerDecorator.createFigure(figure);
    }

    protected IFigure getNewContentPane(Layer layer) {
        CollapsableContainerFigure fig = new CollapsableContainerFigure(this.getModel(), this.image, this.getLabel());
        fig.addMouseMotionListener(this.getMouseMotionListener());
        fig.setEditPart(this);
        return fig;
    }

    protected CollapsableContainerFigure getContentFigure() {
        return (CollapsableContainerFigure)this.contentFigure;
    }

    protected void notifyCollapsed(boolean collapsed) {
    }

    public void setCollapsed(boolean collapsed) {
        if (!this.isCollapsable()) {
            return;
        }
        if (this.isCollapsed() == collapsed) {
            return;
        }
        this.collapsed = collapsed;
        if (this.isGenericContainerBorder()) {
            this.getContentFigure().setCollapsed(collapsed);
        }
        this.notifyCollapsed(collapsed);
        IFigure figure = this.getContentPane();
        if (this.isCollapsed()) {
            this.refreshChildren();
            int size = figure.getChildren().size();
            int i = 0;
            while (i < size) {
                figure.remove((IFigure)figure.getChildren().get(0));
                ++i;
            }
            this.addCollapsedContents(figure);
        } else {
            int size = figure.getChildren().size();
            int i = 0;
            while (i < size) {
                figure.remove((IFigure)figure.getChildren().get(0));
                ++i;
            }
            this.configureExpandedFigure(figure);
            this.refreshChildren();
        }
        this.refreshSourceConnections();
        this.refreshTargetConnections();
        this.refreshDrawerImages();
        this.getFigure().repaint();
    }

    public boolean isCollapsed() {
        if (this.isGenericContainerBorder()) {
            return this.getContentFigure().isCollapsed();
        }
        return this.collapsed;
    }

    protected boolean isCollapsable() {
        return true;
    }

    protected void unregisterVisuals() {
        this.image = null;
        this.editPartMarkerDecorator = null;
        this.topImage = null;
        this.bottomImage = null;
        super.unregisterVisuals();
    }

    protected void addCollapsedContents(IFigure figure) {
        figure.setLayoutManager((LayoutManager)new FlowLayout());
        if (!this.isGenericContainerBorder()) {
            LeafBorder lBorder = new LeafBorder(figure);
            lBorder.setEditPart(this);
            figure.setBorder((Border)lBorder);
            figure.addMouseMotionListener(this.getMouseMotionListener());
            figure.add((IFigure)this.collapsedLabel);
        }
    }

    @Override
    protected List getModelChildren() {
        if (this.isCollapsed()) {
            return Collections.EMPTY_LIST;
        }
        return this.getExpandedChildren();
    }

    protected boolean isPointInCollapseIcon(Point point) {
        if (this.isGenericContainerBorder()) {
            return this.getContentFigure().isPointInCollapseImage(point.x, point.y);
        }
        return true;
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new BPELDragEditPartsTracker((EditPart)this){

            protected boolean handleDoubleClick(int button) {
                if (!CollapsableEditPart.this.isGenericContainerBorder()) {
                    CollapsableEditPart.this.setCollapsed(!CollapsableEditPart.this.isCollapsed());
                }
                return true;
            }

            protected boolean handleButtonDown(int button) {
                if (CollapsableEditPart.this.isGenericContainerBorder() && CollapsableEditPart.this.isPointInCollapseIcon(this.getLocation())) {
                    CollapsableEditPart.this.setCollapsed(!CollapsableEditPart.this.isCollapsed());
                    return true;
                }
                return super.handleButtonDown(button);
            }
        };
    }

    @Override
    public void refreshVisuals() {
        super.refreshVisuals();
        if (!this.isGenericContainerBorder()) {
            this.collapsedLabel.setText(this.getLabel());
        } else {
            this.getContentFigure().setName(this.getLabel());
            this.getContentFigure().revalidate();
        }
        this.editPartMarkerDecorator.refresh();
        this.refreshDrawerImages();
        this.getFigure().repaint();
    }

    protected Image getImage() {
        return this.image;
    }

    protected Image getImg() {
        ILabeledElement element = BPELUtil.adapt((Object)this.getActivity(), ILabeledElement.class);
        if (element != null) {
            return element.getSmallImage(this.getActivity());
        }
        return null;
    }

    protected String getLabel() {
        ILabeledElement element = BPELUtil.adapt((Object)this.getActivity(), ILabeledElement.class);
        if (element != null) {
            return element.getLabel(this.getActivity());
        }
        return null;
    }

    protected List getExpandedChildren() {
        return super.getModelChildren();
    }

    protected abstract void configureExpandedFigure(IFigure var1);

    @Override
    protected List<Link> getModelSourceConnections() {
        List<Link> result = super.getModelSourceConnections();
        return result;
    }

    @Override
    protected List<Link> getModelTargetConnections() {
        List<Link> result = super.getModelTargetConnections();
        return result;
    }

    public IFigure getContentPane() {
        return this.contentFigure;
    }

    public Label getCollapsedLabel() {
        return this.collapsedLabel;
    }

    protected void refreshDrawerImages() {
        DrawerBorder border = (DrawerBorder)this.getContentPane().getBorder();
        if (this.topImage != null) {
            this.topImage.dispose();
            this.topImage = null;
        }
        if (this.bottomImage != null) {
            this.bottomImage.dispose();
            this.bottomImage = null;
        }
        IMarkerHolder holder = BPELUtil.adapt((Object)this.getActivity(), IMarkerHolder.class);
        int topMarkerPriority = Integer.MIN_VALUE;
        int bottomMarkerPriority = Integer.MIN_VALUE;
        IMarker topMarker = null;
        IMarker bottomMarker = null;
        IMarker[] iMarkerArray = holder.getMarkers(this.getActivity());
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.visible", true)) {
                int priority;
                String value = marker.getAttribute("org.eclipse.bpel.common.ui.graphicalMarker.anchorPoint", EMPTY_STRING);
                if (value.equals("DRAWER_TOP")) {
                    priority = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.priority", 0);
                    if (priority > topMarkerPriority) {
                        topMarkerPriority = priority;
                        this.topImage = BPELUtil.getImage(marker);
                        topMarker = marker;
                    }
                } else if (value.equals("DRAWER_BOTTOM") && (priority = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.priority", 0)) > bottomMarkerPriority) {
                    bottomMarkerPriority = priority;
                    this.bottomImage = BPELUtil.getImage(marker);
                    bottomMarker = marker;
                }
            }
            ++n2;
        }
        border.setTopImage(this.topImage);
        border.setBottomImage(this.bottomImage);
        border.setTopMarker(topMarker);
        border.setBottomMarker(bottomMarker);
    }

    @Override
    public ConnectionAnchor getConnectionAnchor(int location) {
        switch (location) {
            case 4: {
                return new CenteredConnectionAnchor(this.getFigure(), location, 30);
            }
            case 2: {
                return new CenteredConnectionAnchor(this.getFigure(), 6, 0);
            }
            case 3: {
                return new CenteredConnectionAnchor(this.getFigure(), 7, 0);
            }
        }
        return super.getConnectionAnchor(location);
    }

    public class CollapsableDecorationLayout
    extends BPELDecorationLayout {
        private int borderImageWidth;

        public CollapsableDecorationLayout(int borderImageWidth) {
            this.borderImageWidth = borderImageWidth;
        }

        protected Point calculateLocation(int locationHint, IFigure container, Dimension childDimension) {
            Rectangle area = container.getClientArea();
            switch (locationHint) {
                case 2: {
                    return new Point(area.x + area.width / 2 - childDimension.width / 2, area.y + area.height / 2 - childDimension.height / 2);
                }
                case 8: {
                    return new Point(area.x + area.width / 2 - childDimension.width / 2, area.y + this.borderImageWidth / 2);
                }
                case 32: {
                    return new Point(area.x + area.width / 2 - childDimension.width / 2, area.y + area.height - childDimension.height);
                }
                case 1: {
                    int x = area.x + 16;
                    int y = area.y + area.height / 2 - childDimension.width / 2;
                    if (!CollapsableEditPart.this.isCollapsed()) {
                        y += 6;
                    }
                    return new Point(x, y);
                }
                case 4: {
                    int x = area.x + area.width - childDimension.width - 16;
                    int y = area.y + area.height / 2 - childDimension.width / 2;
                    if (!CollapsableEditPart.this.isCollapsed()) {
                        y += 6;
                    }
                    return new Point(x, y);
                }
                case 9: {
                    int x = area.x + 16;
                    int y = area.y + this.borderImageWidth / 2;
                    if (!CollapsableEditPart.this.isCollapsed()) {
                        y += CollapsableEditPart.this.collapsedLabel.getSize().height / 2 - 3;
                    }
                    return new Point(x, y);
                }
                case 12: {
                    int x = area.x + area.width - childDimension.width - 16;
                    int y = area.y + this.borderImageWidth / 2;
                    if (!CollapsableEditPart.this.isCollapsed()) {
                        y += CollapsableEditPart.this.collapsedLabel.getSize().height / 2 - 3;
                    } else {
                        --x;
                    }
                    return new Point(x, y);
                }
                case 33: {
                    int x = area.x + 16;
                    int y = area.y + area.height - 7;
                    y = !CollapsableEditPart.this.isCollapsed() ? (y -= 6) : (y -= 12);
                    return new Point(x, y);
                }
                case 36: {
                    int x = area.x + area.width - childDimension.width - 16;
                    int y = area.y + area.height - 7;
                    if (!CollapsableEditPart.this.isCollapsed()) {
                        y -= 6;
                    } else {
                        y -= 12;
                        --x;
                    }
                    return new Point(x, y);
                }
            }
            return new Point(area.x, area.y);
        }
    }
}

