/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.details.viewers.CComboViewer;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.bpelactions.AbstractBPELAction;
import org.eclipse.bpel.ui.bpelactions.SimpleAction;
import org.eclipse.bpel.ui.details.providers.AbstractContentProvider;
import org.eclipse.bpel.ui.details.providers.ModelViewerSorter;
import org.eclipse.bpel.ui.extensions.ActionCategoryDescriptor;
import org.eclipse.bpel.ui.extensions.ActionDescriptor;
import org.eclipse.bpel.ui.extensions.BPELUIRegistry;
import org.eclipse.bpel.ui.factories.AbstractUIObjectFactory;
import org.eclipse.bpel.ui.factories.ActionUIObjectFactory;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ActionImplementationSection
extends BPELPropertySection {
    protected Browser description;
    protected CCombo categoryCombo;
    protected CComboViewer categoryViewer;
    protected Composite buttonsComposite;
    protected List buttonsList = new ArrayList();

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        this.createImplementationWidgets(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.bpel.ui.property_action");
    }

    public void createImplementationWidgets(Composite parent) {
        Composite left = this.getWidgetFactory().createComposite(parent);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.top = new FlatFormAttachment(0, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        left.setLayoutData((Object)data);
        left.setLayout((Layout)new GridLayout(1, false));
        Composite combos = this.getWidgetFactory().createComposite(left);
        combos.setLayoutData((Object)new GridData(256));
        combos.setLayout((Layout)new GridLayout(2, false));
        Label categoryLabel = this.getWidgetFactory().createLabel(combos, Messages.ActionImplementationSection_Action_Category_1);
        categoryLabel.setLayoutData((Object)new GridData(32));
        this.categoryCombo = this.getWidgetFactory().createCCombo(combos);
        Composite chooseActionComposite = this.getWidgetFactory().createComposite(left);
        chooseActionComposite.setLayoutData((Object)new GridData(256));
        chooseActionComposite.setLayout((Layout)new GridLayout(1, false));
        Label chooseActionLabel = this.getWidgetFactory().createLabel(chooseActionComposite, Messages.ActionImplementationSection_Choose_one_of_these_actions_2);
        chooseActionLabel.setLayoutData((Object)new GridData(32));
        this.buttonsComposite = this.getWidgetFactory().createComposite(left);
        this.buttonsComposite.setLayoutData((Object)new GridData(1808));
        this.buttonsComposite.setLayout((Layout)new RowLayout());
        Composite right = this.getWidgetFactory().createComposite(parent);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)left);
        data.top = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        right.setLayoutData((Object)data);
        right.setLayout((Layout)new GridLayout(1, false));
        Label descriptionLabel = this.getWidgetFactory().createLabel(right, Messages.ActionImplementationSection_Description_3);
        descriptionLabel.setLayoutData((Object)new GridData(32));
        descriptionLabel.setToolTipText(Messages.ActionImplementationSection_Hover_tooltip_4);
        this.description = new Browser(right, 0);
        this.description.setLayoutData((Object)new GridData(1808));
        this.categoryViewer = new CComboViewer(this.categoryCombo);
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ActionCategoryDescriptor) {
                    return ((ActionCategoryDescriptor)element).getName();
                }
                return super.getText(element);
            }
        });
        this.categoryViewer.setContentProvider((IContentProvider)new AbstractContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        this.categoryViewer.setSorter((ViewerSorter)ModelViewerSorter.getInstance());
        this.categoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    ActionCategoryDescriptor category = (ActionCategoryDescriptor)((IStructuredSelection)event.getSelection()).getFirstElement();
                    ActionImplementationSection.this.createActionButtons(category);
                }
            }
        });
        ActionCategoryDescriptor[] categories = BPELUIRegistry.getInstance().getActionCategoryDescriptors();
        this.categoryViewer.setInput((Object)categories);
    }

    @Override
    public void refresh() {
        super.refresh();
        ActionCategoryDescriptor[] categories = BPELUIRegistry.getInstance().getActionCategoryDescriptors();
        this.categoryViewer.setSelection((ISelection)new StructuredSelection((Object)categories[0]));
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected void createActionButtons(ActionCategoryDescriptor category) {
        for (Button button : this.buttonsList) {
            button.dispose();
        }
        ActionDescriptor[] descriptors = BPELUIRegistry.getInstance().getActionDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            AbstractBPELAction action;
            ActionDescriptor descriptor = descriptors[i];
            if ((!ModelHelper.isSpecCompliant((EObject)this.getProcess()) || descriptor.isSpecCompliant()) && !((action = descriptor.getAction()) instanceof SimpleAction) && descriptor.getCategoryId().equals(category.getId())) {
                final Object currentModel = this.getModel();
                final BPELEditor editor = ModelHelper.getBPELEditor(this.getProcess());
                final AbstractUIObjectFactory factory = action.getUIObjectFactory();
                Button button = this.getWidgetFactory().createButton(this.buttonsComposite, String.valueOf(i), 8);
                button.setImage(factory.getSmallImage());
                button.setToolTipText(action.getLabel());
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        ActionImplementationSection.this.description.setText("<HTML>" + action.getDescription() + "</HTML>");
                    }
                };
                button.addListener(6, listener);
                button.addListener(15, listener);
                button.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        try {
                            EObject parent = ActionImplementationSection.this.getModel().eContainer();
                            Object newModel = factory instanceof ActionUIObjectFactory ? ((ActionUIObjectFactory)factory).createInstance(parent) : factory.createInstance();
                            Command command = action.getChangeActionTypeCommand(parent, currentModel, newModel);
                            command = ActionImplementationSection.this.wrapInShowContextCommand(command);
                            editor.getCommandStack().execute(command);
                            ActionImplementationSection.this.selectModelObject((EObject)newModel);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            return;
                        }
                    }
                });
                this.buttonsList.add(button);
            }
            ++i;
        }
        this.buttonsComposite.layout(true);
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.description.setText(Messages.ActionImplementationSection_HTML_hover_description_text_5);
    }
}

