/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.upc.ast;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTSimpleDeclSpecifier;

public class UPCASTSimpleDeclSpecifier
extends CASTSimpleDeclSpecifier
implements IUPCASTSimpleDeclSpecifier {
    private int referenceType;
    private int sharedQualifier;
    private IASTExpression blockSizeExpression;

    public UPCASTSimpleDeclSpecifier() {
    }

    public UPCASTSimpleDeclSpecifier(IASTExpression blockSizeExpression) {
        this.setBlockSizeExpression(blockSizeExpression);
    }

    @Override
    public UPCASTSimpleDeclSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public UPCASTSimpleDeclSpecifier copy(IASTNode.CopyStyle style) {
        UPCASTSimpleDeclSpecifier copy = new UPCASTSimpleDeclSpecifier();
        copy.referenceType = this.referenceType;
        copy.sharedQualifier = this.sharedQualifier;
        copy.setBlockSizeExpression(this.blockSizeExpression == null ? null : this.blockSizeExpression.copy(style));
        return (UPCASTSimpleDeclSpecifier)this.copy(copy, style);
    }

    @Override
    public IASTExpression getBlockSizeExpression() {
        return this.blockSizeExpression;
    }

    @Override
    public int getReferenceType() {
        return this.referenceType;
    }

    @Override
    public int getSharedQualifier() {
        return this.sharedQualifier;
    }

    @Override
    public void setBlockSizeExpression(IASTExpression expr) {
        this.blockSizeExpression = expr;
        if (expr != null) {
            expr.setParent((IASTNode)this);
            expr.setPropertyInParent(BLOCK_SIZE_EXPRESSION);
        }
    }

    @Override
    public void setReferenceType(int referenceType) {
        this.referenceType = referenceType;
    }

    @Override
    public void setSharedQualifier(int shared) {
        this.sharedQualifier = shared;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit((IASTDeclSpecifier)this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.blockSizeExpression != null && !this.blockSizeExpression.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave((IASTDeclSpecifier)this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

