/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.InferiorRuntimeProcess;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.DebugNewProcessSequence;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.MIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.MIInferiorProcess;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.osgi.framework.BundleContext;

public class GDBProcesses
extends MIProcesses
implements IGDBProcesses {
    private IGDBControl fGdb;
    private IGDBBackend fBackend;
    private CommandFactory fCommandFactory;
    private boolean fConnected;
    private Map<Integer, String> fProcessNames = new HashMap<Integer, String>();
    private String fProcId;
    private PTY fPty;

    public GDBProcesses(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBProcesses.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fGdb = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.fBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.register(new String[]{IProcesses.class.getName(), IMIProcesses.class.getName(), IGDBProcesses.class.getName(), MIProcesses.class.getName(), GDBProcesses.class.getName()}, new Hashtable());
        this.getSession().addServiceEventListener((Object)this, null);
        requestMonitor.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    @Override
    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    @Override
    public IMIContainerDMContext createContainerContext(IProcesses.IProcessDMContext processDmc, String groupId) {
        return new GDBContainerDMC(this.getSession().getId(), processDmc, groupId);
    }

    @Override
    public IMIContainerDMContext createContainerContextFromGroupId(ICommandControlService.ICommandControlDMContext controlDmc, String groupId) {
        IProcesses.IProcessDMContext processDmc = this.fProcId != null ? this.createProcessContext(controlDmc, this.fProcId) : this.createProcessContext(controlDmc, "");
        return this.createContainerContext(processDmc, groupId);
    }

    @Override
    public void getExecutionData(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof IMIProcessDMContext) {
            String pidStr = ((IMIProcessDMContext)dmc).getProcId();
            if (pidStr == null || pidStr.length() == 0) {
                pidStr = this.fProcId;
            }
            int pid = -1;
            try {
                pid = Integer.parseInt(pidStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String name = this.fProcessNames.get(pid);
            if (name == null && this.fProcId != null && Integer.parseInt(this.fProcId) == pid) {
                name = this.fBackend.getProgramPath().lastSegment();
            }
            if (name == null) {
                name = "Unknown name";
                name = this.fBackend.getProgramPath().lastSegment();
            }
            rm.setData((Object)new MIProcesses.MIThreadDMData(name, pidStr));
            rm.done();
        } else {
            super.getExecutionData(dmc, rm);
        }
    }

    @Override
    public void isDebuggerAttachSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        if (this.fBackend.getIsAttachSession() && !this.fConnected) {
            rm.setData((Object)true);
        } else {
            rm.setData((Object)false);
        }
        rm.done();
    }

    @Override
    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, DataRequestMonitor<IDMContext> rm) {
        this.attachDebuggerToProcess(procCtx, null, rm);
    }

    @Override
    public void attachDebuggerToProcess(final IProcesses.IProcessDMContext procCtx, String binaryPath, final DataRequestMonitor<IDMContext> rm) {
        IMIContainerDMContext containerDmc = this.createContainerContext(procCtx, "");
        ImmediateDataRequestMonitor<MIInfo> attachRm = new ImmediateDataRequestMonitor<MIInfo>(rm){

            protected void handleSuccess() {
                GDBProcesses.access$3(GDBProcesses.this, procCtx, (DataRequestMonitor)new ImmediateDataRequestMonitor<IDMContext>((RequestMonitor)rm){

                    protected void handleSuccess() {
                        GDBProcesses.this.fProcId = ((IMIProcessDMContext)procCtx).getProcId();
                        IDMContext ctx = (IDMContext)this.getData();
                        rm.setData((Object)ctx);
                        ImmediateExecutor.getInstance().execute((Runnable)new Sequence(GDBProcesses.this.getExecutor(), (RequestMonitor)rm, ctx){
                            private Sequence.Step[] fSteps;
                            {
                                this.fSteps = new Sequence.Step[]{new Sequence.Step(){

                                    public void execute(RequestMonitor memoryDataRm) {
                                        IGDBMemory memory = (IGDBMemory)GDBProcesses.this.getServicesTracker().getService(IGDBMemory.class);
                                        IMemory.IMemoryDMContext memContext = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)iDMContext, IMemory.IMemoryDMContext.class);
                                        if (memory == null || memContext == null) {
                                            memoryDataRm.done();
                                            return;
                                        }
                                        memory.initializeMemoryData(memContext, memoryDataRm);
                                    }
                                }, new Sequence.Step(){

                                    public void execute(RequestMonitor trackBpRm) {
                                        MIBreakpointsManager bpmService = (MIBreakpointsManager)((Object)GDBProcesses.this.getServicesTracker().getService(MIBreakpointsManager.class));
                                        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)iDMContext, IRunControl.IContainerDMContext.class);
                                        bpmService.startTrackingBpForProcess(containerDmc, trackBpRm);
                                    }
                                }};
                            }

                            public Sequence.Step[] getSteps() {
                                return this.fSteps;
                            }
                        });
                    }
                });
            }
        };
        if (binaryPath != null) {
            this.fGdb.queueCommand(this.fCommandFactory.createMIFileExecAndSymbols(containerDmc, binaryPath), (DataRequestMonitor)attachRm);
            return;
        }
        attachRm.done();
    }

    @Override
    public void canDetachDebuggerFromProcess(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        if (this.fConnected) {
            rm.setData((Object)true);
        } else {
            rm.setData((Object)false);
        }
        rm.done();
    }

    @Override
    public void detachDebuggerFromProcess(IDMContext dmc, final RequestMonitor rm) {
        super.detachDebuggerFromProcess(dmc, new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GDBProcesses.this.fProcId = null;
                rm.done();
            }
        });
    }

    @Override
    public void debugNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        ImmediateExecutor.getInstance().execute((Runnable)this.getDebugNewProcessSequence(this.getExecutor(), true, dmc, file, attributes, rm));
    }

    protected Sequence getDebugNewProcessSequence(DsfExecutor executor, boolean isInitial, IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        return new DebugNewProcessSequence(executor, isInitial, dmc, file, attributes, rm);
    }

    @Override
    public void getProcessesBeingDebugged(IDMContext dmc, DataRequestMonitor<IDMContext[]> rm) {
        if (this.fConnected) {
            super.getProcessesBeingDebugged(dmc, rm);
        } else {
            rm.setData((Object)new IDMContext[0]);
            rm.done();
        }
    }

    @Override
    public void getRunningProcesses(IDMContext dmc, DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        if (this.fBackend.getSessionType() == SessionType.LOCAL) {
            IProcessList list = null;
            try {
                list = CCorePlugin.getDefault().getProcessList();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (list == null) {
                this.fProcessNames.clear();
                rm.setData(null);
            } else {
                IProcessInfo[] procInfos;
                this.fProcessNames.clear();
                IProcessInfo[] iProcessInfoArray = procInfos = list.getProcessList();
                int n = procInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcessInfo procInfo = iProcessInfoArray[n2];
                    this.fProcessNames.put(procInfo.getPid(), procInfo.getName());
                    ++n2;
                }
                rm.setData((Object)this.makeProcessDMCs(controlDmc, procInfos));
            }
            rm.done();
        } else {
            this.fProcessNames.clear();
            rm.setData((Object)new IProcesses.IProcessDMContext[0]);
            rm.done();
        }
    }

    private IProcesses.IProcessDMContext[] makeProcessDMCs(ICommandControlService.ICommandControlDMContext controlDmc, IProcessInfo[] processes) {
        IProcesses.IProcessDMContext[] procDmcs = new IMIProcessDMContext[processes.length];
        int i = 0;
        while (i < procDmcs.length) {
            procDmcs[i] = this.createProcessContext(controlDmc, Integer.toString(processes[i].getPid()));
            ++i;
        }
        return procDmcs;
    }

    @Override
    public void terminate(IProcesses.IThreadDMContext thread, final RequestMonitor rm) {
        if (this.fBackend.getSessionType() == SessionType.CORE) {
            this.fGdb.terminate(rm);
        } else if (thread instanceof IMIProcessDMContext) {
            this.getDebuggingContext(thread, (DataRequestMonitor<IDMContext>)new ImmediateDataRequestMonitor<IDMContext>(rm){

                protected void handleSuccess() {
                    if (this.getData() instanceof IMIContainerDMContext) {
                        IMIRunControl runControl = (IMIRunControl)GDBProcesses.this.getServicesTracker().getService(IMIRunControl.class);
                        if (runControl != null && !runControl.isTargetAcceptingCommands()) {
                            GDBProcesses.this.fBackend.interrupt();
                        }
                        final IMIContainerDMContext container = (IMIContainerDMContext)this.getData();
                        GDBProcesses.this.fGdb.queueCommand(GDBProcesses.this.fCommandFactory.createMIInterpreterExecConsoleKill(container), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                            protected void handleSuccess() {
                                GDBProcesses.this.getSession().dispatchEvent((Object)new MIProcesses.ContainerExitedDMEvent(container), GDBProcesses.this.getProperties());
                                rm.done();
                            }
                        });
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
                        rm.done();
                    }
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    @Override
    public IMIExecutionDMContext[] getExecutionContexts(IMIContainerDMContext containerDmc) {
        assert (false);
        return null;
    }

    @Override
    public void canRestart(IRunControl.IContainerDMContext containerDmc, DataRequestMonitor<Boolean> rm) {
        if (this.fBackend.getIsAttachSession() || this.fBackend.getSessionType() == SessionType.CORE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (this.fBackend.getSessionType() == SessionType.REMOTE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        rm.setData((Object)true);
        rm.done();
    }

    @Override
    public void restart(IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        if (runControl != null && !runControl.isTargetAcceptingCommands()) {
            this.fBackend.interrupt();
        }
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(this.fGdb.getContext(), "");
        IMIContainerDMContext newContainerDmc = this.createContainerContext(processDmc, "");
        this.startOrRestart(newContainerDmc, attributes, true, rm);
    }

    @Override
    public void start(IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        this.startOrRestart(containerDmc, attributes, false, rm);
    }

    protected void initializeInputOutput(IRunControl.IContainerDMContext containerDmc, final RequestMonitor rm) {
        if (this.fBackend.getSessionType() == SessionType.REMOTE || this.fBackend.getIsAttachSession()) {
            this.fPty = null;
            rm.done();
        } else {
            try {
                this.fPty = new PTY();
                this.fPty.validateSlaveName();
                this.fGdb.queueCommand(this.fCommandFactory.createMIInferiorTTYSet((IMIContainerDMContext)containerDmc, this.fPty.getSlaveName()), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                    protected void handleFailure() {
                        GDBProcesses.this.fPty = null;
                        rm.done();
                    }
                });
            }
            catch (IOException e) {
                this.fPty = null;
                rm.done();
            }
        }
    }

    protected void createConsole(final IRunControl.IContainerDMContext containerDmc, final boolean restart, final RequestMonitor rm) {
        if (this.fBackend.getSessionType() == SessionType.REMOTE || this.fBackend.getIsAttachSession()) {
            rm.done();
            return;
        }
        this.initializeInputOutput(containerDmc, (RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                MIInferiorProcess inferiorProcess = GDBProcesses.this.fPty == null ? new MIInferiorProcess(containerDmc, GDBProcesses.this.fBackend.getMIOutputStream()) : new MIInferiorProcess(containerDmc, GDBProcesses.this.fPty);
                MIInferiorProcess inferior = inferiorProcess;
                String label = GDBProcesses.this.fBackend.getProgramPath().lastSegment();
                ILaunch launch = (ILaunch)GDBProcesses.this.getSession().getModelAdapter(ILaunch.class);
                DebugPlugin.getDefault().asyncExec(() -> {
                    if (restart) {
                        IProcess[] launchProcesses;
                        IProcess[] iProcessArray = launchProcesses = launch.getProcesses();
                        int n = launchProcesses.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProcess p = iProcessArray[n2];
                            if (p instanceof InferiorRuntimeProcess) {
                                launch.removeProcess(p);
                                break;
                            }
                            ++n2;
                        }
                    }
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.inferiorProcess");
                    IProcess runtimeInferior = DebugPlugin.newProcess((ILaunch)launch, (Process)inferior, (String)label, attributes);
                    runtimeInferior.setAttribute("org.eclipse.cdt.dsf.gdb.inferiorGroupId", "");
                    rm.done();
                });
            }
        });
    }

    protected void startOrRestart(IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, boolean restart, DataRequestMonitor<IRunControl.IContainerDMContext> requestMonitor) {
        if (this.fBackend.getIsAttachSession()) {
            requestMonitor.setData((Object)containerDmc);
            requestMonitor.done();
            return;
        }
        this.createConsole(containerDmc, restart, (RequestMonitor)new ImmediateRequestMonitor((RequestMonitor)requestMonitor, (DataRequestMonitor)requestMonitor, containerDmc, attributes){
            private final /* synthetic */ DataRequestMonitor val$requestMonitor;
            private final /* synthetic */ IRunControl.IContainerDMContext val$containerDmc;
            private final /* synthetic */ Map val$attributes;
            {
                this.val$requestMonitor = dataRequestMonitor;
                this.val$containerDmc = iContainerDMContext;
                this.val$attributes = map;
                super($anonymous0);
            }

            protected void handleSuccess() {
                DataRequestMonitor<MIInfo> execMonitor = new DataRequestMonitor<MIInfo>((Executor)GDBProcesses.this.getExecutor(), (RequestMonitor)this.val$requestMonitor){

                    protected void handleSuccess() {
                        if (GDBProcesses.this.fBackend.getSessionType() != SessionType.REMOTE) {
                            GDBProcesses.this.getSession().dispatchEvent((Object)new MIProcesses.ContainerStartedDMEvent(val$containerDmc), GDBProcesses.this.getProperties());
                        }
                        val$requestMonitor.setData((Object)val$containerDmc);
                        val$requestMonitor.done();
                    }
                };
                final ICommand<MIInfo> execCommand = GDBProcesses.this.useContinueCommand() ? GDBProcesses.this.fCommandFactory.createMIExecContinue((IRunControl.IExecutionDMContext)this.val$containerDmc) : GDBProcesses.this.fCommandFactory.createMIExecRun((IRunControl.IExecutionDMContext)this.val$containerDmc);
                boolean stopInMain = (Boolean)CDebugUtils.getAttribute((Map)this.val$attributes, (String)"org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", (Object)LaunchUtils.getStopAtMainDefault());
                if (!stopInMain) {
                    GDBProcesses.this.fGdb.queueCommand(execCommand, (DataRequestMonitor)execMonitor);
                } else {
                    String stopSymbol = (String)CDebugUtils.getAttribute((Map)this.val$attributes, (String)"org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", (Object)LaunchUtils.getStopAtMainSymbolDefault());
                    IBreakpoints.IBreakpointsTargetDMContext bpTarget = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.val$containerDmc, IBreakpoints.IBreakpointsTargetDMContext.class);
                    GDBProcesses.this.fGdb.queueCommand(GDBProcesses.this.fCommandFactory.createMIBreakInsert(bpTarget, true, false, null, 0, stopSymbol, "0"), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)GDBProcesses.this.getExecutor(), (RequestMonitor)this.val$requestMonitor, (DataRequestMonitor)execMonitor){
                        private final /* synthetic */ DataRequestMonitor val$execMonitor;
                        {
                            this.val$execMonitor = dataRequestMonitor;
                            super($anonymous0, $anonymous1);
                        }

                        protected void handleSuccess() {
                            GDBProcesses.this.fGdb.queueCommand(execCommand, this.val$execMonitor);
                        }
                    });
                }
            }
        });
    }

    protected boolean useContinueCommand() {
        return this.fBackend.getSessionType() == SessionType.REMOTE;
    }

    @Override
    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent e) {
        if (e.getDMContext() instanceof IRunControl.IContainerDMContext) {
            this.fConnected = true;
        }
        super.eventDispatched(e);
    }

    @Override
    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e.getDMContext() instanceof IRunControl.IContainerDMContext) {
            this.fConnected = false;
            if (Platform.getPreferencesService().getBoolean("org.eclipse.cdt.dsf.gdb", "autoTerminateGdb", true, null)) {
                this.fGdb.terminate((RequestMonitor)new ImmediateRequestMonitor());
            }
        }
        super.eventDispatched(e);
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
    }

    static /* synthetic */ void access$3(GDBProcesses gDBProcesses, IProcesses.IProcessDMContext iProcessDMContext, DataRequestMonitor dataRequestMonitor) {
        super.attachDebuggerToProcess(iProcessDMContext, (DataRequestMonitor<IDMContext>)dataRequestMonitor);
    }

    private class GDBContainerDMC
    extends MIProcesses.MIContainerDMC
    implements IMemory.IMemoryDMContext {
        public GDBContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            super(sessionId, processDmc, groupId);
        }
    }
}

