/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.internal.qt.ui.Activator;
import org.eclipse.cdt.internal.qt.ui.editor.QtProjectFileKeyword;
import org.eclipse.cdt.internal.qt.ui.pro.parser.QtProjectFileModifier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class QtProjectFileUpdateJob
extends Job {
    private List<IResourceDelta> deltaList;

    public QtProjectFileUpdateJob(List<IResourceDelta> deltas) {
        super("Update Qt Project File(s)");
        this.deltaList = deltas;
    }

    private IFile findQtProjectFile(IProject project) throws CoreException {
        IResource[] iResourceArray = project.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member.getType() == 1 && member.getFileExtension().equals("pro")) {
                return (IFile)member;
            }
            ++n2;
        }
        return null;
    }

    protected IStatus run(IProgressMonitor monitor) {
        HashMap<IProject, QtProjectFileModifier> modifierMap = new HashMap<IProject, QtProjectFileModifier>();
        HashMap<IProject, IFile> projectFileMap = new HashMap<IProject, IFile>();
        for (IResourceDelta delta : this.deltaList) {
            String value;
            String newValue;
            String oldValue;
            IResource resource = delta.getResource();
            IProject project = resource.getProject();
            QtProjectFileModifier modifier = (QtProjectFileModifier)modifierMap.get(project);
            if (modifier == null) {
                IFile proFile = null;
                try {
                    proFile = this.findQtProjectFile(project);
                }
                catch (CoreException e) {
                    Activator.log("Unable to find Qt Project File", e);
                }
                if (proFile == null) continue;
                projectFileMap.put(project, proFile);
                StringBuilder sb = new StringBuilder();
                try {
                    Throwable throwable = null;
                    Object var12_17 = null;
                    try (InputStream is = proFile.getContents();){
                        int read = -1;
                        while ((read = is.read()) > 0) {
                            sb.append((char)read);
                        }
                        Document document = new Document(sb.toString());
                        modifier = new QtProjectFileModifier((IDocument)document);
                        modifierMap.put(project, modifier);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Activator.log(e);
                    break;
                }
                catch (CoreException e) {
                    Activator.log(e);
                    break;
                }
            }
            String variableKeyword = null;
            if ("cpp".equals(resource.getFileExtension())) {
                variableKeyword = QtProjectFileKeyword.VAR_SOURCES.getKeyword();
            } else if ("h".equals(resource.getFileExtension())) {
                variableKeyword = QtProjectFileKeyword.VAR_HEADERS.getKeyword();
            }
            if ((delta.getFlags() & 0x1000) <= 0 ? (delta.getFlags() & 0x2000) > 0 && project.getFullPath().isPrefixOf(delta.getMovedToPath()) : project.getFullPath().isPrefixOf(delta.getMovedFromPath()) && modifier.replaceVariableValue(variableKeyword, oldValue = delta.getMovedFromPath().makeRelativeTo(project.getFullPath()).toString(), newValue = resource.getProjectRelativePath().toString())) continue;
            if ((delta.getKind() & 1) > 0) {
                value = resource.getProjectRelativePath().toString();
                if (value == null) continue;
                modifier.addVariableValue(variableKeyword, value);
                continue;
            }
            if ((delta.getKind() & 2) <= 0 || (value = resource.getProjectRelativePath().toString()) == null) continue;
            modifier.removeVariableValue(variableKeyword, value);
        }
        for (IProject project : projectFileMap.keySet()) {
            IFile file = (IFile)projectFileMap.get(project);
            IDocument document = ((QtProjectFileModifier)modifierMap.get(project)).getDocument();
            try {
                file.setContents((InputStream)new ByteArrayInputStream(document.get().getBytes()), 0, null);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return Status.OK_STATUS;
    }
}

