/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view;

import org.eclipse.cdt.testsrunner.internal.TestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.internal.model.TestingSessionsManager;
import org.eclipse.cdt.testsrunner.internal.ui.view.ProgressCountPanel;
import org.eclipse.cdt.testsrunner.internal.ui.view.ResultsPanel;
import org.eclipse.cdt.testsrunner.internal.ui.view.UIUpdater;
import org.eclipse.cdt.testsrunner.internal.ui.view.UIViewMessages;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.HistoryDropDownAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.RerunAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ScrollLockAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ShowFailedOnlyAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ShowFileNameOnlyAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ShowNextFailureAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ShowPreviousFailureAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ShowTestsInHierarchyAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ShowTimeAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.StopAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ToggleOrientationAction;
import org.eclipse.cdt.testsrunner.model.ITestingSession;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class ResultsView
extends ViewPart {
    private Composite parent;
    private ProgressCountPanel progressCountPanel;
    private ResultsPanel resultsPanel;
    private UIUpdater uiUpdater;
    private TestingSessionsManager sessionsManager;
    private boolean isDisposed = false;
    private Action nextAction;
    private Action previousAction;
    private Action rerunAction;
    private Action stopAction;
    private ToggleOrientationAction[] toggleOrientationActions;
    private Action historyAction;
    private Action showFailedOnly;
    private Action showTestsInHierarchyAction;
    private Action showTimeAction;
    private Action scrollLockAction;
    private Action showFileNameOnlyAction;
    private Orientation orientation = Orientation.Auto;
    private Orientation currentOrientation;
    private IMemento memento;
    static final String TAG_ORIENTATION = "orientation";
    static final String TAG_SHOW_FAILED_ONLY = "showFailedOnly";
    static final String TAG_SHOW_TESTS_IN_HIERARCHY = "showTestsInHierarchy";
    static final String TAG_SHOW_TIME = "showTime";
    static final String TAG_SCROLL_LOCK = "scrollLock";
    static final String TAG_SHOW_FILE_NAME_ONLY_ACTION = "showFileNameOnly";
    static final String TAG_HISTORY_SIZE = "history_size";

    public void createPartControl(Composite parent) {
        this.sessionsManager = TestsRunnerPlugin.getDefault().getTestingSessionsManager();
        IWorkbench workbench = TestsRunnerPlugin.getDefault().getWorkbench();
        Clipboard clipboard = new Clipboard(parent.getDisplay());
        this.parent = parent;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.currentOrientation = this.getActualOrientation();
        this.progressCountPanel = new ProgressCountPanel(parent, this.currentOrientation);
        this.resultsPanel = new ResultsPanel(parent, this.sessionsManager, workbench, this.getViewSite(), clipboard);
        this.uiUpdater = new UIUpdater(this, this.resultsPanel.getTestsHierarchyViewer(), this.progressCountPanel, this.sessionsManager);
        this.configureActionsBars();
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                ResultsView.this.computeOrientation();
            }
        });
        this.restoreState(this.memento);
        this.uiUpdater.reapplyActiveSession();
    }

    public void setFocus() {
        this.resultsPanel.getTestsHierarchyViewer().getTreeViewer().getControl().setFocus();
    }

    private void configureActionsBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.toggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, Orientation.Vertical), new ToggleOrientationAction(this, Orientation.Horizontal), new ToggleOrientationAction(this, Orientation.Auto)};
        this.nextAction = new ShowNextFailureAction(this.resultsPanel.getTestsHierarchyViewer());
        this.nextAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.nextAction);
        this.previousAction = new ShowPreviousFailureAction(this.resultsPanel.getTestsHierarchyViewer());
        this.previousAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.previousAction);
        this.showFailedOnly = new ShowFailedOnlyAction(this.resultsPanel);
        this.showTestsInHierarchyAction = new ShowTestsInHierarchyAction(this.resultsPanel.getTestsHierarchyViewer());
        this.showTimeAction = new ShowTimeAction(this.resultsPanel.getTestsHierarchyViewer());
        this.scrollLockAction = new ScrollLockAction(this.uiUpdater);
        this.showFileNameOnlyAction = new ShowFileNameOnlyAction(this.resultsPanel.getMessagesViewer());
        this.rerunAction = new RerunAction(this.sessionsManager);
        this.rerunAction.setEnabled(false);
        this.stopAction = new StopAction(this.sessionsManager);
        this.stopAction.setEnabled(false);
        this.historyAction = new HistoryDropDownAction(this.sessionsManager, this.parent.getShell());
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.nextAction);
        toolBar.add((IAction)this.previousAction);
        toolBar.add((IAction)this.showFailedOnly);
        toolBar.add((IAction)this.scrollLockAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.rerunAction);
        toolBar.add((IAction)this.stopAction);
        toolBar.add((IAction)this.historyAction);
        IMenuManager viewMenu = actionBars.getMenuManager();
        viewMenu.add((IAction)this.showTestsInHierarchyAction);
        viewMenu.add((IAction)this.showTimeAction);
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(UIViewMessages.ResultsView_layout_menu_text);
        int i = 0;
        while (i < this.toggleOrientationActions.length) {
            layoutSubMenu.add((IAction)this.toggleOrientationActions[i]);
            ++i;
        }
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.showFailedOnly);
        viewMenu.add((IAction)this.showFileNameOnlyAction);
    }

    public void dispose() {
        this.isDisposed = true;
        if (this.uiUpdater != null) {
            this.uiUpdater.dispose();
        }
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.computeOrientation();
    }

    private void computeOrientation() {
        Orientation newActualOrientation = this.getActualOrientation();
        if (newActualOrientation != this.currentOrientation) {
            this.currentOrientation = newActualOrientation;
            this.progressCountPanel.setPanelOrientation(this.currentOrientation);
            this.resultsPanel.setPanelOrientation(this.currentOrientation);
            int i = 0;
            while (i < this.toggleOrientationActions.length) {
                this.toggleOrientationActions[i].setChecked(this.orientation == this.toggleOrientationActions[i].getOrientation());
                ++i;
            }
            this.parent.layout();
        }
    }

    private Orientation getActualOrientation() {
        switch (this.orientation) {
            case Horizontal: 
            case Vertical: {
                return this.orientation;
            }
            case Auto: {
                Point size = this.parent.getSize();
                return size.x > size.y ? Orientation.Horizontal : Orientation.Vertical;
            }
        }
        return null;
    }

    public void updateActionsFromSession() {
        ITestingSession session = this.sessionsManager.getActiveSession();
        boolean hasErrors = session != null && session.hasErrors();
        this.previousAction.setEnabled(hasErrors);
        this.nextAction.setEnabled(hasErrors);
        this.rerunAction.setEnabled(session != null && session.isFinished());
        this.stopAction.setEnabled(session != null && !session.isFinished());
    }

    public void setCaption(String message) {
        this.setContentDescription(message);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    private void restoreActionChecked(IMemento memento, String key, Action action) {
        Boolean checked = memento.getBoolean(key);
        if (checked != null) {
            action.setChecked(checked.booleanValue());
            action.run();
        }
    }

    private void restoreState(IMemento memento) {
        if (memento != null) {
            Integer orientationIndex = memento.getInteger(TAG_ORIENTATION);
            if (orientationIndex != null) {
                this.setOrientation(Orientation.values()[orientationIndex]);
            }
            this.resultsPanel.restoreState(memento);
            this.restoreActionChecked(memento, TAG_SHOW_FAILED_ONLY, this.showFailedOnly);
            this.restoreActionChecked(memento, TAG_SHOW_TESTS_IN_HIERARCHY, this.showTestsInHierarchyAction);
            this.restoreActionChecked(memento, TAG_SHOW_TIME, this.showTimeAction);
            this.restoreActionChecked(memento, TAG_SCROLL_LOCK, this.scrollLockAction);
            this.restoreActionChecked(memento, TAG_SHOW_FILE_NAME_ONLY_ACTION, this.showFileNameOnlyAction);
            Integer historySize = memento.getInteger(TAG_HISTORY_SIZE);
            if (historySize != null) {
                this.sessionsManager.setHistorySizeLimit(historySize);
            }
        }
    }

    public void saveState(IMemento memento) {
        if (this.parent == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
            return;
        }
        memento.putInteger(TAG_ORIENTATION, this.orientation.ordinal());
        this.resultsPanel.saveState(memento);
        memento.putBoolean(TAG_SHOW_FAILED_ONLY, this.showFailedOnly.isChecked());
        memento.putBoolean(TAG_SHOW_TESTS_IN_HIERARCHY, this.showTestsInHierarchyAction.isChecked());
        memento.putBoolean(TAG_SHOW_TIME, this.showTimeAction.isChecked());
        memento.putBoolean(TAG_SCROLL_LOCK, this.scrollLockAction.isChecked());
        memento.putBoolean(TAG_SHOW_FILE_NAME_ONLY_ACTION, this.showFileNameOnlyAction.isChecked());
        memento.putInteger(TAG_HISTORY_SIZE, this.sessionsManager.getHistorySizeLimit());
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public static enum Orientation {
        Horizontal,
        Vertical,
        Auto;

    }
}

