/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.wizards.export;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.corrosion.CommandJob;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.corrosion.wizards.export.CargoExportWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class CargoExportWizard
extends Wizard
implements IExportWizard {
    private CargoExportWizardPage wizardPage;

    public CargoExportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.CargoExportWizard_title);
        Iterator selectionIterator = selection.iterator();
        IProject project = null;
        while (selectionIterator.hasNext() && project == null) {
            IResource resource = (IResource)selectionIterator.next();
            if (!resource.getProject().getFile("Cargo.toml").exists()) continue;
            project = resource.getProject();
        }
        this.wizardPage = new CargoExportWizardPage(project);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        final IProject project = this.wizardPage.getProject();
        String toolchain = this.wizardPage.getToolchain();
        Boolean noVerify = this.wizardPage.noVerify();
        Boolean noMetadata = this.wizardPage.noMetadata();
        Boolean allowDirty = this.wizardPage.allowDirty();
        ArrayList<String> exportCommandList = new ArrayList<String>();
        exportCommandList.add(CargoTools.getCargoCommand());
        exportCommandList.add("package");
        if (noVerify.booleanValue()) {
            exportCommandList.add("--no-verify");
        }
        if (noMetadata.booleanValue()) {
            exportCommandList.add("--no-metadata");
        }
        if (allowDirty.booleanValue()) {
            exportCommandList.add("--allow-dirty");
        }
        if (!toolchain.isEmpty()) {
            exportCommandList.add("--target");
            exportCommandList.add(toolchain);
        }
        exportCommandList.add("--manifest-path");
        exportCommandList.add(project.getFile("Cargo.toml").getLocation().toString());
        CommandJob packageCommandJob = new CommandJob(exportCommandList.toArray(new String[exportCommandList.size()]), "Cargo Package", Messages.CargoExportWizard_cannotCreateProject, Messages.CargoExportWizard_cannotCreateProject_details, 0);
        packageCommandJob.setUser(true);
        packageCommandJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult() == Status.OK_STATUS) {
                    try {
                        project.refreshLocal(2, null);
                    }
                    catch (CoreException e) {
                        CorrosionPlugin.logError(e);
                    }
                }
            }
        });
        packageCommandJob.schedule();
        return true;
    }
}

