/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.navigation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageElement;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageFragment;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageSourceModule;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesFragment;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesSourceModule;
import org.eclipse.dltk.tcl.internal.ui.TclImages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TclModelLabelProvider
extends LabelProvider {
    private Map<ImageDescriptor, Image> registry = new HashMap<ImageDescriptor, Image>();

    public String getText(Object element) {
        if (element instanceof TclPackageFragment) {
            return ((TclPackageFragment)element).getPackageName();
        }
        if (element instanceof TclSourcesFragment) {
            return "Sources";
        }
        if (element instanceof TclPackageElement) {
            TclPackageElement pkg = (TclPackageElement)element;
            String result = pkg.getPackageName();
            if (pkg.getVersion() != null) {
                result = String.valueOf(result) + " " + pkg.getVersion();
            }
            return result;
        }
        if (element instanceof TclPackageSourceModule) {
            TclPackageSourceModule module = (TclPackageSourceModule)element;
            return String.valueOf(module.getElementName()) + " (" + module.getStorage().getFullPath().toString() + ")";
        }
        if (element instanceof TclSourcesSourceModule) {
            String postFix;
            TclSourcesSourceModule module = (TclSourcesSourceModule)element;
            IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)module.getScriptProject());
            String originalName = module.getOriginalName();
            String convertedPath = environment.convertPathToString(module.getFullPath());
            IFileHandle file = EnvironmentPathUtils.getFile((IModelElement)module);
            boolean exists = file != null && file.exists();
            String string = postFix = exists ? "" : " [Not available]";
            if (originalName != null && !originalName.equals(convertedPath)) {
                return String.valueOf(originalName) + " (" + convertedPath + ")" + postFix;
            }
            return String.valueOf(convertedPath) + postFix;
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof TclSourcesFragment) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.library_src_obj.png");
        }
        if (element instanceof IScriptFolder) {
            if (element instanceof TclPackageElement || element instanceof TclSourcesFragment) {
                return null;
            }
            return this.getScriptFolderIcon();
        }
        return null;
    }

    private Image getScriptFolderIcon() {
        return this.getImageFor(TclImages.DESC_OBJS_FOLDER);
    }

    private Image getImageFor(ImageDescriptor descriptor) {
        Image image = this.registry.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.registry.put(descriptor, image);
        }
        return image;
    }
}

