/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.EclipseAuthenticator;
import org.eclipse.egit.core.EclipseProxySelector;
import org.eclipse.egit.core.EclipseSshSessionFactory;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.EGitSshdSessionFactory;
import org.eclipse.egit.core.internal.ReportingTypedConfigGetter;
import org.eclipse.egit.core.internal.ResourceRefreshHandler;
import org.eclipse.egit.core.internal.SshPreferencesMirror;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.op.IgnoreOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.securestorage.EGitSecureStore;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.WorkingTreeModifiedListener;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.TypedConfigGetter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.eclipse.jgit.transport.http.JDKHttpConnectionFactory;
import org.eclipse.jgit.transport.http.apache.HttpClientConnectionFactory;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends Plugin
implements DebugOptionsListener {
    private static Activator plugin;
    private static String pluginId;
    private RepositoryCache repositoryCache;
    private IndexDiffCache indexDiffCache;
    private RepositoryUtil repositoryUtil;
    private EGitSecureStore secureStore;
    private AutoShareProjects shareGitProjectsJob;
    private IResourceChangeListener preDeleteProjectListener;
    private IgnoreDerivedResources ignoreDerivedResourcesListener;
    private MergeStrategyRegistryListener mergeStrategyRegistryListener;
    private IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener;
    private ServiceTracker<IProxyService, IProxyService> proxyServiceTracker;
    private ListenerHandle refreshHandle;

    public static Activator getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return pluginId;
    }

    public static IStatus error(String message, Throwable thr) {
        return new Status(4, Activator.getPluginId(), 0, message, thr);
    }

    public static IStatus cancel(String message, Throwable thr) {
        return new Status(8, Activator.getPluginId(), 0, message, thr);
    }

    public static void logError(String message, Throwable thr) {
        Activator.getDefault().getLog().log(Activator.error(message, thr));
    }

    public static void logInfo(String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(1, Activator.getPluginId(), 0, message, null));
    }

    public static IStatus warning(String message, Throwable thr) {
        return new Status(2, Activator.getPluginId(), 0, message, thr);
    }

    public static void logWarning(String message, Throwable thr) {
        Activator.getDefault().getLog().log(Activator.warning(message, thr));
    }

    public Activator() {
        Activator.setActivator(this);
    }

    private static void setActivator(Activator a) {
        plugin = a;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        pluginId = context.getBundle().getSymbolicName();
        FS.setAsyncFileStoreAttributes((boolean)true);
        SystemReader.setInstance((SystemReader)new EclipseSystemReader(SystemReader.getInstance()));
        Config.setTypedConfigGetter((TypedConfigGetter)new ReportingTypedConfigGetter());
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        ((Dictionary)props).put("listener.symbolic.name", pluginId);
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        this.setupHttp();
        SshPreferencesMirror.INSTANCE.start();
        this.proxyServiceTracker = new ServiceTracker(context, IProxyService.class.getName(), null);
        this.proxyServiceTracker.open();
        this.setupSSH(context);
        this.preferenceChangeListener = event -> {
            if ("core_ssh_client".equals(event.getKey())) {
                this.setupSSH(this.getBundle().getBundleContext());
            } else if ("core_http_client".equals(event.getKey())) {
                this.setupHttp();
            }
        };
        InstanceScope.INSTANCE.getNode(pluginId).addPreferenceChangeListener(this.preferenceChangeListener);
        this.setupProxy();
        this.repositoryCache = new RepositoryCache();
        this.indexDiffCache = new IndexDiffCache();
        try {
            GitProjectData.reconfigureWindowCache();
        }
        catch (RuntimeException e) {
            Activator.logError(CoreText.Activator_ReconfigureWindowCacheError, e);
        }
        GitProjectData.attachToWorkspace();
        this.setupResourceRefresh();
        this.repositoryUtil = new RepositoryUtil();
        this.secureStore = new EGitSecureStore(SecurePreferencesFactory.getDefault());
        this.registerAutoShareProjects();
        this.registerAutoIgnoreDerivedResources();
        this.registerPreDeleteResourceChangeListener();
        this.registerMergeStrategyRegistryListener();
        this.registerBuiltinLFS();
    }

    private void setupSSH(BundleContext context) {
        String sshClient = Platform.getPreferencesService().getString(pluginId, "core_ssh_client", "apache", null);
        SshSessionFactory previous = SshSessionFactory.getInstance();
        if (SshClientType.JSCH.name().equalsIgnoreCase(sshClient)) {
            if (previous instanceof EclipseSshSessionFactory) {
                return;
            }
            ServiceReference ssh = context.getServiceReference(IJSchService.class.getName());
            if (ssh != null) {
                SshSessionFactory.setInstance((SshSessionFactory)new EclipseSshSessionFactory((IJSchService)context.getService(ssh)));
            } else {
                Activator.logWarning(CoreText.Activator_SshClientNoJsch, null);
                if (previous instanceof EGitSshdSessionFactory) {
                    return;
                }
                SshSessionFactory.setInstance((SshSessionFactory)new EGitSshdSessionFactory());
            }
        } else {
            if (!SshClientType.APACHE.name().equalsIgnoreCase(sshClient)) {
                Activator.logWarning(MessageFormat.format(CoreText.Activator_SshClientUnknown, sshClient), null);
            }
            if (previous instanceof EGitSshdSessionFactory) {
                return;
            }
            SshSessionFactory.setInstance((SshSessionFactory)new EGitSshdSessionFactory());
        }
        if (previous instanceof SshdSessionFactory) {
            ((SshdSessionFactory)previous).close();
        }
    }

    private void setupHttp() {
        String sshClient = Platform.getPreferencesService().getString(pluginId, "core_http_client", "jdk", null);
        if (HttpClientType.APACHE.name().equalsIgnoreCase(sshClient)) {
            HttpTransport.setConnectionFactory((HttpConnectionFactory)new HttpClientConnectionFactory());
        } else {
            if (!HttpClientType.JDK.name().equalsIgnoreCase(sshClient)) {
                Activator.logWarning(MessageFormat.format(CoreText.Activator_HttpClientUnknown, sshClient), null);
            }
            HttpTransport.setConnectionFactory((HttpConnectionFactory)new JDKHttpConnectionFactory());
        }
    }

    private void setupProxy() {
        IProxyService proxy = this.getProxyService();
        if (proxy != null) {
            ProxySelector.setDefault(new EclipseProxySelector(proxy));
            Authenticator.setDefault(new EclipseAuthenticator(proxy));
        }
    }

    private void setupResourceRefresh() {
        this.refreshHandle = this.repositoryCache.getGlobalListenerList().addWorkingTreeModifiedListener((WorkingTreeModifiedListener)new ResourceRefreshHandler());
    }

    private void registerPreDeleteResourceChangeListener() {
        if (this.preDeleteProjectListener == null) {
            this.preDeleteProjectListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IResource resource = event.getResource();
                    if (resource instanceof IProject) {
                        IProject project = (IProject)resource;
                        if (project.isAccessible()) {
                            IResource dotGit;
                            if (ResourceUtil.isSharedWithGit((IResource)project) && (dotGit = project.findMember(".git")) != null && dotGit.getType() == 2) {
                                GitProjectData.reconfigureWindowCache();
                            }
                        } else {
                            File locationDir;
                            File dotGit;
                            IPath locationPath = project.getLocation();
                            if (locationPath != null && (dotGit = new File(locationDir = locationPath.toFile(), ".git")).exists() && dotGit.isDirectory()) {
                                GitProjectData.reconfigureWindowCache();
                            }
                        }
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.preDeleteProjectListener, 4);
        }
    }

    private void registerBuiltinLFS() {
        if (Platform.getBundle((String)"org.eclipse.jgit.lfs") != null) {
            try {
                Class<?> lfs = Class.forName("org.eclipse.jgit.lfs.BuiltinLFS");
                if (lfs != null) {
                    lfs.getMethod("register", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                Activator.logWarning(CoreText.Activator_noBuiltinLfsSupportDetected, e1);
            }
        }
    }

    public void optionsChanged(DebugOptions options) {
        GitTraceLocation.initializeFromOptions(options, this.isDebugging());
    }

    public MergeStrategy getPreferredMergeStrategy() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(Activator.getPluginId());
        String preferredMergeStrategyKey = prefs.get("core_preferredMergeStrategy", null);
        if (preferredMergeStrategyKey == null || preferredMergeStrategyKey.isEmpty()) {
            IEclipsePreferences defaultPrefs = DefaultScope.INSTANCE.getNode(Activator.getPluginId());
            preferredMergeStrategyKey = defaultPrefs.get("core_preferredMergeStrategy", null);
        }
        if (preferredMergeStrategyKey != null && !preferredMergeStrategyKey.isEmpty() && !"jgit-default-mergeStrategy".equals(preferredMergeStrategyKey)) {
            MergeStrategy result = MergeStrategy.get((String)preferredMergeStrategyKey);
            if (result != null) {
                return result;
            }
            Activator.logError(NLS.bind((String)CoreText.Activator_invalidPreferredMergeStrategy, (Object)preferredMergeStrategyKey), null);
        }
        return null;
    }

    public Collection<MergeStrategyDescriptor> getRegisteredMergeStrategies() {
        if (this.mergeStrategyRegistryListener == null) {
            return Collections.emptyList();
        }
        return this.mergeStrategyRegistryListener.getStrategies();
    }

    private void registerMergeStrategyRegistryListener() {
        this.mergeStrategyRegistryListener = new MergeStrategyRegistryListener(Platform.getExtensionRegistry());
        Platform.getExtensionRegistry().addListener((IRegistryEventListener)this.mergeStrategyRegistryListener, "org.eclipse.egit.core.mergeStrategy");
    }

    public RepositoryCache getRepositoryCache() {
        return this.repositoryCache;
    }

    public IndexDiffCache getIndexDiffCache() {
        return this.indexDiffCache;
    }

    public RepositoryUtil getRepositoryUtil() {
        return this.repositoryUtil;
    }

    public EGitSecureStore getSecureStore() {
        return this.secureStore;
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.proxyServiceTracker.getService();
    }

    public void stop(BundleContext context) throws Exception {
        SshSessionFactory current;
        SshPreferencesMirror.INSTANCE.stop();
        if (this.preferenceChangeListener != null) {
            InstanceScope.INSTANCE.getNode(pluginId).removePreferenceChangeListener(this.preferenceChangeListener);
            this.preferenceChangeListener = null;
        }
        if ((current = SshSessionFactory.getInstance()) instanceof SshdSessionFactory) {
            ((SshdSessionFactory)current).close();
        }
        if (this.proxyServiceTracker != null) {
            this.proxyServiceTracker.close();
            this.proxyServiceTracker = null;
        }
        if (this.mergeStrategyRegistryListener != null) {
            Platform.getExtensionRegistry().removeListener((IRegistryEventListener)this.mergeStrategyRegistryListener);
            this.mergeStrategyRegistryListener = null;
        }
        if (this.preDeleteProjectListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.preDeleteProjectListener);
            this.preDeleteProjectListener = null;
        }
        if (this.ignoreDerivedResourcesListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.ignoreDerivedResourcesListener);
            this.ignoreDerivedResourcesListener.stop();
            this.ignoreDerivedResourcesListener = null;
        }
        if (this.refreshHandle != null) {
            this.refreshHandle.remove();
            this.refreshHandle = null;
        }
        if (this.shareGitProjectsJob != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.shareGitProjectsJob);
            this.shareGitProjectsJob.stop();
            this.shareGitProjectsJob = null;
        }
        GitProjectData.detachFromWorkspace();
        this.indexDiffCache.dispose();
        this.indexDiffCache = null;
        this.repositoryCache.clear();
        this.repositoryCache = null;
        this.repositoryUtil.dispose();
        this.repositoryUtil = null;
        this.secureStore = null;
        Config.setTypedConfigGetter(null);
        super.stop(context);
        plugin = null;
    }

    private void registerAutoShareProjects() {
        this.shareGitProjectsJob = new AutoShareProjects();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.shareGitProjectsJob, 1);
    }

    private static boolean isValidRepositoryPath(@NonNull IPath gitDirPath) {
        Path userHomePath;
        if (gitDirPath.segmentCount() == 0) {
            return false;
        }
        IPath workingDir = gitDirPath.removeLastSegments(1);
        if (workingDir.isRoot()) {
            return false;
        }
        File userHome = FS.DETECTED.userHome();
        return userHome == null || !workingDir.isPrefixOf((IPath)(userHomePath = new Path(userHome.getAbsolutePath())));
    }

    private void registerAutoIgnoreDerivedResources() {
        this.ignoreDerivedResourcesListener = new IgnoreDerivedResources();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.ignoreDerivedResourcesListener, 1);
    }

    public static boolean autoIgnoreDerived() {
        IEclipsePreferences d = DefaultScope.INSTANCE.getNode(Activator.getPluginId());
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode(Activator.getPluginId());
        return p.getBoolean("core_autoIgnoreDerivedResources", d.getBoolean("core_autoIgnoreDerivedResources", true));
    }

    public static boolean autoStageDeletion() {
        IEclipsePreferences d = DefaultScope.INSTANCE.getNode(Activator.getPluginId());
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode(Activator.getPluginId());
        boolean autoStageDeletion = p.getBoolean("core_auto_stage_deletion", d.getBoolean("core_auto_stage_deletion", false));
        return autoStageDeletion;
    }

    public static boolean autoStageMoves() {
        IEclipsePreferences d = DefaultScope.INSTANCE.getNode(Activator.getPluginId());
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode(Activator.getPluginId());
        boolean autoStageMoves = p.getBoolean("core_auto_stage_moves", d.getBoolean("core_auto_stage_moves", false));
        return autoStageMoves;
    }

    private static class AutoShareProjects
    implements IResourceChangeListener {
        private static int INTERESTING_CHANGES = 16385;
        private final CheckProjectsToShare checkProjectsJob = new CheckProjectsToShare();

        private boolean doAutoShare() {
            IEclipsePreferences d = DefaultScope.INSTANCE.getNode(Activator.getPluginId());
            IEclipsePreferences p = InstanceScope.INSTANCE.getNode(Activator.getPluginId());
            return p.getBoolean("core_autoShareProjects", d.getBoolean("core_autoShareProjects", true));
        }

        public void stop() {
            boolean isRunning = !this.checkProjectsJob.cancel();
            Job.getJobManager().cancel(JobFamilies.AUTO_SHARE);
            try {
                if (isRunning) {
                    this.checkProjectsJob.join();
                }
                Job.getJobManager().join(JobFamilies.AUTO_SHARE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!this.doAutoShare()) {
                return;
            }
            try {
                final LinkedHashSet<IProject> projectCandidates = new LinkedHashSet<IProject>();
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        return this.collectOpenedProjects(delta, projectCandidates);
                    }
                });
                if (!projectCandidates.isEmpty()) {
                    this.checkProjectsJob.addProjectsToCheck(projectCandidates);
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
                return;
            }
        }

        private boolean collectOpenedProjects(IResourceDelta delta, Set<IProject> projects) {
            if (delta.getKind() == 4 && (delta.getFlags() & INTERESTING_CHANGES) == 0) {
                return true;
            }
            IResource resource = delta.getResource();
            if (resource.getType() == 8) {
                return true;
            }
            if (resource.getType() != 4) {
                return false;
            }
            if (!resource.isAccessible() || resource.getLocation() == null) {
                return false;
            }
            projects.add((IProject)resource);
            return false;
        }
    }

    private static class CheckProjectsToShare
    extends Job {
        private Object lock = new Object();
        private Set<IProject> projectCandidates = new LinkedHashSet<IProject>();

        public CheckProjectsToShare() {
            super(CoreText.Activator_AutoShareJobName);
            this.setUser(false);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectsToCheck(Set<IProject> projects) {
            Object object = this.lock;
            synchronized (object) {
                this.projectCandidates.addAll(projects);
                if (!this.projectCandidates.isEmpty()) {
                    this.schedule(100L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Set<IProject> projectsToCheck;
            Object object = this.lock;
            synchronized (object) {
                projectsToCheck = this.projectCandidates;
                this.projectCandidates = new LinkedHashSet<IProject>();
            }
            if (projectsToCheck.isEmpty()) {
                return Status.OK_STATUS;
            }
            HashMap<IProject, File> projects = new HashMap<IProject, File>();
            for (IProject project : projectsToCheck) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!project.isAccessible()) continue;
                try {
                    this.visitConnect(project, projects);
                }
                catch (CoreException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (projects.size() > 0) {
                ConnectProviderOperation op = new ConnectProviderOperation(projects);
                op.setRefreshResources(false);
                JobUtil.scheduleUserJob(op, CoreText.Activator_AutoShareJobName, JobFamilies.AUTO_SHARE);
            }
            return Status.OK_STATUS;
        }

        private void visitConnect(IProject project, Map<IProject, File> projects) throws CoreException {
            if (RepositoryMapping.getMapping(project) != null) {
                return;
            }
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider != null) {
                return;
            }
            RepositoryFinder f = new RepositoryFinder(project);
            f.setFindInChildren(false);
            List<RepositoryMapping> mappings = f.find((IProgressMonitor)new NullProgressMonitor());
            if (mappings.isEmpty()) {
                return;
            }
            RepositoryMapping m = mappings.get(0);
            IPath gitDirPath = m.getGitDirAbsolutePath();
            if (gitDirPath == null || !Activator.isValidRepositoryPath(gitDirPath)) {
                return;
            }
            File repositoryDir = gitDirPath.toFile();
            projects.put(project, repositoryDir);
            Set<String> configured = Activator.getDefault().getRepositoryUtil().getRepositories();
            if (configured.contains(gitDirPath.toString())) {
                return;
            }
            int nofMappings = mappings.size();
            if (nofMappings > 1) {
                IPath lastPath = gitDirPath;
                int i = 1;
                while (i < nofMappings) {
                    IPath nextPath = mappings.get(i).getGitDirAbsolutePath();
                    if (nextPath != null) {
                        if (configured.contains(nextPath.toString())) {
                            return;
                        }
                        if (!Activator.isValidRepositoryPath(nextPath)) break;
                        lastPath = nextPath;
                    }
                    ++i;
                }
                repositoryDir = lastPath.toFile();
            }
            try {
                Activator.getDefault().getRepositoryUtil().addConfiguredRepository(repositoryDir);
            }
            catch (IllegalArgumentException e) {
                Activator.logError(CoreText.Activator_AutoSharingFailed, e);
            }
        }
    }

    private static class EclipseSystemReader
    extends SystemReader {
        private static final String[] HIDDEN_VARIABLES = new String[]{"GIT_DIR", "GIT_WORK_TREE", "GIT_OBJECT_DIRECTORY", "GIT_INDEX_FILE", "GIT_ALTERNATE_OBJECT_DIRECTORIES"};
        private final SystemReader delegate;

        public EclipseSystemReader(SystemReader delegate) {
            this.delegate = delegate;
        }

        public String getenv(String variable) {
            String result = this.delegate.getenv(variable);
            if (result == null) {
                return result;
            }
            boolean isWin = this.isWindows();
            String[] stringArray = HIDDEN_VARIABLES;
            int n = HIDDEN_VARIABLES.length;
            int n2 = 0;
            while (n2 < n) {
                String gitvar = stringArray[n2];
                if (isWin && gitvar.equalsIgnoreCase(variable) || !isWin && gitvar.equals(variable)) {
                    return null;
                }
                ++n2;
            }
            return result;
        }

        public String getHostname() {
            return this.delegate.getHostname();
        }

        public String getProperty(String key) {
            return this.delegate.getProperty(key);
        }

        public FileBasedConfig openUserConfig(Config parent, FS fs) {
            return this.delegate.openUserConfig(parent, fs);
        }

        public FileBasedConfig openJGitConfig(Config parent, FS fs) {
            return this.delegate.openJGitConfig(parent, fs);
        }

        public FileBasedConfig openSystemConfig(Config parent, FS fs) {
            return this.delegate.openSystemConfig(parent, fs);
        }

        public long getCurrentTime() {
            return this.delegate.getCurrentTime();
        }

        public int getTimezone(long when) {
            return this.delegate.getTimezone(when);
        }

        public StoredConfig getUserConfig() throws IOException, ConfigInvalidException {
            return this.delegate.getUserConfig();
        }

        public StoredConfig getJGitConfig() throws IOException, ConfigInvalidException {
            return this.delegate.getJGitConfig();
        }

        public StoredConfig getSystemConfig() throws IOException, ConfigInvalidException {
            return this.delegate.getSystemConfig();
        }
    }

    private static enum HttpClientType {
        JDK,
        APACHE;

    }

    private static class IgnoreDerivedResources
    implements IResourceChangeListener {
        private IgnoreDerivedResources() {
        }

        public void stop() {
            Job.getJobManager().cancel(JobFamilies.AUTO_IGNORE);
            try {
                Job.getJobManager().join(JobFamilies.AUTO_IGNORE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                IResourceDelta d = event.getDelta();
                if (d == null || !Activator.autoIgnoreDerived()) {
                    return;
                }
                final LinkedHashSet<IPath> toBeIgnored = new LinkedHashSet<IPath>();
                d.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if ((delta.getKind() & 5) == 0) {
                            return false;
                        }
                        int flags = delta.getFlags();
                        if (flags != 0 && (flags & 0x400000) == 0) {
                            return false;
                        }
                        IResource r = delta.getResource();
                        if (r.getProject() != null && RepositoryMapping.getMapping(r) == null) {
                            return false;
                        }
                        if (r.isTeamPrivateMember()) {
                            return false;
                        }
                        if (r.isDerived()) {
                            try {
                                IPath location = r.getLocation();
                                if (RepositoryUtil.canBeAutoIgnored(location)) {
                                    toBeIgnored.add(location);
                                }
                            }
                            catch (IOException e) {
                                Activator.logError(MessageFormat.format(CoreText.Activator_ignoreResourceFailed, r.getFullPath()), e);
                            }
                            return false;
                        }
                        return true;
                    }
                });
                if (toBeIgnored.size() > 0) {
                    JobUtil.scheduleUserJob(new IgnoreOperation(toBeIgnored), CoreText.Activator_autoIgnoreDerivedResources, JobFamilies.AUTO_IGNORE);
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
                return;
            }
        }
    }

    public static class MergeStrategyDescriptor {
        private final String name;
        private final String label;
        private final Class<?> implementedBy;

        public MergeStrategyDescriptor(String name, String label, Class<?> implementedBy) {
            this.name = name;
            this.label = label;
            this.implementedBy = implementedBy;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public Class<?> getImplementedBy() {
            return this.implementedBy;
        }
    }

    private static class MergeStrategyRegistryListener
    implements IRegistryEventListener {
        private Map<String, MergeStrategyDescriptor> strategies = new LinkedHashMap<String, MergeStrategyDescriptor>();

        private MergeStrategyRegistryListener(IExtensionRegistry registry) {
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.egit.core.mergeStrategy");
            this.loadMergeStrategies(elements);
        }

        private Collection<MergeStrategyDescriptor> getStrategies() {
            return Collections.unmodifiableCollection(this.strategies.values());
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                this.loadMergeStrategies(extension.getConfigurationElements());
                ++n2;
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        Object ext = element.createExecutableExtension("class");
                        if (ext instanceof MergeStrategy) {
                            MergeStrategy strategy = (MergeStrategy)ext;
                            this.strategies.remove(strategy.getName());
                        }
                    }
                    catch (CoreException e) {
                        Activator.logError(CoreText.MergeStrategy_UnloadError, e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }

        private void loadMergeStrategies(IConfigurationElement[] elements) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    Object ext = element.createExecutableExtension("class");
                    if (ext instanceof MergeStrategy) {
                        MergeStrategy strategy = (MergeStrategy)ext;
                        String name = element.getAttribute("name");
                        if (name == null || name.isEmpty()) {
                            name = strategy.getName();
                        }
                        if (this.canRegister(name, strategy)) {
                            if (MergeStrategy.get((String)name) == null) {
                                MergeStrategy.register((String)name, (MergeStrategy)strategy);
                            }
                            this.strategies.put(name, new MergeStrategyDescriptor(name, element.getAttribute("label"), strategy.getClass()));
                        }
                    }
                }
                catch (CoreException e) {
                    Activator.logError(CoreText.MergeStrategy_LoadError, e);
                }
                ++n2;
            }
        }

        private boolean canRegister(String name, MergeStrategy strategy) {
            boolean result = true;
            if (name == null || name.isEmpty()) {
                Activator.logError(NLS.bind((String)CoreText.MergeStrategy_MissingName, strategy.getClass()), null);
                result = false;
            } else if (this.strategies.containsKey(name)) {
                Activator.logError(NLS.bind((String)CoreText.MergeStrategy_DuplicateName, (Object[])new Object[]{name, this.strategies.get(name).getImplementedBy(), strategy.getClass()}), null);
                result = false;
            } else if (MergeStrategy.get((String)name) != null && MergeStrategy.get((String)name) != strategy) {
                Activator.logError(NLS.bind((String)CoreText.MergeStrategy_ReservedName, (Object[])new Object[]{name, MergeStrategy.get((String)name).getClass(), strategy.getClass()}), null);
                result = false;
            }
            return result;
        }
    }

    private static enum SshClientType {
        JSCH,
        APACHE;

    }
}

